/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.beans.Introspector;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangePackage;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.ESuperAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.BeanEvent;
import org.eclipse.jem.internal.beaninfo.BeaninfoFactory;
import org.eclipse.jem.internal.beaninfo.BeaninfoPackage;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.jem.internal.beaninfo.FeatureDecorator;
import org.eclipse.jem.internal.beaninfo.ImplicitItem;
import org.eclipse.jem.internal.beaninfo.IndexedPropertyDecorator;
import org.eclipse.jem.internal.beaninfo.MethodDecorator;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeanInfoAdapterMessages;
import org.eclipse.jem.internal.beaninfo.adapters.BeanInfoDecoratorUtility;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoAdapterFactory;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoProxyConstants;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoSuperAdapter;
import org.eclipse.jem.internal.beaninfo.common.BeanRecord;
import org.eclipse.jem.internal.beaninfo.common.EventSetRecord;
import org.eclipse.jem.internal.beaninfo.common.IndexedPropertyRecord;
import org.eclipse.jem.internal.beaninfo.common.MethodRecord;
import org.eclipse.jem.internal.beaninfo.common.PropertyRecord;
import org.eclipse.jem.internal.beaninfo.core.BeanInfoCacheController;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.MapJNITypes;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaEvent;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jem.util.TimerTests;
import org.eclipse.jem.util.logger.proxy.Logger;

public class BeaninfoClassAdapter
extends AdapterImpl
implements IIntrospectionAdapter {
    public static final String REFLECT_PROPERTIES = "Reflect properties";
    public static final String APPLY_EXTENSIONS = "Apply Overrides";
    public static final String REMOTE_INTROSPECT = "Remote Introspect";
    public static final String INTROSPECT = "Introspect";
    public static final String LOAD_FROM_CACHE = "Load from Cache";
    protected static final URI BAD_URI = URI.createURI((String)"baduri");
    protected boolean needsIntrospection = true;
    protected BeanInfoCacheController.ClassEntry classEntry;
    protected boolean isIntrospecting;
    protected boolean isDoingAllProperties;
    protected boolean isDoingAllOperations;
    protected boolean isDoingAllEvents;
    protected static final int NEVER_RETRIEVED_EXTENSION_DOCUMENT = 0;
    protected static final int RETRIEVED_ROOT_ONLY = 1;
    protected static final int RETRIEVED_FULL_DOCUMENT = 2;
    protected static final int CLEAR_EXTENSIONS = 3;
    protected int retrievedExtensionDocument = 0;
    protected BeaninfoAdapterFactory adapterFactory;
    private WeakReference staleFactory;
    private HashMap propertiesMap;
    private List featuresRealList;
    private HashMap operationsMap;
    private EList operationsRealList;
    private HashSet newoperations;
    private HashMap eventsMap;
    private EList eventsRealList;
    private Boolean defaultBound;
    private static final String ROOT_OVERRIDE = "..ROOT...override";
    private static final URI ROOT_URI = URI.createGenericURI((String)"X", (String)"ROOT", null);
    private static final String ROOT_FRAGMENT = "//@root";
    private static final Pattern FRAGMENT_SPLITTER = Pattern.compile("/");
    private static boolean RETRIEVED_EVENT_METHODS;
    private static Object EVENT_FACTORY_INSTANCE;
    private static java.lang.reflect.Method CREATE_EVENT_UTIL_METHOD;
    private static java.lang.reflect.Method DO_FORWARD_EVENTS_METHOD;
    private JavaClass eventListenerClass;
    private JavaClass tooManyExceptionClass;

    public static BeaninfoClassAdapter getBeaninfoClassAdapter(EObject jc) {
        return (BeaninfoClassAdapter)EcoreUtil.getExistingAdapter((Notifier)jc, (Object)IIntrospectionAdapter.ADAPTER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIntrospection() {
        Iterator beanItr = this.getJavaClass().getEAnnotationsInternal().iterator();
        while (beanItr.hasNext()) {
            EAnnotation dec = (EAnnotation)beanItr.next();
            if (!(dec instanceof BeanDecorator)) continue;
            BeanDecorator decor = (BeanDecorator)dec;
            if (decor.getImplicitDecoratorFlag() == ImplicitItem.IMPLICIT_DECORATOR_LITERAL) {
                beanItr.remove();
                ((InternalEObject)decor).eSetProxyURI(BAD_URI);
                break;
            }
            BeanInfoDecoratorUtility.clear((BeanDecorator)dec);
            break;
        }
        Iterator propItr = this.getJavaClass().getEStructuralFeaturesInternal().iterator();
        block4: while (propItr.hasNext()) {
            EStructuralFeature prop = (EStructuralFeature)propItr.next();
            Iterator pdItr = prop.getEAnnotations().iterator();
            while (pdItr.hasNext()) {
                EAnnotation dec = (EAnnotation)pdItr.next();
                if (!(dec instanceof PropertyDecorator)) continue;
                PropertyDecorator pd = (PropertyDecorator)dec;
                if (pd.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL) {
                    BeanInfoDecoratorUtility.clear(pd);
                } else {
                    pdItr.remove();
                    ((InternalEObject)pd).eSetProxyURI(BAD_URI);
                }
                if (pd.getImplicitDecoratorFlag() != ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL) continue block4;
                propItr.remove();
                ((InternalEObject)prop).eSetProxyURI(BAD_URI);
                continue block4;
            }
        }
        Iterator operItr = this.getJavaClass().getEOperationsInternal().iterator();
        while (operItr.hasNext()) {
            EOperation oper = (EOperation)operItr.next();
            Iterator mdItr = oper.getEAnnotations().iterator();
            while (mdItr.hasNext()) {
                EAnnotation dec = (EAnnotation)mdItr.next();
                if (!(dec instanceof MethodDecorator)) continue;
                MethodDecorator md = (MethodDecorator)dec;
                if (md.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL) {
                    BeanInfoDecoratorUtility.clear(md);
                } else {
                    mdItr.remove();
                    ((InternalEObject)md).eSetProxyURI(BAD_URI);
                }
                if (md.getImplicitDecoratorFlag() != ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL) break;
                operItr.remove();
                ((InternalEObject)oper).eSetProxyURI(BAD_URI);
                break;
            }
            Iterator evtItr = this.getJavaClass().getEventsGen().iterator();
            block8: while (evtItr.hasNext()) {
                JavaEvent evt = (JavaEvent)evtItr.next();
                Iterator edItr = evt.getEAnnotations().iterator();
                while (edItr.hasNext()) {
                    EAnnotation dec = (EAnnotation)edItr.next();
                    if (!(dec instanceof EventSetDecorator)) continue;
                    EventSetDecorator ed = (EventSetDecorator)dec;
                    if (ed.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL) {
                        BeanInfoDecoratorUtility.clear(ed);
                    } else {
                        edItr.remove();
                        ((InternalEObject)ed).eSetProxyURI(BAD_URI);
                    }
                    if (ed.getImplicitDecoratorFlag() != ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL) continue block8;
                    evtItr.remove();
                    ((InternalEObject)evt).eSetProxyURI(BAD_URI);
                    continue block8;
                }
            }
        }
        BeaninfoClassAdapter beaninfoClassAdapter = this;
        synchronized (beaninfoClassAdapter) {
            this.needsIntrospection = true;
        }
    }

    private void clearAll() {
        this.clearIntrospection();
        this.getJavaClass().getEAnnotationsInternal().clear();
        this.getJavaClass().getEStructuralFeaturesInternal().clear();
        this.getJavaClass().getEOperationsInternal().clear();
        this.getJavaClass().getEventsGen().clear();
        this.retrievedExtensionDocument = 0;
    }

    public BeaninfoClassAdapter(BeaninfoAdapterFactory factory) {
        this.adapterFactory = factory;
    }

    protected boolean isResourceConnected() {
        Resource res = this.getJavaClass().eResource();
        return res != null && res.isLoaded();
    }

    protected final ProxyFactoryRegistry getRegistry() {
        ProxyFactoryRegistry factory = this.adapterFactory.getRegistry();
        if (this.staleFactory != null && factory == this.staleFactory.get()) {
            factory = this.adapterFactory.recycleRegistry();
        }
        this.staleFactory = null;
        return factory;
    }

    public boolean isStale() {
        return this.staleFactory != null;
    }

    protected BeaninfoAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public boolean isAdapterForType(Object key) {
        return IIntrospectionAdapter.ADAPTER_KEY.equals(key);
    }

    protected HashMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            EList localFeatures = this.getJavaClass().getEStructuralFeaturesInternal();
            this.propertiesMap = new HashMap(localFeatures.size());
            for (EStructuralFeature feature : localFeatures) {
                this.propertiesMap.put(feature.getName(), feature);
            }
        }
        return this.propertiesMap;
    }

    protected List getFeaturesList() {
        if (this.featuresRealList == null) {
            this.featuresRealList = this.getJavaClass().getEStructuralFeaturesInternal();
        }
        return this.featuresRealList;
    }

    protected HashMap getOperationsMap() {
        if (this.operationsMap == null) {
            EList locals = this.getJavaClass().getEOperationsInternal();
            int l = locals.size();
            this.operationsMap = new HashMap(l);
            int i = 0;
            while (i < l) {
                EOperation op = (EOperation)locals.get(i);
                this.operationsMap.put(this.formLongName(op), op);
                ++i;
            }
        }
        return this.operationsMap;
    }

    protected EList getOperationsList() {
        if (this.operationsRealList == null) {
            this.operationsRealList = this.getJavaClass().getEOperationsInternal();
        }
        return this.operationsRealList;
    }

    protected HashMap getEventsMap() {
        if (this.eventsMap == null) {
            EList locals = this.getJavaClass().getEventsGen();
            this.eventsMap = new HashMap(locals.size());
            for (JavaEvent event : locals) {
                this.eventsMap.put(event.getName(), event);
            }
        }
        return this.eventsMap;
    }

    protected EList getEventsList() {
        if (this.eventsRealList == null) {
            this.eventsRealList = this.getJavaClass().getEventsGen();
        }
        return this.eventsRealList;
    }

    public void introspectIfNecessary() {
        this.introspectIfNecessary(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void introspectIfNecessary(boolean doOperations) {
        block19: {
            boolean doIntrospection = false;
            BeaninfoClassAdapter beaninfoClassAdapter = this;
            synchronized (beaninfoClassAdapter) {
                boolean bl = doIntrospection = this.needsIntrospection && !this.isIntrospecting;
                if (doIntrospection) {
                    this.isIntrospecting = true;
                }
            }
            if (doIntrospection) {
                boolean didIntrospection = false;
                try {
                    try {
                        this.introspect(doOperations);
                        didIntrospection = true;
                    }
                    catch (Exception e) {
                        BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, BeaninfoPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(BeanInfoAdapterMessages.INTROSPECT_FAILED_EXC_, this.getJavaClass().getJavaName(), ""), (Throwable)e));
                        BeaninfoClassAdapter beaninfoClassAdapter2 = this;
                        synchronized (beaninfoClassAdapter2) {
                            this.isIntrospecting = false;
                            this.needsIntrospection = !didIntrospection;
                            break block19;
                        }
                    }
                }
                catch (Throwable throwable) {
                    BeaninfoClassAdapter beaninfoClassAdapter3 = this;
                    synchronized (beaninfoClassAdapter3) {
                        this.isIntrospecting = false;
                        this.needsIntrospection = !didIntrospection;
                    }
                    throw throwable;
                }
                BeaninfoClassAdapter beaninfoClassAdapter4 = this;
                synchronized (beaninfoClassAdapter4) {
                    this.isIntrospecting = false;
                    this.needsIntrospection = !didIntrospection;
                }
            }
        }
    }

    public BeanInfoCacheController.ClassEntry getClassEntry() {
        return this.classEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canUseCache() {
        BeaninfoClassAdapter beaninfoClassAdapter = this;
        synchronized (beaninfoClassAdapter) {
            if (this.classEntry == null) {
                this.classEntry = BeanInfoCacheController.INSTANCE.getClassEntry((JavaClass)this.getJavaClass());
            }
            if (this.classEntry == null) {
                return false;
            }
            long modStamp = this.classEntry.getModificationStamp();
            if (modStamp == Long.MIN_VALUE) {
                this.classEntry = BeanInfoCacheController.INSTANCE.getClassEntry((JavaClass)this.getJavaClass());
                if (this.classEntry != null) {
                    modStamp = this.classEntry.getModificationStamp();
                }
            }
            if (modStamp == -1L || modStamp == Long.MIN_VALUE) {
                return false;
            }
        }
        EList supers = this.getJavaClass().getESuperTypes();
        if (!supers.isEmpty()) {
            BeaninfoClassAdapter bca = BeaninfoClassAdapter.getBeaninfoClassAdapter((EObject)supers.get(0));
            BeanInfoCacheController.ClassEntry superCE = bca.getClassEntry();
            if (superCE != null ? superCE.getModificationStamp() != this.classEntry.getSuperModificationStamp() : this.classEntry.getSuperModificationStamp() != -9223372036854775807L) {
                return false;
            }
            String[] iNames = this.classEntry.getInterfaceNames();
            if (iNames != null) {
                if (iNames.length != supers.size() - 1) {
                    return false;
                }
                long[] iStamp = this.classEntry.getInterfaceModificationStamps();
                int i = 1;
                while (i <= iNames.length) {
                    int stop;
                    JavaClass javaClass = (JavaClass)supers.get(i);
                    String intName = javaClass.getQualifiedNameForReflection();
                    int indx = stop = i - 1;
                    boolean found = false;
                    do {
                        if (!iNames[indx].equals(intName)) continue;
                        found = true;
                        break;
                    } while (++indx % iNames.length != stop);
                    if (!found) {
                        return false;
                    }
                    superCE = BeaninfoClassAdapter.getBeaninfoClassAdapter((EObject)javaClass).getClassEntry();
                    if (superCE != null ? superCE.getModificationStamp() != iStamp[indx] : iStamp[indx] != -9223372036854775807L) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canUseOverrideCache() {
        BeaninfoClassAdapter beaninfoClassAdapter = this;
        synchronized (beaninfoClassAdapter) {
            block9: {
                block8: {
                    if (this.classEntry == null) {
                        this.classEntry = BeanInfoCacheController.INSTANCE.getClassEntry((JavaClass)this.getJavaClass());
                    }
                    if (this.classEntry == null) break block8;
                    if (this.classEntry.isDeleted()) {
                        this.classEntry = BeanInfoCacheController.INSTANCE.getClassEntry((JavaClass)this.getJavaClass());
                        if (this.classEntry != null && this.classEntry.isDeleted()) {
                            return false;
                        }
                    }
                    break block9;
                }
                return false;
            }
            return this.classEntry.getConfigurationModificationStamp() == Platform.getPlatformAdmin().getState(false).getTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canUseCache(long requestStamp) {
        long modStamp;
        BeaninfoClassAdapter beaninfoClassAdapter = this;
        synchronized (beaninfoClassAdapter) {
            block10: {
                block9: {
                    if (this.classEntry == null) {
                        this.classEntry = BeanInfoCacheController.INSTANCE.getClassEntry((JavaClass)this.getJavaClass());
                    }
                    if (this.classEntry == null) break block9;
                    modStamp = this.classEntry.getModificationStamp();
                    if (modStamp == Long.MIN_VALUE) {
                        this.classEntry = BeanInfoCacheController.INSTANCE.getClassEntry((JavaClass)this.getJavaClass());
                        if (this.classEntry != null) {
                            modStamp = this.classEntry.getModificationStamp();
                        }
                    }
                    if (modStamp == -1L && modStamp == Long.MIN_VALUE) {
                        return false;
                    }
                    break block10;
                }
                return false;
            }
        }
        return requestStamp == modStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspect(boolean doOperations) {
        block51: {
            IBeanProxy beaninfo = null;
            try {
                if (!this.isResourceConnected()) break block51;
                if (this.getJavaClass().getKind() == TypeKind.UNDEFINED_LITERAL) {
                    BeaninfoClassAdapter beaninfoClassAdapter = this;
                    synchronized (beaninfoClassAdapter) {
                        if (this.classEntry != null) {
                            this.classEntry.markDeleted();
                            this.classEntry = null;
                        }
                        this.needsIntrospection = false;
                    }
                    if (this.retrievedExtensionDocument == 2 || this.retrievedExtensionDocument == 3) {
                        this.clearAll();
                        this.retrievedExtensionDocument = 0;
                    }
                    if (this.retrievedExtensionDocument == 0) {
                        this.applyExtensionDocument(true);
                    }
                } else {
                    BeaninfoClassAdapter bca;
                    EList supers = this.getJavaClass().getEAllSuperTypes();
                    int i = 0;
                    while (i < supers.size()) {
                        bca = (BeaninfoClassAdapter)EcoreUtil.getExistingAdapter((Notifier)((EObject)supers.get(i)), (Object)IIntrospectionAdapter.ADAPTER_KEY);
                        if (bca != null && bca.isStale()) {
                            bca.getRegistry();
                        }
                        ++i;
                    }
                    supers = this.getJavaClass().getESuperTypes();
                    i = 0;
                    while (i < supers.size()) {
                        bca = (BeaninfoClassAdapter)EcoreUtil.getRegisteredAdapter((EObject)((EObject)supers.get(i)), (Object)IIntrospectionAdapter.ADAPTER_KEY);
                        bca.introspectIfNecessary();
                        ++i;
                    }
                    TimerTests.basicTest.startCumulativeStep(INTROSPECT);
                    if (this.retrievedExtensionDocument == 1 || this.retrievedExtensionDocument == 3) {
                        this.clearAll();
                    }
                    boolean firstTime = false;
                    if (this.retrievedExtensionDocument != 2) {
                        firstTime = true;
                        this.applyExtensionDocument(false);
                    }
                    boolean doIntrospection = true;
                    if (firstTime && this.canUseCache()) {
                        block53: {
                            TimerTests.basicTest.startCumulativeStep(LOAD_FROM_CACHE);
                            Resource cres = BeanInfoCacheController.INSTANCE.getCache((JavaClass)this.getJavaClass(), this.classEntry, true);
                            if (cres != null) {
                                try {
                                    try {
                                        for (ChangeDescription cacheCD : cres.getContents()) {
                                            cacheCD.apply();
                                        }
                                        this.doIDs();
                                        doIntrospection = false;
                                    }
                                    catch (RuntimeException e) {
                                        BeaninfoPlugin.getPlugin().getLogger().log((Object)MessageFormat.format(BeanInfoAdapterMessages.INTROSPECT_FAILED_EXC_, this.getJavaClass().getJavaName(), ""), Level.WARNING);
                                        BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e);
                                        cres.getResourceSet().getResources().remove((Object)cres);
                                        if (doIntrospection) {
                                            this.clearAll();
                                            this.applyExtensionDocument(false);
                                        }
                                        break block53;
                                    }
                                }
                                catch (Throwable throwable) {
                                    cres.getResourceSet().getResources().remove((Object)cres);
                                    if (doIntrospection) {
                                        this.clearAll();
                                        this.applyExtensionDocument(false);
                                    }
                                    throw throwable;
                                }
                                cres.getResourceSet().getResources().remove((Object)cres);
                                if (doIntrospection) {
                                    this.clearAll();
                                    this.applyExtensionDocument(false);
                                }
                            }
                        }
                        TimerTests.basicTest.stopCumulativeStep(LOAD_FROM_CACHE);
                    }
                    if (doIntrospection) {
                        TimerTests.basicTest.startCumulativeStep(REMOTE_INTROSPECT);
                        BeanDecorator decor = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                        if (decor == null) {
                            decor = BeaninfoFactory.eINSTANCE.createBeanDecorator();
                            decor.setImplicitDecoratorFlag(ImplicitItem.IMPLICIT_DECORATOR_LITERAL);
                            this.getJavaClass().getEAnnotations().add((Object)decor);
                        } else {
                            BeanInfoDecoratorUtility.clear(decor);
                        }
                        boolean doReflection = true;
                        if (doOperations) {
                            this.newoperations = new HashSet(50);
                        }
                        if (decor.isDoBeaninfo()) {
                            int doFlags = 0;
                            if (decor == null || decor.isMergeIntrospection()) {
                                doFlags |= 1;
                            }
                            if (decor == null || decor.isIntrospectEvents()) {
                                doFlags |= 8;
                            }
                            if (decor == null || decor.isIntrospectProperties()) {
                                doFlags |= 2;
                            }
                            if (doOperations && (decor == null || decor.isIntrospectMethods())) {
                                doFlags |= 4;
                            }
                            if (doFlags != 0) {
                                IBeanTypeProxy targetType = null;
                                ProxyFactoryRegistry registry = this.getRegistry();
                                if (registry != null && registry.isValid()) {
                                    targetType = registry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getJavaClass().getQualifiedNameForReflection());
                                }
                                if (targetType != null) {
                                    if (targetType.getInitializationError() == null) {
                                        try {
                                            BeaninfoProxyConstants proxyConstants = this.getProxyConstants();
                                            if (proxyConstants != null) {
                                                beaninfo = proxyConstants.getIntrospectProxy().invoke(null, new IBeanProxy[]{targetType, this.getRegistry().getBeanProxyFactory().createBeanProxyWith(false), this.getRegistry().getBeanProxyFactory().createBeanProxyWith(doFlags)});
                                            }
                                        }
                                        catch (ThrowableProxy e) {
                                            BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, BeaninfoPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(BeanInfoAdapterMessages.INTROSPECT_FAILED_EXC_, this.getJavaClass().getJavaName(), ""), (Throwable)e));
                                        }
                                    } else {
                                        BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, BeaninfoPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(BeanInfoAdapterMessages.INTROSPECT_FAILED_EXC_, this.getJavaClass().getJavaName(), targetType.getInitializationError()), null));
                                    }
                                } else {
                                    BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(1, BeaninfoPlugin.getPlugin().getBundle().getSymbolicName(), 0, MessageFormat.format(BeanInfoAdapterMessages.INTROSPECT_FAILED_EXC_, this.getJavaClass().getJavaName(), BeanInfoAdapterMessages.BeaninfoClassAdapter_ClassNotFound), null));
                                }
                                if (beaninfo != null) {
                                    doReflection = false;
                                    final BeanDecorator bdecor = decor;
                                    BeanInfoDecoratorUtility.introspect(beaninfo, new BeanInfoDecoratorUtility.IntrospectCallBack(){

                                        @Override
                                        public BeanDecorator process(BeanRecord record) {
                                            return bdecor;
                                        }

                                        @Override
                                        public PropertyDecorator process(PropertyRecord record) {
                                            return BeaninfoClassAdapter.this.calculateProperty(record, false);
                                        }

                                        @Override
                                        public PropertyDecorator process(IndexedPropertyRecord record) {
                                            return BeaninfoClassAdapter.this.calculateProperty((PropertyRecord)record, true);
                                        }

                                        @Override
                                        public MethodDecorator process(MethodRecord record) {
                                            return BeaninfoClassAdapter.this.calculateOperation(record);
                                        }

                                        @Override
                                        public EventSetDecorator process(EventSetRecord record) {
                                            return BeaninfoClassAdapter.this.calculateEvent(record);
                                        }
                                    });
                                }
                            }
                        }
                        if (doReflection) {
                            if (decor.isIntrospectProperties()) {
                                this.reflectProperties();
                            }
                            if (doOperations && decor.isIntrospectMethods()) {
                                this.reflectOperations();
                            }
                            if (decor.isIntrospectEvents()) {
                                this.reflectEvents();
                            }
                        }
                        ChangeDescription cd = ChangeFactory.eINSTANCE.createChangeDescription();
                        BeanInfoDecoratorUtility.buildChange(cd, decor);
                        this.finalizeProperties(cd);
                        if (doOperations) {
                            this.finalizeOperations(cd);
                        }
                        this.finalizeEvents(cd);
                        this.classEntry = BeanInfoCacheController.INSTANCE.newCache((JavaClass)this.getJavaClass(), cd, doOperations ? 2 : 1);
                        TimerTests.basicTest.stopCumulativeStep(REMOTE_INTROSPECT);
                    }
                    TimerTests.basicTest.stopCumulativeStep(INTROSPECT);
                }
                this.getAdapterFactory().registerIntrospection(this.getJavaClass().getQualifiedNameForReflection(), this);
            }
            finally {
                if (beaninfo != null) {
                    beaninfo.getProxyFactoryRegistry().releaseProxy(beaninfo);
                }
                this.eventsMap = null;
                this.eventsRealList = null;
                this.operationsMap = null;
                this.operationsRealList = null;
                this.newoperations = null;
                this.propertiesMap = null;
                this.featuresRealList = null;
            }
        }
    }

    private void doIDs() {
        int i;
        int len;
        if (this.getJavaClass().eIsSet((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_EStructuralFeatures())) {
            List features = this.getFeaturesList();
            len = features.size();
            i = 0;
            while (i < len) {
                EStructuralFeature f = (EStructuralFeature)features.get(i);
                PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)f);
                if (pd != null && pd.isMergeIntrospection()) {
                    this.setPropertyID(f.getName(), f);
                }
                ++i;
            }
        }
        if (this.getJavaClass().eIsSet((EStructuralFeature)JavaRefPackage.eINSTANCE.getJavaClass_Events())) {
            EList events = this.getEventsList();
            len = events.size();
            i = 0;
            while (i < len) {
                BeanEvent e = (BeanEvent)events.get(i);
                EventSetDecorator ed = Utilities.getEventSetDecorator((EModelElement)e);
                if (ed != null && ed.isMergeIntrospection()) {
                    this.setEventID(e.getName(), e);
                }
                ++i;
            }
        }
        if (this.getJavaClass().eIsSet((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_EOperations())) {
            EList ops = this.getOperationsList();
            len = ops.size();
            i = 0;
            while (i < len) {
                EOperation o = (EOperation)ops.get(i);
                MethodDecorator md = Utilities.getMethodDecorator((EModelElement)o);
                if (md != null && md.isMergeIntrospection()) {
                    this.setMethodID(o.getName(), o);
                }
                ++i;
            }
        }
    }

    protected void applyExtensionDocument(boolean rootOnly) {
        try {
            String className;
            ResourceSet rset;
            JavaClassImpl jc;
            boolean alreadyRetrievedRoot;
            boolean canUseCache;
            block17: {
                TimerTests.basicTest.startCumulativeStep(APPLY_EXTENSIONS);
                canUseCache = !rootOnly && this.canUseOverrideCache();
                alreadyRetrievedRoot = this.retrievedExtensionDocument == 1;
                this.retrievedExtensionDocument = rootOnly ? 1 : 2;
                jc = this.getJavaClass();
                Resource mergeIntoResource = jc.eResource();
                rset = mergeIntoResource.getResourceSet();
                className = jc.getName();
                if (canUseCache && this.getClassEntry().overrideCacheExists()) {
                    Resource cacheRes = BeanInfoCacheController.INSTANCE.getCache((JavaClass)jc, this.getClassEntry(), false);
                    if (cacheRes != null) {
                        try {
                            try {
                                new ExtensionDocApplies(null, rset, (JavaClass)jc, null).run(cacheRes);
                            }
                            catch (WrappedException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error processing file\"" + cacheRes.getURI() + "\"", (Throwable)e.exception()));
                                cacheRes.getResourceSet().getResources().remove((Object)cacheRes);
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            cacheRes.getResourceSet().getResources().remove((Object)cacheRes);
                            throw throwable;
                        }
                        cacheRes.getResourceSet().getResources().remove((Object)cacheRes);
                    } else {
                        canUseCache = false;
                    }
                }
            }
            List overrideCache = null;
            if (!alreadyRetrievedRoot && (rootOnly || jc.getSupertype() == null)) {
                if (!canUseCache) {
                    overrideCache = this.createOverrideCache(overrideCache, this.getAdapterFactory().getProject(), "..ROOT..", ROOT_OVERRIDE, rset, (JavaClass)jc);
                }
                this.applyExtensionDocTo(rset, (JavaClass)jc, ROOT_OVERRIDE, "..ROOT..", "..ROOT..");
                if (rootOnly) {
                    return;
                }
            }
            String baseOverridefile = String.valueOf(className) + '.' + "override";
            String packageName = jc.getJavaPackage().getPackageName();
            if (!canUseCache) {
                overrideCache = this.createOverrideCache(overrideCache, this.getAdapterFactory().getProject(), packageName, baseOverridefile, rset, (JavaClass)jc);
            }
            this.applyExtensionDocTo(rset, (JavaClass)jc, baseOverridefile, packageName, className);
            if (!canUseCache) {
                BeanInfoCacheController.INSTANCE.newCache((JavaClass)jc, overrideCache, 3);
            }
        }
        finally {
            TimerTests.basicTest.stopCumulativeStep(APPLY_EXTENSIONS);
        }
    }

    private List createOverrideCache(List cache, IProject project, String packageName, String overrideFile, ResourceSet rset, JavaClass mergeIntoJavaClass) {
        String[] paths = BeaninfoPlugin.getPlugin().getOverridePaths(project, packageName);
        if (paths.length == 0) {
            return cache;
        }
        if (cache == null) {
            cache = new ArrayList();
        }
        ExtensionDocApplies runnable = new ExtensionDocApplies(overrideFile, rset, mergeIntoJavaClass, cache);
        int i = 0;
        while (i < paths.length) {
            runnable.run(paths[i]);
            ++i;
        }
        return !cache.isEmpty() ? cache : null;
    }

    private static boolean isEventUtilLoaded() {
        if (!RETRIEVED_EVENT_METHODS) {
            try {
                Class<?> eventFactoryClass = Class.forName("com.ibm.etools.emf.event.EventFactory");
                Field eventFactoryField = eventFactoryClass.getField("eINSTANCE");
                Object eventFactoryInstance = eventFactoryField.get(null);
                java.lang.reflect.Method createEventMethod = eventFactoryClass.getMethod("createEventUtil", Notifier.class, ResourceSet.class);
                Class<?> eventUtilClass = createEventMethod.getReturnType();
                java.lang.reflect.Method doForwardEventsMethod = eventUtilClass.getMethod("doForwardEvents", List.class);
                EVENT_FACTORY_INSTANCE = eventFactoryInstance;
                CREATE_EVENT_UTIL_METHOD = createEventMethod;
                DO_FORWARD_EVENTS_METHOD = doForwardEventsMethod;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            RETRIEVED_EVENT_METHODS = true;
        }
        return EVENT_FACTORY_INSTANCE != null;
    }

    protected void applyExtensionDocTo(ResourceSet rset, JavaClass mergeIntoJavaClass, String overrideFile, String packageName, String className) {
        BeaninfoPlugin.getPlugin().applyOverrides(this.getAdapterFactory().getProject(), packageName, className, mergeIntoJavaClass, rset, new ExtensionDocApplies(overrideFile, rset, mergeIntoJavaClass, null));
    }

    protected JavaClassImpl getJavaClass() {
        return (JavaClassImpl)this.getTarget();
    }

    protected BeaninfoProxyConstants getProxyConstants() {
        return BeaninfoProxyConstants.getConstants(this.getRegistry());
    }

    public EList getEStructuralFeatures() {
        this.introspectIfNecessary();
        return this.getJavaClass().getEStructuralFeaturesInternal();
    }

    public EList getAllProperties() {
        return this.allProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getEOperations() {
        if (this.getClassEntry() != null && this.getClassEntry().isOperationsStored()) {
            this.introspectIfNecessary();
        } else {
            BeaninfoClassAdapter beaninfoClassAdapter = this;
            synchronized (beaninfoClassAdapter) {
                this.needsIntrospection = true;
            }
            this.introspectIfNecessary(true);
        }
        return this.getJavaClass().getEOperationsInternal();
    }

    public BasicEList getEAllOperations() {
        return this.allOperations();
    }

    public EList getEvents() {
        this.introspectIfNecessary();
        return this.getJavaClass().getEventsGen();
    }

    public EList getAllEvents() {
        return this.allEvents();
    }

    private void finalizeProperties(ChangeDescription cd) {
        HashMap oldLocals = this.getPropertiesMap();
        Iterator itr = this.getFeaturesList().iterator();
        while (itr.hasNext()) {
            ImplicitItem implicit;
            EStructuralFeature a = (EStructuralFeature)itr.next();
            PropertyDecorator p = Utilities.getPropertyDecorator((EModelElement)a);
            Object aOld = oldLocals.get(a.getName());
            if (aOld != null && aOld != Boolean.FALSE && p != null && (implicit = p.getImplicitDecoratorFlag()) != ImplicitItem.NOT_IMPLICIT_LITERAL) {
                p.setEModelElement(null);
                ((InternalEObject)p).eSetProxyURI(BAD_URI);
                p = null;
                if (implicit == ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL) {
                    itr.remove();
                    ((InternalEObject)a).eSetProxyURI(BAD_URI);
                    continue;
                }
            }
            if (a.getEType() == null) {
                a.setEType((EClassifier)EcorePackage.eINSTANCE.getEObject());
                Logger logger = BeaninfoPlugin.getPlugin().getLogger();
                if (logger.isLoggingLevel(Level.WARNING)) {
                    logger.logWarning("Feature \"" + this.getJavaClass().getQualifiedName() + "->" + a.getName() + "\" did not have a type set. Typically due to override file creating feature but property not found on introspection/reflection.");
                }
            }
            if (p == null || cd == null) continue;
            BeanInfoDecoratorUtility.buildChange(cd, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EList allProperties() {
        EList jcAllProperties = this.getJavaClass().getAllPropertiesGen();
        BeaninfoSuperAdapter superAdapter = (BeaninfoSuperAdapter)EcoreUtil.getRegisteredAdapter((EObject)this.getJavaClass(), BeaninfoSuperAdapter.class);
        if (!(jcAllProperties == null || superAdapter != null && superAdapter.isAllPropertiesCollectionModified())) {
            return jcAllProperties;
        }
        UniqueEList.FastCompare allProperties = new UniqueEList.FastCompare(){
            private static final long serialVersionUID = 1L;

            protected Object[] newData(int capacity) {
                return new EStructuralFeature[capacity];
            }
        };
        boolean doAllProperties = false;
        BeaninfoClassAdapter beaninfoClassAdapter = this;
        synchronized (beaninfoClassAdapter) {
            boolean bl = doAllProperties = !this.isDoingAllProperties && !this.isIntrospecting && this.isResourceConnected();
            if (doAllProperties) {
                this.isDoingAllProperties = true;
            }
        }
        if (doAllProperties) {
            try {
                EList localProperties = this.getJavaClass().getProperties();
                EList superTypes = this.getJavaClass().getESuperTypes();
                if (!superTypes.isEmpty()) {
                    boolean mergeAll;
                    BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                    Object workingAllProperties = superTypes.size() == 1 ? allProperties : new LinkedHashSet();
                    boolean bl = mergeAll = bd == null || bd.isMergeSuperProperties();
                    if (!mergeAll) {
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            EList supers = ((JavaClass)superTypes.get(i)).getAllProperties();
                            int len = supers.size();
                            int i1 = 0;
                            while (i1 < len) {
                                EStructuralFeature p = (EStructuralFeature)supers.get(i1);
                                PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)p);
                                if (pd == null || pd.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL && !pd.isMergeIntrospection()) {
                                    workingAllProperties.add(p);
                                }
                                ++i1;
                            }
                            ++i;
                        }
                    } else if (bd != null && bd.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedPropertyNames())) {
                        HashSet superSet = new HashSet(bd.getNotInheritedPropertyNames());
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            EList supers = ((JavaClass)superTypes.get(i)).getAllProperties();
                            int len = supers.size();
                            int i1 = 0;
                            while (i1 < len) {
                                EStructuralFeature p = (EStructuralFeature)supers.get(i1);
                                PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)p);
                                if (pd == null || pd.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL && !pd.isMergeIntrospection() || !superSet.contains(pd.getName())) {
                                    workingAllProperties.add(p);
                                }
                                ++i1;
                            }
                            ++i;
                        }
                    } else {
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            workingAllProperties.addAll(((JavaClass)superTypes.get(i)).getAllProperties());
                            ++i;
                        }
                    }
                    if (workingAllProperties != allProperties) {
                        allProperties.addAll((Collection)workingAllProperties);
                    }
                }
                allProperties.addAll((Collection)localProperties);
                superAdapter.setAllPropertiesCollectionModified(false);
            }
            catch (Throwable throwable) {
                BeaninfoClassAdapter beaninfoClassAdapter2 = this;
                synchronized (beaninfoClassAdapter2) {
                    this.isDoingAllProperties = false;
                }
                throw throwable;
            }
            BeaninfoClassAdapter beaninfoClassAdapter3 = this;
            synchronized (beaninfoClassAdapter3) {
                this.isDoingAllProperties = false;
            }
        }
        if (!allProperties.isEmpty()) {
            allProperties.shrink();
            return new EcoreEList.UnmodifiableEList.FastCompare((InternalEObject)this.getJavaClass(), null, allProperties.size(), allProperties.data());
        }
        return ECollections.EMPTY_ELIST;
    }

    protected PropertyDecorator calculateProperty(PropertyRecord pr, boolean indexed) {
        JavaHelpers type;
        JavaHelpers javaHelpers = type = pr.propertyTypeName != null ? Utilities.getJavaType(MapJNITypes.getFormalTypeName((String)pr.propertyTypeName), this.getJavaClass().eResource().getResourceSet()) : null;
        if (indexed && type == null) {
            type = Utilities.getJavaType(String.valueOf(MapJNITypes.getFormalTypeName((String)((IndexedPropertyRecord)pr).indexedPropertyTypeName)) + "[]", this.getJavaClass().eResource().getResourceSet());
        }
        if (type != null) {
            return this.createProperty(pr.name, indexed, (EClassifier)type);
        }
        return null;
    }

    protected PropertyDecorator createProperty(String name, boolean indexed, EClassifier type) {
        ImplicitItem implicit;
        HashMap existingLocals = this.getPropertiesMap();
        EStructuralFeature prop = null;
        FeatureDecorator pd = null;
        Object p = existingLocals.get(name);
        if (Boolean.FALSE == p) {
            return null;
        }
        if (p != null) {
            existingLocals.put(name, Boolean.FALSE);
            pd = Utilities.getPropertyDecorator((EModelElement)((EStructuralFeature)p));
            if (pd != null && !pd.isMergeIntrospection()) {
                return null;
            }
            prop = (EStructuralFeature)p;
        }
        if (pd != null) {
            if (pd.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL) {
                indexed = pd instanceof IndexedPropertyDecorator;
            } else if (indexed && !(pd instanceof IndexedPropertyDecorator) || !indexed && pd instanceof IndexedPropertyDecorator) {
                prop.getEAnnotations().remove((Object)pd);
                pd = null;
            }
            if (pd != null) {
                if (indexed) {
                    BeanInfoDecoratorUtility.clear((IndexedPropertyDecorator)pd);
                } else {
                    BeanInfoDecoratorUtility.clear((PropertyDecorator)pd);
                }
            }
        }
        ImplicitItem implicitItem = implicit = pd == null ? ImplicitItem.IMPLICIT_DECORATOR_LITERAL : pd.getImplicitDecoratorFlag();
        if (prop == null) {
            prop = EcoreFactory.eINSTANCE.createEReference();
            this.getFeaturesList().add(prop);
            implicit = ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL;
        }
        this.setPropertyID(name, prop);
        prop.setName(name);
        prop.setTransient(false);
        prop.setVolatile(false);
        if (implicit == ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL) {
            prop.setUnsettable(true);
        }
        prop.setEType(type);
        if (!indexed) {
            prop.setLowerBound(0);
            prop.setUpperBound(1);
        } else {
            prop.setLowerBound(0);
            prop.setUpperBound(-1);
            prop.setUnique(true);
        }
        if (pd == null) {
            pd = !indexed ? BeaninfoFactory.eINSTANCE.createPropertyDecorator() : BeaninfoFactory.eINSTANCE.createIndexedPropertyDecorator();
            pd.setImplicitDecoratorFlag(implicit);
            prop.getEAnnotations().add((Object)pd);
        }
        return pd;
    }

    private void setPropertyID(String name, EStructuralFeature prop) {
        ((XMIResource)prop.eResource()).setID((EObject)prop, String.valueOf(this.getJavaClass().getName()) + "/" + name);
    }

    private void reflectProperties() {
        boolean isBound;
        int i;
        EList superTypes;
        TimerTests.basicTest.startCumulativeStep(REFLECT_PROPERTIES);
        HashSet<String> supers = new HashSet<String>(50);
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
        if ((bd == null || bd.isMergeSuperProperties()) && !(superTypes = this.getJavaClass().getESuperTypes()).isEmpty()) {
            int lenST = superTypes.size();
            i = 0;
            while (i < lenST) {
                EList eList = ((JavaClass)superTypes.get(i)).getAllProperties();
                int len = eList.size();
                int i1 = 0;
                while (i1 < len) {
                    EStructuralFeature sf = (EStructuralFeature)eList.get(i1);
                    supers.add(sf.getName());
                    ++i1;
                }
                ++i;
            }
        }
        if (!(isBound = this.isDefaultBound())) {
            EList superTypes2 = this.getJavaClass().getEAllSuperTypes();
            i = superTypes2.size() - 1;
            while (!isBound && i >= 0) {
                JavaClass javaClass = (JavaClass)superTypes2.get(i);
                BeaninfoClassAdapter bi = (BeaninfoClassAdapter)EcoreUtil.getExistingAdapter((Notifier)javaClass, (Object)IIntrospectionAdapter.ADAPTER_KEY);
                if (bi != null) {
                    isBound = bi.isDefaultBound();
                }
                --i;
            }
        }
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        for (Method method : this.getJavaClass().getPublicMethods()) {
            String name;
            if (method.isStatic() || method.isConstructor()) continue;
            if (method.getName().startsWith("get")) {
                String name2 = Introspector.decapitalize(method.getName().substring(3));
                if (name2.length() == 0 || supers.contains(name2)) continue;
                PropertyInfo propInfo = (PropertyInfo)props.get(name2);
                if (propInfo == null) {
                    propInfo = new PropertyInfo();
                    if (!propInfo.setGetter(method, false)) continue;
                    props.put(name2, propInfo);
                    continue;
                }
                propInfo.setGetter(method, false);
                continue;
            }
            if (method.getName().startsWith("is")) {
                String name3 = Introspector.decapitalize(method.getName().substring(2));
                if (name3.length() == 0 || supers.contains(name3)) continue;
                PropertyInfo propInfo = (PropertyInfo)props.get(name3);
                if (propInfo == null) {
                    propInfo = new PropertyInfo();
                    if (!propInfo.setGetter(method, true)) continue;
                    props.put(name3, propInfo);
                    continue;
                }
                propInfo.setGetter(method, true);
                continue;
            }
            if (!method.getName().startsWith("set") || (name = Introspector.decapitalize(method.getName().substring(3))).length() == 0 || supers.contains(name)) continue;
            PropertyInfo propInfo = (PropertyInfo)props.get(name);
            if (propInfo == null) {
                propInfo = new PropertyInfo();
                if (!propInfo.setSetter(method)) continue;
                props.put(name, propInfo);
                continue;
            }
            propInfo.setSetter(method);
        }
        for (Map.Entry entry : props.entrySet()) {
            ((PropertyInfo)entry.getValue()).createProperty((String)entry.getKey(), isBound);
        }
        TimerTests.basicTest.stopCumulativeStep(REFLECT_PROPERTIES);
    }

    private void finalizeOperations(ChangeDescription cd) {
        Iterator itr = this.getOperationsList().iterator();
        while (itr.hasNext()) {
            ImplicitItem implicit;
            EOperation a = (EOperation)itr.next();
            MethodDecorator m = Utilities.getMethodDecorator((EModelElement)a);
            if (!this.newoperations.contains(a) && m != null && (implicit = m.getImplicitDecoratorFlag()) != ImplicitItem.NOT_IMPLICIT_LITERAL) {
                m.setEModelElement(null);
                ((InternalEObject)m).eSetProxyURI(BAD_URI);
                if (implicit != ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL) continue;
                itr.remove();
                ((InternalEObject)a).eSetProxyURI(BAD_URI);
                continue;
            }
            if (m == null || cd == null) continue;
            BeanInfoDecoratorUtility.buildChange(cd, m);
        }
    }

    protected MethodDecorator calculateOperation(MethodRecord record) {
        return this.createOperation(record.name, this.formLongName(record), null, record);
    }

    protected MethodDecorator createOperation(String name, String longName, Method method, MethodRecord record) {
        ImplicitItem implicit;
        HashMap existingLocals = this.getOperationsMap();
        EOperation oper = null;
        MethodDecorator md = null;
        Object b = null;
        b = name != null ? existingLocals.get(longName) : existingLocals.get(longName);
        if (b != null) {
            md = Utilities.getMethodDecorator((EModelElement)((EOperation)b));
            if (md != null && !md.isMergeIntrospection()) {
                return null;
            }
            oper = b;
        }
        if (method == null) {
            method = BeanInfoDecoratorUtility.createJavaMethodProxy(record.methodForDescriptor);
        }
        ImplicitItem implicitItem = implicit = md == null ? ImplicitItem.IMPLICIT_DECORATOR_LITERAL : ImplicitItem.NOT_IMPLICIT_LITERAL;
        if (oper == null) {
            oper = BeaninfoFactory.eINSTANCE.createMethodProxy();
            this.getOperationsList().add((Object)oper);
            implicit = ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL;
        }
        if (name == null) {
            name = method.getName();
        }
        if (oper instanceof MethodProxy) {
            ((MethodProxy)oper).setMethod(method);
        }
        this.setMethodID(name, oper);
        oper.setName(name);
        this.newoperations.add(oper);
        if (md == null) {
            md = BeaninfoFactory.eINSTANCE.createMethodDecorator();
            md.setImplicitDecoratorFlag(implicit);
            oper.getEAnnotations().add((Object)md);
        } else {
            BeanInfoDecoratorUtility.clear(md);
        }
        return md;
    }

    private void setMethodID(String name, EOperation oper) {
        ((XMIResource)oper.eResource()).setID((EObject)oper, String.valueOf(this.getJavaClass().getName()) + "/operation/" + name);
    }

    private void reflectOperations() {
        EList superTypes;
        HashSet<String> supers = new HashSet<String>(50);
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
        if ((bd == null || bd.isMergeSuperMethods()) && !(superTypes = this.getJavaClass().getESuperTypes()).isEmpty()) {
            int lenST = superTypes.size();
            int i = 0;
            while (i < lenST) {
                EList superAll = ((JavaClass)superTypes.get(i)).getEAllOperations();
                int len = superAll.size();
                int i1 = 0;
                while (i1 < len) {
                    EOperation op = (EOperation)superAll.get(i1);
                    supers.add(this.formLongName(op));
                    ++i1;
                }
                ++i;
            }
        }
        for (Method mthd : this.getJavaClass().getPublicMethods()) {
            String longName;
            if (mthd.isStatic() || mthd.isConstructor() || supers.contains(longName = this.formLongName((EOperation)mthd))) continue;
            this.createOperation(null, longName, mthd, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicEList allOperations() {
        BasicEList jcAllOperations = (BasicEList)this.getJavaClass().primGetEAllOperations();
        BeaninfoSuperAdapter superAdapter = (BeaninfoSuperAdapter)EcoreUtil.getRegisteredAdapter((EObject)this.getJavaClass(), BeaninfoSuperAdapter.class);
        if (!(jcAllOperations == null || superAdapter != null && superAdapter.isAllOperationsCollectionModified())) {
            return jcAllOperations;
        }
        UniqueEList.FastCompare allOperations = new UniqueEList.FastCompare(){
            private static final long serialVersionUID = 1L;

            protected Object[] newData(int capacity) {
                return new EOperation[capacity];
            }
        };
        boolean doAllOperations = false;
        BeaninfoClassAdapter beaninfoClassAdapter = this;
        synchronized (beaninfoClassAdapter) {
            boolean bl = doAllOperations = !this.isDoingAllOperations && !this.isIntrospecting && this.isResourceConnected();
            if (doAllOperations) {
                this.isDoingAllOperations = true;
            }
        }
        if (doAllOperations) {
            try {
                EList localOperations = this.getJavaClass().getEOperations();
                EList superTypes = this.getJavaClass().getESuperTypes();
                if (!superTypes.isEmpty()) {
                    boolean mergeAll;
                    BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                    Object workingAllOperations = superTypes.size() == 1 ? allOperations : new LinkedHashSet();
                    boolean bl = mergeAll = bd == null || bd.isMergeSuperMethods();
                    if (!mergeAll) {
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            EList supers = ((JavaClass)superTypes.get(i)).getEAllOperations();
                            int len = supers.size();
                            int i1 = 0;
                            while (i1 < len) {
                                EOperation o = (EOperation)supers.get(i1);
                                MethodDecorator md = Utilities.getMethodDecorator((EModelElement)o);
                                if (md == null || md.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL && !md.isMergeIntrospection()) {
                                    workingAllOperations.add(o);
                                }
                                ++i1;
                            }
                            ++i;
                        }
                    } else if (bd != null && bd.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedMethodNames())) {
                        HashSet superSet = new HashSet(bd.getNotInheritedMethodNames());
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            EList supers = ((JavaClass)superTypes.get(i)).getEAllOperations();
                            int len = supers.size();
                            int i1 = 0;
                            while (i1 < len) {
                                EOperation o = (EOperation)supers.get(i1);
                                MethodDecorator md = Utilities.getMethodDecorator((EModelElement)o);
                                if (md == null || md.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL && !md.isMergeIntrospection()) {
                                    workingAllOperations.add(o);
                                } else {
                                    String longName = this.formLongName(o);
                                    if (longName == null || !superSet.contains(longName)) {
                                        workingAllOperations.add(o);
                                    }
                                }
                                ++i1;
                            }
                            ++i;
                        }
                    } else {
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            workingAllOperations.addAll(((JavaClass)superTypes.get(i)).getEAllOperations());
                            ++i;
                        }
                    }
                    if (workingAllOperations != allOperations) {
                        allOperations.addAll((Collection)workingAllOperations);
                    }
                }
                allOperations.addAll((Collection)localOperations);
                ESuperAdapter sa = this.getJavaClass().getESuperAdapter();
                sa.setAllOperationsCollectionModified(false);
            }
            catch (Throwable throwable) {
                BeaninfoClassAdapter beaninfoClassAdapter2 = this;
                synchronized (beaninfoClassAdapter2) {
                    this.isDoingAllOperations = false;
                }
                throw throwable;
            }
            BeaninfoClassAdapter beaninfoClassAdapter3 = this;
            synchronized (beaninfoClassAdapter3) {
                this.isDoingAllOperations = false;
            }
        }
        allOperations.shrink();
        return new EcoreEList.UnmodifiableEList.FastCompare((InternalEObject)this.getJavaClass(), (EStructuralFeature)EcorePackage.eINSTANCE.getEClass_EAllOperations(), allOperations.size(), allOperations.data());
    }

    private void finalizeEvents(ChangeDescription cd) {
        HashMap oldLocals = this.getEventsMap();
        Iterator itr = this.getEventsList().iterator();
        while (itr.hasNext()) {
            ImplicitItem implicit;
            JavaEvent a = (JavaEvent)itr.next();
            EventSetDecorator e = Utilities.getEventSetDecorator((EModelElement)a);
            Object aOld = oldLocals.get(a.getName());
            if (aOld != null && aOld != Boolean.FALSE && e != null && (implicit = e.getImplicitDecoratorFlag()) != ImplicitItem.NOT_IMPLICIT_LITERAL) {
                e.setEModelElement(null);
                ((InternalEObject)e).eSetProxyURI(BAD_URI);
                if (implicit != ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL) continue;
                itr.remove();
                ((InternalEObject)a).eSetProxyURI(BAD_URI);
                continue;
            }
            if (e == null || cd == null) continue;
            BeanInfoDecoratorUtility.buildChange(cd, e);
        }
    }

    protected EventSetDecorator calculateEvent(EventSetRecord record) {
        return this.createEvent(record.name);
    }

    protected EventSetDecorator createEvent(String name) {
        ImplicitItem implicit;
        HashMap existingLocals = this.getEventsMap();
        BeanEvent event = null;
        EventSetDecorator ed = null;
        Object b = existingLocals.get(name);
        if (Boolean.FALSE == b) {
            return null;
        }
        if (b != null) {
            existingLocals.put(name, Boolean.FALSE);
            ed = Utilities.getEventSetDecorator((EModelElement)((JavaEvent)b));
            if (ed != null && !ed.isMergeIntrospection()) {
                return null;
            }
            event = (JavaEvent)b;
        }
        ImplicitItem implicitItem = implicit = ed == null ? ImplicitItem.IMPLICIT_DECORATOR_LITERAL : ImplicitItem.NOT_IMPLICIT_LITERAL;
        if (event == null) {
            event = BeaninfoFactory.eINSTANCE.createBeanEvent();
            this.getEventsList().add((Object)event);
            implicit = ImplicitItem.IMPLICIT_DECORATOR_AND_FEATURE_LITERAL;
        }
        this.setEventID(name, event);
        event.setName(name);
        if (ed == null) {
            ed = BeaninfoFactory.eINSTANCE.createEventSetDecorator();
            ed.setImplicitDecoratorFlag(implicit);
            event.getEAnnotations().add((Object)ed);
        } else {
            BeanInfoDecoratorUtility.clear(ed);
        }
        return ed;
    }

    private void setEventID(String name, JavaEvent event) {
        ((XMIResource)event.eResource()).setID((EObject)event, String.valueOf(this.getJavaClass().getName()) + "/event/" + name);
    }

    protected void reflectEvents() {
        EList superTypes;
        HashSet<String> supers = new HashSet<String>(50);
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
        if ((bd == null || bd.isMergeSuperEvents()) && !(superTypes = this.getJavaClass().getESuperTypes()).isEmpty()) {
            int lenST = superTypes.size();
            int i = 0;
            while (i < lenST) {
                EList superAll = ((JavaClass)superTypes.get(i)).getAllEvents();
                int len = superAll.size();
                int i1 = 0;
                while (i1 < len) {
                    JavaEvent se = (JavaEvent)superAll.get(i1);
                    supers.add(se.getName());
                    ++i1;
                }
                ++i;
            }
        }
        HashMap<String, EventInfo> events = new HashMap<String, EventInfo>();
        this.eventListenerClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("java.util.EventListener", (EObject)this.getJavaClass());
        this.tooManyExceptionClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("java.util.TooManyListenersException", (EObject)this.getJavaClass());
        for (Method mthd : this.getJavaClass().getPublicMethods()) {
            if (mthd.isStatic() || mthd.isConstructor()) continue;
            String key = this.validEventAdder(mthd);
            if (key != null) {
                EventInfo eventInfo = (EventInfo)events.get(key);
                if (eventInfo == null) {
                    eventInfo = new EventInfo();
                    eventInfo.setAdder(mthd);
                    events.put(key, eventInfo);
                    continue;
                }
                eventInfo.setAdder(mthd);
                continue;
            }
            key = this.validEventRemove(mthd);
            if (key == null) continue;
            EventInfo eventInfo = (EventInfo)events.get(key);
            if (eventInfo == null) {
                eventInfo = new EventInfo();
                eventInfo.setRemover(mthd);
                events.put(key, eventInfo);
                continue;
            }
            eventInfo.setRemover(mthd);
        }
        this.eventListenerClass = null;
        HashSet<String> eventNames = new HashSet<String>(events.size());
        for (Map.Entry eventMap : events.entrySet()) {
            String eventName;
            EventInfo ei = (EventInfo)eventMap.getValue();
            if (!ei.isValidInfo() || eventNames.contains(eventName = this.getEventName((String)eventMap.getKey())) || supers.contains(eventName) || !ei.createEvent(eventName)) continue;
            eventNames.add(eventName);
        }
        this.tooManyExceptionClass = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EList allEvents() {
        EList jcAllEvents = this.getJavaClass().getAllEventsGen();
        BeaninfoSuperAdapter superAdapter = (BeaninfoSuperAdapter)EcoreUtil.getRegisteredAdapter((EObject)this.getJavaClass(), BeaninfoSuperAdapter.class);
        if (!(jcAllEvents == null || superAdapter != null && superAdapter.isAllEventsCollectionModified())) {
            return jcAllEvents;
        }
        UniqueEList.FastCompare allEvents = new UniqueEList.FastCompare(){
            private static final long serialVersionUID = 1L;

            protected Object[] newData(int capacity) {
                return new JavaEvent[capacity];
            }
        };
        boolean doAllEvents = false;
        BeaninfoClassAdapter beaninfoClassAdapter = this;
        synchronized (beaninfoClassAdapter) {
            boolean bl = doAllEvents = !this.isDoingAllEvents && !this.isIntrospecting && this.isResourceConnected();
            if (doAllEvents) {
                this.isDoingAllEvents = true;
            }
        }
        if (doAllEvents) {
            try {
                EList localEvents = this.getJavaClass().getEvents();
                EList superTypes = this.getJavaClass().getESuperTypes();
                if (!superTypes.isEmpty()) {
                    boolean mergeAll;
                    BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                    Object workingAllEvents = superTypes.size() == 1 ? allEvents : new LinkedHashSet();
                    boolean bl = mergeAll = bd == null || bd.isMergeSuperEvents();
                    if (!mergeAll) {
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            EList supers = ((JavaClass)superTypes.get(i)).getAllEvents();
                            int len = supers.size();
                            int i1 = 0;
                            while (i1 < len) {
                                JavaEvent e = (JavaEvent)supers.get(i1);
                                EventSetDecorator ed = Utilities.getEventSetDecorator((EModelElement)e);
                                if (ed == null || ed.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL && !ed.isMergeIntrospection()) {
                                    workingAllEvents.add(e);
                                }
                                ++i1;
                            }
                            ++i;
                        }
                    } else if (bd != null && bd.eIsSet((EStructuralFeature)BeaninfoPackage.eINSTANCE.getBeanDecorator_NotInheritedEventNames())) {
                        HashSet superSet = new HashSet(bd.getNotInheritedEventNames());
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            EList supers = ((JavaClass)superTypes.get(i)).getAllEvents();
                            int len = supers.size();
                            int i1 = 0;
                            while (i1 < len) {
                                JavaEvent e = (JavaEvent)supers.get(i1);
                                EventSetDecorator ed = Utilities.getEventSetDecorator((EModelElement)e);
                                if (ed == null || ed.getImplicitDecoratorFlag() == ImplicitItem.NOT_IMPLICIT_LITERAL && !ed.isMergeIntrospection() || !superSet.contains(ed.getName())) {
                                    workingAllEvents.add(e);
                                }
                                ++i1;
                            }
                            ++i;
                        }
                    } else {
                        int lenST = superTypes.size();
                        int i = 0;
                        while (i < lenST) {
                            workingAllEvents.addAll(((JavaClass)superTypes.get(i)).getAllEvents());
                            ++i;
                        }
                    }
                    if (workingAllEvents != allEvents) {
                        allEvents.addAll((Collection)workingAllEvents);
                    }
                }
                allEvents.addAll((Collection)localEvents);
                superAdapter.setAllEventsCollectionModified(false);
            }
            catch (Throwable throwable) {
                BeaninfoClassAdapter beaninfoClassAdapter2 = this;
                synchronized (beaninfoClassAdapter2) {
                    this.isDoingAllEvents = false;
                }
                throw throwable;
            }
            BeaninfoClassAdapter beaninfoClassAdapter3 = this;
            synchronized (beaninfoClassAdapter3) {
                this.isDoingAllEvents = false;
            }
        }
        if (allEvents.isEmpty()) {
            return ECollections.EMPTY_ELIST;
        }
        allEvents.shrink();
        return new EcoreEList.UnmodifiableEList.FastCompare((InternalEObject)this.getJavaClass(), (EStructuralFeature)JavaRefPackage.eINSTANCE.getJavaClass_AllEvents(), allEvents.size(), allEvents.data());
    }

    protected String getEventName(String key) {
        return key.substring(0, key.indexOf(58));
    }

    protected String validEventAdder(Method method) {
        String name = method.getName();
        if (!name.startsWith("add") || !name.endsWith("Listener")) {
            return null;
        }
        EList parms = method.getParameters();
        if (parms.size() != 1) {
            return null;
        }
        JavaHelpers returnType = method.getReturnType();
        if (returnType == null || !returnType.getName().equals("void")) {
            return null;
        }
        EClassifier parmType = ((JavaParameter)parms.get(0)).getEType();
        if (!this.eventListenerClass.isAssignableFrom(parmType)) {
            return null;
        }
        if (!parmType.getName().endsWith(name.substring(3))) {
            return null;
        }
        return String.valueOf(Introspector.decapitalize(name.substring(3, name.length() - 8))) + ':' + ((JavaHelpers)parmType).getQualifiedName();
    }

    protected String validEventRemove(Method method) {
        String name = method.getName();
        if (!name.startsWith("remove") || !name.endsWith("Listener")) {
            return null;
        }
        EList parms = method.getParameters();
        if (parms.size() != 1) {
            return null;
        }
        JavaHelpers returnType = method.getReturnType();
        if (returnType == null || !returnType.getName().equals("void")) {
            return null;
        }
        EClassifier parmType = ((JavaParameter)parms.get(0)).getEType();
        if (!this.eventListenerClass.isAssignableFrom(parmType)) {
            return null;
        }
        if (!parmType.getName().endsWith(name.substring(6))) {
            return null;
        }
        return String.valueOf(Introspector.decapitalize(name.substring(6, name.length() - 8))) + ':' + ((JavaHelpers)parmType).getQualifiedName();
    }

    public boolean isDefaultBound() {
        if (this.defaultBound == null) {
            Iterator methods = this.getJavaClass().getPublicMethods().iterator();
            boolean foundAdd = false;
            boolean foundRemove = false;
            while (!(!methods.hasNext() || foundAdd && foundRemove)) {
                JavaParameter parm;
                EList parms;
                Method method = (Method)methods.next();
                if ("addPropertyChangeListener".equals(method.getName())) {
                    parms = method.getParameters();
                    if (parms.size() != 1 || !"java.beans.PropertyChangeListener".equals(((JavaHelpers)(parm = (JavaParameter)parms.get(0)).getEType()).getQualifiedName())) continue;
                    foundAdd = true;
                    continue;
                }
                if (!"removePropertyChangeListener".equals(method.getName()) || (parms = method.getParameters()).size() != 1 || !"java.beans.PropertyChangeListener".equals(((JavaHelpers)(parm = (JavaParameter)parms.get(0)).getEType()).getQualifiedName())) continue;
                foundRemove = true;
            }
            this.defaultBound = foundAdd && foundRemove ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.defaultBound;
    }

    public void markStaleFactory(ProxyFactoryRegistry stale) {
        this.markStaleFactory(stale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markStaleFactory(ProxyFactoryRegistry stale, boolean clearOverriddes) {
        if (this.staleFactory == null) {
            this.defaultBound = null;
            this.staleFactory = new WeakReference<ProxyFactoryRegistry>(stale);
            Adapter a = EcoreUtil.getExistingAdapter((Notifier)this.getTarget(), ESuperAdapter.class);
            ENotificationImpl note = new ENotificationImpl((InternalEObject)this.getTarget(), 1, 10, null, null);
            if (a != null) {
                a.notifyChanged((Notification)note);
            }
            if ((a = EcoreUtil.getExistingAdapter((Notifier)this.getTarget(), (Object)BeaninfoSuperAdapter.ADAPTER_KEY)) != null) {
                a.notifyChanged((Notification)note);
            }
            BeaninfoClassAdapter beaninfoClassAdapter = this;
            synchronized (beaninfoClassAdapter) {
                this.needsIntrospection = true;
                if (clearOverriddes) {
                    this.retrievedExtensionDocument = 3;
                    if (this.classEntry != null) {
                        this.classEntry.markDeleted();
                        this.classEntry = null;
                    }
                }
            }
        }
    }

    private String formLongName(EOperation feature) {
        Method mthd = null;
        if (feature instanceof Method) {
            mthd = (Method)feature;
        } else if (feature instanceof MethodProxy) {
            mthd = ((MethodProxy)feature).getMethod();
        } else {
            return null;
        }
        StringBuffer longName = new StringBuffer(100);
        longName.append(feature.getName());
        longName.append(':');
        longName.append(mthd.getName());
        longName.append('(');
        EList p = mthd.getParameters();
        int i = 0;
        while (i < p.size()) {
            JavaParameter parm = (JavaParameter)p.get(i);
            if (i > 0) {
                longName.append(',');
            }
            longName.append(parm.getJavaType().getQualifiedName());
            ++i;
        }
        return longName.toString();
    }

    private String formLongName(MethodRecord record) {
        StringBuffer longName = new StringBuffer(100);
        longName.append(record.name);
        longName.append(':');
        longName.append(record.methodForDescriptor.methodName);
        longName.append('(');
        String[] p = record.methodForDescriptor.parameterTypeNames;
        if (p != null) {
            int i = 0;
            while (i < p.length) {
                if (i > 0) {
                    longName.append(',');
                }
                longName.append(MapJNITypes.getFormalTypeName((String)p[i]));
                ++i;
            }
        }
        return longName.toString();
    }

    public void notifyChanged(Notification msg) {
        if (msg.getEventType() == 8) {
            this.getAdapterFactory().removeAdapter(this);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + '(' + (this.getJavaClass() != null ? this.getJavaClass().getQualifiedName() : "?") + ')';
    }

    private class EventInfo {
        public Method addListenerMethod;
        public Method removeListenerMethod;

        private EventInfo() {
        }

        public void setAdder(Method addMethod) {
            this.addListenerMethod = addMethod;
        }

        public void setRemover(Method removeMethod) {
            this.removeListenerMethod = removeMethod;
        }

        public boolean isValidInfo() {
            return this.addListenerMethod != null && this.removeListenerMethod != null;
        }

        public boolean createEvent(String name) {
            EventSetDecorator ed = BeaninfoClassAdapter.this.createEvent(name);
            if (ed == null) {
                return false;
            }
            boolean unicast = false;
            EList exceptions = this.addListenerMethod.getJavaExceptions();
            int len = exceptions.size();
            int i = 0;
            while (i < len) {
                if (exceptions.get(i) == BeaninfoClassAdapter.this.tooManyExceptionClass) {
                    unicast = true;
                    break;
                }
                ++i;
            }
            BeanInfoDecoratorUtility.setProperties(ed, this.addListenerMethod, this.removeListenerMethod, unicast, (JavaClass)((JavaParameter)this.addListenerMethod.getParameters().get(0)).getEType());
            return true;
        }
    }

    private class ExtensionDocApplies
    implements BeaninfoPlugin.IOverrideRunnable {
        private final String overrideFile;
        private final ResourceSet rset;
        private final JavaClass mergeIntoJavaClass;
        private final List overridesCache;

        public ExtensionDocApplies(String overrideFile, ResourceSet rset, JavaClass mergeIntoJavaClass, List overridesCache) {
            this.overrideFile = overrideFile;
            this.rset = rset;
            this.mergeIntoJavaClass = mergeIntoJavaClass;
            this.overridesCache = overridesCache;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run(String overridePath) {
            Resource overrideRes = null;
            URI uri = URI.createURI((String)(String.valueOf(overridePath) + this.overrideFile));
            try {
                try {
                    overrideRes = this.rset.getResource(uri, true);
                    this.run(overrideRes);
                    return;
                }
                catch (WrappedException e) {
                    if (!(e.exception() instanceof FileNotFoundException || e.exception() instanceof CoreException && ((CoreException)e.exception()).getStatus().getCode() == 368)) {
                        if (e.exception() instanceof PackageNotFoundException && ((PackageNotFoundException)e.exception()).getMessage().indexOf("event.xmi") != -1) {
                            if (!RETRIEVED_EVENT_METHODS) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "An old style override file using the com.ibm.event format was found, but com.ibm.event was not installed. The first such file is " + uri, null));
                                RETRIEVED_EVENT_METHODS = true;
                            }
                        } else {
                            BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error loading file\"" + uri + "\"", (Throwable)e.exception()));
                        }
                    }
                    if ((overrideRes = this.rset.getResource(uri, false)) == null) return;
                    this.rset.getResources().remove((Object)overrideRes);
                    return;
                }
                catch (Exception e) {
                    BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error loading file\"" + uri + "\"", (Throwable)e));
                    overrideRes = this.rset.getResource(uri, false);
                    if (overrideRes == null) return;
                    this.rset.getResources().remove((Object)overrideRes);
                    return;
                }
            }
            finally {
                if (overrideRes != null) {
                    this.rset.getResources().remove((Object)overrideRes);
                }
            }
        }

        @Override
        public void run(Resource overrideRes) {
            block14: {
                try {
                    EList contents = overrideRes.getContents();
                    if (this.overridesCache != null) {
                        EcoreUtil.Copier copier = new EcoreUtil.Copier(){
                            private static final long serialVersionUID = 1L;

                            protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
                                if (eObject.eIsSet((EStructuralFeature)eReference)) {
                                    if (eReference.isMany()) {
                                        List source = (List)eObject.eGet((EStructuralFeature)eReference);
                                        InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                                        if (source.isEmpty()) {
                                            target.clear();
                                        } else {
                                            boolean isBidirectional = eReference.getEOpposite() != null;
                                            int index = 0;
                                            Iterator k = ((EcoreEList)source).basicIterator();
                                            while (k.hasNext()) {
                                                Object referencedEObject = k.next();
                                                Object copyReferencedEObject = this.get(referencedEObject);
                                                if (copyReferencedEObject == null) {
                                                    if (isBidirectional) continue;
                                                    target.addUnique(index, referencedEObject);
                                                    ++index;
                                                    continue;
                                                }
                                                if (isBidirectional) {
                                                    int position = target.indexOf(copyReferencedEObject);
                                                    if (position == -1) {
                                                        target.addUnique(index, copyReferencedEObject);
                                                    } else if (index != position) {
                                                        target.move(index, copyReferencedEObject);
                                                    }
                                                } else {
                                                    target.addUnique(index, copyReferencedEObject);
                                                }
                                                ++index;
                                            }
                                        }
                                    } else {
                                        Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, false);
                                        if (referencedEObject == null) {
                                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                                        } else {
                                            Object copyReferencedEObject = this.get(referencedEObject);
                                            if (copyReferencedEObject == null) {
                                                if (eReference.getEOpposite() == null) {
                                                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                                                }
                                            } else {
                                                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                                            }
                                        }
                                    }
                                }
                            }
                        };
                        for (Object o : contents) {
                            if (!(o instanceof ChangeDescription)) continue;
                            this.fixupCD((ChangeDescription)o);
                        }
                        Collection result = copier.copyAll((Collection)contents);
                        copier.copyReferences();
                        this.overridesCache.addAll(result);
                    }
                    if (contents.isEmpty()) break block14;
                    try {
                        ArrayList<Object> events = null;
                        Object[] eventsParm = null;
                        for (Object o : contents) {
                            if (o instanceof ChangeDescription) {
                                ChangeDescription cd = (ChangeDescription)o;
                                this.fixupCD(cd);
                                cd.apply();
                                continue;
                            }
                            if (!BeaninfoClassAdapter.isEventUtilLoaded()) continue;
                            if (events == null) {
                                events = new ArrayList<Object>(1);
                                events.add(null);
                                eventsParm = new Object[]{events};
                            }
                            events.set(0, o);
                            try {
                                Object util = CREATE_EVENT_UTIL_METHOD.invoke(EVENT_FACTORY_INSTANCE, this.mergeIntoJavaClass, this.rset);
                                DO_FORWARD_EVENTS_METHOD.invoke(util, eventsParm);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (InvocationTargetException e) {
                                BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error processing file\"" + overrideRes.getURI() + "\"", e.getCause()));
                            }
                        }
                    }
                    finally {
                        this.uninstallRootResource();
                    }
                }
                catch (WrappedException e) {
                    BeaninfoPlugin.getPlugin().getLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error processing file\"" + overrideRes.getURI() + "\"", (Throwable)e.exception()));
                }
            }
        }

        private void fixupCD(ChangeDescription cd) {
            EReference keyFeature = ChangePackage.eINSTANCE.getEObjectToChangesMapEntry_Key();
            for (EObject entry : cd.getObjectChanges()) {
                EObject key = (EObject)entry.eGet((EStructuralFeature)keyFeature, false);
                if (key == null || !key.eIsProxy()) continue;
                URI uri = ((InternalEObject)key).eProxyURI();
                String rootFrag = uri.fragment();
                if (!"X".equals(uri.scheme()) || !"ROOT".equals(uri.opaquePart()) || rootFrag == null || !rootFrag.startsWith(BeaninfoClassAdapter.ROOT_FRAGMENT)) continue;
                if (rootFrag.length() <= BeaninfoClassAdapter.ROOT_FRAGMENT.length()) {
                    entry.eSet((EStructuralFeature)keyFeature, (Object)this.mergeIntoJavaClass);
                    continue;
                }
                String[] path = FRAGMENT_SPLITTER.split(rootFrag.substring(BeaninfoClassAdapter.ROOT_FRAGMENT.length() + 1));
                InternalEObject newKey = (InternalEObject)this.mergeIntoJavaClass;
                int i = 0;
                while (newKey != null && i < path.length) {
                    newKey = (InternalEObject)newKey.eObjectForURIFragmentSegment(path[i]);
                    ++i;
                }
                if (newKey == null) continue;
                entry.eSet((EStructuralFeature)keyFeature, (Object)newKey);
            }
        }

        private void uninstallRootResource() {
            Resource root = this.rset.getResource(ROOT_URI, false);
            if (root != null) {
                this.rset.getResources().remove((Object)root);
            }
        }
    }

    private class PropertyInfo {
        public EClassifier type;
        public EClassifier indexedType;
        public boolean constrained;
        public Method getter;
        public Method setter;
        public Method indexedGetter;
        public Method indexedSetter;

        private PropertyInfo() {
        }

        public boolean setGetter(Method get, boolean mustBeBoolean) {
            boolean indexed;
            EList parms = get.getParameters();
            if (parms.size() > 1) {
                return false;
            }
            boolean bl = indexed = parms.size() == 1;
            if (indexed && !((JavaParameter)parms.get(0)).getEType().getName().equals("int")) {
                return false;
            }
            JavaHelpers retType = get.getReturnType();
            if (retType == null || retType.getName().equals("void")) {
                return false;
            }
            if (mustBeBoolean && !retType.getName().equals("boolean")) {
                return false;
            }
            if (indexed) {
                if (this.indexedType != null && this.indexedType != retType) {
                    return false;
                }
                if (!(this.type == null || ((JavaHelpers)this.type).isArray() && ((ArrayType)this.type).getComponentType() == retType)) {
                    return false;
                }
            } else {
                if (this.type != null && this.type != retType) {
                    return false;
                }
                if (!(this.indexedType == null || retType.isArray() && ((ArrayType)retType).getComponentType() == this.indexedType)) {
                    if (this.type == null) {
                        this.indexedGetter = null;
                        this.indexedSetter = null;
                        this.indexedType = null;
                    } else {
                        return false;
                    }
                }
            }
            if (indexed) {
                if (this.indexedGetter != null) {
                    return false;
                }
                this.indexedGetter = get;
                this.indexedType = retType;
            } else {
                if (this.getter != null) {
                    return false;
                }
                this.getter = get;
                this.type = retType;
            }
            return true;
        }

        public boolean setSetter(Method set) {
            boolean indexed;
            EList parms = set.getParameters();
            if (parms.size() > 2 || parms.size() < 1) {
                return false;
            }
            boolean bl = indexed = parms.size() == 2;
            if (indexed && !((JavaParameter)parms.get(0)).getEType().getName().equals("int")) {
                return false;
            }
            JavaHelpers retType = set.getReturnType();
            if (retType != null && !retType.getName().equals("void")) {
                return false;
            }
            EClassifier propType = null;
            if (indexed) {
                propType = ((JavaParameter)parms.get(1)).getEType();
                if (this.indexedType != null && this.indexedType != propType) {
                    return false;
                }
                if (!(this.type == null || ((JavaHelpers)this.type).isArray() && ((ArrayType)this.type).getComponentType() == propType)) {
                    return false;
                }
            } else {
                propType = ((JavaParameter)parms.get(0)).getEType();
                if (this.type != null && this.type != propType) {
                    return false;
                }
                if (!(this.indexedType == null || ((JavaHelpers)propType).isArray() && ((ArrayType)propType).getComponentType() == this.indexedType)) {
                    if (this.type == null) {
                        this.indexedGetter = null;
                        this.indexedSetter = null;
                        this.indexedType = null;
                    } else {
                        return false;
                    }
                }
            }
            if (indexed) {
                if (this.indexedSetter != null) {
                    return false;
                }
                this.indexedSetter = set;
                this.indexedType = propType;
            } else {
                if (this.setter != null) {
                    return false;
                }
                this.setter = set;
                this.type = propType;
            }
            if (set.getJavaExceptions().contains((Object)Utilities.getJavaClass("java.beans.PropertyVetoException", BeaninfoClassAdapter.this.getJavaClass().eResource().getResourceSet()))) {
                this.constrained = true;
            }
            return true;
        }

        public void createProperty(String name, boolean isBound) {
            boolean indexed;
            boolean bl = indexed = this.indexedType != null;
            if (indexed && this.type == null) {
                return;
            }
            PropertyDecorator prop = BeaninfoClassAdapter.this.createProperty(name, indexed, this.type);
            if (prop == null) {
                return;
            }
            indexed = prop instanceof IndexedPropertyDecorator;
            BeanInfoDecoratorUtility.setProperties(prop, isBound, this.constrained, this.getter, this.setter);
            if (indexed) {
                BeanInfoDecoratorUtility.setProperties((IndexedPropertyDecorator)prop, this.indexedGetter, this.indexedSetter);
            }
        }
    }
}

