/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.generator.AbstractJavaElementGenerator;
import org.eclipse.scout.sdk.core.java.generator.IAnnotatableGenerator;
import org.eclipse.scout.sdk.core.java.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class AbstractAnnotatableGenerator<TYPE extends IAnnotatableGenerator<TYPE>>
extends AbstractJavaElementGenerator<TYPE>
implements IAnnotatableGenerator<TYPE> {
    private final List<IAnnotationGenerator<?>> m_annotations;

    protected AbstractAnnotatableGenerator() {
        this.m_annotations = new ArrayList();
    }

    protected AbstractAnnotatableGenerator(IAnnotatable element, IWorkingCopyTransformer transformer) {
        super(element);
        this.m_annotations = element.annotations().stream().map(a -> IWorkingCopyTransformer.transformAnnotation(a, transformer)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    @Override
    public TYPE withAnnotation(IAnnotationGenerator<?> generator) {
        if (generator != null) {
            this.m_annotations.add(generator);
        }
        return (TYPE)((IAnnotatableGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutAllAnnotations() {
        this.m_annotations.clear();
        return (TYPE)((IAnnotatableGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutAnnotation(String annotationFqn) {
        return this.withoutAnnotation((IAnnotationGenerator<?> g) -> Objects.equals(annotationFqn, g.elementName().orElse(null)));
    }

    @Override
    public TYPE withoutAnnotation(Predicate<IAnnotationGenerator<?>> removalFilter) {
        if (removalFilter == null) {
            return this.withoutAllAnnotations();
        }
        this.m_annotations.removeIf(removalFilter);
        return (TYPE)((IAnnotatableGenerator)this.thisInstance());
    }

    @Override
    public Optional<IAnnotationGenerator<?>> annotation(String annotationFqn) {
        Ensure.notNull((Object)annotationFqn);
        return this.m_annotations.stream().filter(g -> annotationFqn.equals(g.elementName().orElse(null))).findAny();
    }

    @Override
    public Stream<IAnnotationGenerator<?>> annotations() {
        return this.m_annotations.stream();
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        super.build(builder);
        this.createAnnotations(builder);
    }

    protected String annotationDelimiter(ISourceBuilder<?> builder) {
        return builder.context().lineDelimiter();
    }

    protected void createAnnotations(IJavaSourceBuilder<?> builder) {
        if (this.m_annotations.isEmpty()) {
            return;
        }
        this.m_annotations.stream().map(g -> g.toJavaSource(builder.context())).sorted(Comparator.comparingInt(CharSequence::length).thenComparing(Strings::compareTo)).forEach(g -> ((IJavaSourceBuilder)builder.append((CharSequence)g)).append(this.annotationDelimiter(builder)));
    }
}

