/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.eclipse.jdt.internal.eval.EvaluationResult;
import org.eclipse.jdt.internal.eval.IRequestor;

public abstract class Evaluator {
    EvaluationContext context;
    INameEnvironment environment;
    Map<String, String> options;
    IRequestor requestor;
    IProblemFactory problemFactory;

    Evaluator(EvaluationContext context, INameEnvironment environment, Map<String, String> options, IRequestor requestor, IProblemFactory problemFactory) {
        this.context = context;
        this.environment = environment;
        this.options = options;
        this.requestor = requestor;
        this.problemFactory = problemFactory;
    }

    protected abstract void addEvaluationResultForCompilationProblem(Map<char[], EvaluationResult> var1, CategorizedProblem var2, char[] var3);

    protected EvaluationResult[] evaluationResultsForCompilationProblems(CompilationResult result, char[] cuSource) {
        CategorizedProblem[] problems = result.getAllProblems();
        HashMap<char[], EvaluationResult> resultsByIDs = new HashMap<char[], EvaluationResult>(5);
        CategorizedProblem[] categorizedProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            CategorizedProblem problem = categorizedProblemArray[n2];
            this.addEvaluationResultForCompilationProblem(resultsByIDs, problem, cuSource);
            ++n2;
        }
        int size = resultsByIDs.size();
        EvaluationResult[] evalResults = new EvaluationResult[size];
        Iterator results = resultsByIDs.values().iterator();
        int i = 0;
        while (i < size) {
            evalResults[i] = (EvaluationResult)results.next();
            ++i;
        }
        return evalResults;
    }

    ClassFile[] getClasses() {
        final char[] source = this.getSource();
        ArrayList classDefinitions = new ArrayList();
        class CompilerRequestor
        implements ICompilerRequestor {
            boolean hasErrors = false;
            private final /* synthetic */ char[] val$source;
            private final /* synthetic */ ArrayList val$classDefinitions;

            CompilerRequestor(char[] cArray, ArrayList arrayList) {
                this.val$source = cArray;
                this.val$classDefinitions = arrayList;
            }

            public void acceptResult(CompilationResult result) {
                int n;
                int n2;
                Object[] objectArray;
                if (result.hasProblems()) {
                    EvaluationResult[] evalResults = Evaluator.this.evaluationResultsForCompilationProblems(result, this.val$source);
                    objectArray = evalResults;
                    n2 = evalResults.length;
                    n = 0;
                    while (n < n2) {
                        CategorizedProblem[] problems;
                        ClassFile evalResult = objectArray[n];
                        CategorizedProblem[] categorizedProblemArray = problems = evalResult.getProblems();
                        int n3 = problems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            CategorizedProblem problem = categorizedProblemArray[n4];
                            Evaluator.this.requestor.acceptProblem(problem, evalResult.getEvaluationID(), evalResult.getEvaluationType());
                            ++n4;
                        }
                        ++n;
                    }
                }
                if (result.hasErrors()) {
                    this.hasErrors = true;
                } else {
                    ClassFile[] classFiles;
                    objectArray = classFiles = result.getClassFiles();
                    n2 = classFiles.length;
                    n = 0;
                    while (n < n2) {
                        ClassFile classFile = objectArray[n];
                        this.val$classDefinitions.add(classFile);
                        ++n;
                    }
                }
            }
        }
        CompilerRequestor compilerRequestor = new CompilerRequestor(source, classDefinitions);
        Compiler compiler = this.getCompiler(compilerRequestor);
        compiler.compile(new ICompilationUnit[]{new ICompilationUnit(){

            public char[] getFileName() {
                return CharOperation.concat((char[])Evaluator.this.getClassName(), (char[])Util.defaultJavaExtension().toCharArray());
            }

            public char[] getContents() {
                return source;
            }

            public char[] getMainTypeName() {
                return Evaluator.this.getClassName();
            }

            public char[][] getPackageName() {
                return null;
            }

            public boolean ignoreOptionalProblems() {
                return false;
            }

            public char[] getModuleName() {
                return null;
            }
        }});
        if (compilerRequestor.hasErrors) {
            return null;
        }
        ClassFile[] result = new ClassFile[classDefinitions.size()];
        classDefinitions.toArray(result);
        return result;
    }

    protected abstract char[] getClassName();

    Compiler getCompiler(ICompilerRequestor compilerRequestor) {
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        return new Compiler(this.environment, DefaultErrorHandlingPolicies.exitAfterAllProblems(), compilerOptions, compilerRequestor, this.problemFactory);
    }

    protected abstract char[] getSource();
}

