/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.ImageTooltip;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.EClassLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.AreaIconDialogEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerValueProperty;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AreaEditor
extends AbstractComponentEditor<MArea> {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();
    @Inject
    @Optional
    private IProject project;
    @Inject
    IEclipseContext eclipseContext;

    @Inject
    public AreaEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.PartSashContainerEditor_AddPartSashContainer, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.PartSashContainer")){

            public void run() {
                AreaEditor.this.handleAddChild(BasicPackageImpl.Literals.PART_SASH_CONTAINER);
            }
        });
        this.actions.add(new Action(this.Messages.PartSashContainerEditor_AddPartStack, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.PartStack")){

            public void run() {
                AreaEditor.this.handleAddChild(BasicPackageImpl.Literals.PART_STACK);
            }
        });
        this.actions.add(new Action(this.Messages.PartSashContainerEditor_AddPart, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Part")){

            public void run() {
                AreaEditor.this.handleAddChild(BasicPackageImpl.Literals.PART);
            }
        });
        this.actions.add(new Action(this.Messages.PartSashContainerEditor_AddArea, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Area")){

            public void run() {
                AreaEditor.this.handleAddChild(AdvancedPackageImpl.Literals.AREA);
            }
        });
        this.actions.add(new Action(this.Messages.PartSashContainerEditor_AddPlaceholder, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Placeholder")){

            public void run() {
                AreaEditor.this.handleAddChild(AdvancedPackageImpl.Literals.PLACEHOLDER);
            }
        });
    }

    @Override
    public Image getImage(Object element) {
        boolean horizontal = ((MPartSashContainer)element).isHorizontal();
        return horizontal ? this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Area") : this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Area_vertical");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.AreaEditor_Label;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.AreaEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        this.getMaster().setValue((Object)((MArea)object));
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MArea> master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.AreaEditor_LabelLabel, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.label(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.AreaEditor_Tooltip, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.tooltip(this.getEditingDomain()));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.AreaEditor_IconURI);
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.iconUri(this.getEditingDomain()).observeDetail(master));
        new ImageTooltip((Control)t, this.Messages, this);
        final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AreaIconDialogEditor dialog = new AreaIconDialogEditor(b.getShell(), AreaEditor.this.eclipseContext, AreaEditor.this.project, AreaEditor.this.getEditingDomain(), (MApplicationElement)AreaEditor.this.getMaster().getValue(), AreaEditor.this.Messages);
                dialog.open();
            }
        });
        l = new Label(parent, 0);
        l.setText(this.Messages.AreaEditor_Orientation);
        l.setLayoutData((Object)new GridData());
        ComboViewer viewer = new ComboViewer(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        viewer.getControl().setLayoutData((Object)gd);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (Boolean)element != false ? ((AreaEditor)AreaEditor.this).Messages.AreaEditor_Horizontal : ((AreaEditor)AreaEditor.this).Messages.AreaEditor_Vertical;
            }
        });
        viewer.setInput((Object)new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        IViewerValueProperty vProp = ViewerProperties.singleSelection();
        context.bindValue(vProp.observe((Object)viewer), E4Properties.horizontal(this.getEditingDomain()).observeDetail(this.getMaster()));
        ControlFactory.createSelectedElement(parent, this, context, this.Messages.AreaEditor_SelectedElement);
        ControlFactory.createTextField(parent, this.Messages.AreaEditor_ContainerData, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.containerData(this.getEditingDomain()));
        E4PickList pickList = new E4PickList(parent, 0, null, (AbstractComponentEditor)this, (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN){

            @Override
            protected void addPressed() {
                EClass eClass = (EClass)this.getSelection().getFirstElement();
                AreaEditor.this.handleAddChild(eClass);
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(this.Messages.AreaEditor_Controls);
        viewer = pickList.getList();
        viewer.setInput((Object)E4Properties.children().observeDetail(this.getMaster()));
        pickList.setLabelProvider((ILabelProvider)new EClassLabelProvider(this.getEditor()));
        pickList.setInput(new EClass[]{BasicPackageImpl.Literals.PART_SASH_CONTAINER, BasicPackageImpl.Literals.PART_STACK, BasicPackageImpl.Literals.PART, AdvancedPackageImpl.Literals.AREA, AdvancedPackageImpl.Literals.PLACEHOLDER});
        pickList.setSelection((ISelection)new StructuredSelection((Object)BasicPackageImpl.Literals.PART_SASH_CONTAINER));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.toBeRendered(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.visible(this.getEditingDomain()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.accessibilityPhrase(this.getEditingDomain()));
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.ModelTooling_ApplicationElement_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MArea.class);
        folder.setSelection(0);
        return folder;
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    protected void handleAddChild(EClass eClass) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        this.setElementId(eObject);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)eObject);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(eObject);
        }
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return E4Properties.children().observe((Object)((MArea)element));
    }

    @Override
    public String getDetailLabel(Object element) {
        return this.getLocalizedLabel((MUILabel)element);
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__LABEL}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__ICON_URI}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.GENERIC_TILE__HORIZONTAL}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }
}

