/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class GlobPathMatcher {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pattern;
    private String pathSeparator;
    private boolean caseSensitive;
    private String[] pattDirs;
    private Pattern[] pattPats;

    public GlobPathMatcher(String pattern) {
        this(pattern, DEFAULT_PATH_SEPARATOR, true);
    }

    public GlobPathMatcher(String pattern, String pathSeparator, boolean caseSensitive) {
        Objects.requireNonNull(pathSeparator, "'pathSeparator' is required");
        this.pattern = pattern;
        this.pathSeparator = pathSeparator;
        this.caseSensitive = caseSensitive;
        this.pattDirs = this.tokenizePath(pattern);
        this.pattPats = new Pattern[this.pattDirs.length];
        for (int i = 0; i < this.pattDirs.length; ++i) {
            this.pattPats[i] = this.createMatcherPattern(this.pattDirs[i]);
        }
    }

    public boolean matches(String path, boolean fullMatch) {
        String pattDir;
        int pathIdxStart;
        if (path.startsWith(this.pathSeparator) != this.pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pathDirs = this.tokenizePath(path);
        int pattIdxStart = 0;
        int pattIdxEnd = this.pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(pattDir = this.pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(pattIdxStart, pathDirs[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return this.pattern.endsWith(this.pathSeparator) == path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && this.pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (this.pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(this.pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = this.pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(pattIdxEnd, pathDirs[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (this.pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!this.pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (!this.matchStrings(pattIdxStart + j + 1, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (this.pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    private String[] tokenizePath(String path) {
        StringTokenizer st = new StringTokenizer(path, this.pathSeparator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private boolean matchStrings(int pattIdx, String str) {
        return this.pattPats[pattIdx].matcher(str).matches();
    }

    private Pattern createMatcherPattern(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append("\\\\");
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    sb.append(inClass == 0 ? ".*" : "*");
                    continue block16;
                }
                case '?': {
                    sb.append(inClass == 0 ? (char)'.' : '?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    sb.append(firstIndexInClass == i ? (char)'^' : '!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    sb.append(inGroup > 0 ? (char)'|' : ',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return this.caseSensitive ? Pattern.compile(sb.toString()) : Pattern.compile(sb.toString(), 2);
    }
}

