/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ComponentPropertyHandler;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttribute;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttributeHandler;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.TagAttributeHandler;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataLoader;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.AttributeToPropertyMapping;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.IAttributeAdvisor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTagAttribute;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.FaceletAttribute;

class MetadataAttributeAdvisor
implements IAttributeAdvisor {
    private final TagIdentifier _tagId;
    private final ViewMetadataLoader _loader;
    private List<FaceletTaglibTagAttribute> _attributes;

    public MetadataAttributeAdvisor(TagIdentifier tagId, ViewMetadataLoader loader, List<FaceletTaglibTagAttribute> attributes) {
        this._tagId = tagId;
        this._loader = loader;
        this._attributes = attributes;
    }

    public ITagAttributeHandler createAttributeHandler(String name) throws IAttributeAdvisor.UnknownAttributeException {
        AttributeToPropertyMapping mapping = this._loader.getAttributeMapping(this._tagId, name);
        if (mapping != null) {
            String customHandler = mapping.getCustomConversionFactoryId();
            boolean isELAllowed = mapping.isElAllowed();
            String propertyName = mapping.getPropertyName();
            if (propertyName != null) {
                return new ComponentPropertyHandler(customHandler, name, isELAllowed, propertyName);
            }
            return new TagAttributeHandler(customHandler, name, isELAllowed);
        }
        return new TagAttributeHandler(null, name, false);
    }

    public Map<String, ? extends ITagAttribute> getAttributes() {
        HashMap<String, FaceletAttribute> attributes = new HashMap<String, FaceletAttribute>();
        for (FaceletTaglibTagAttribute attribute : this._attributes) {
            attributes.put(attribute.getName(), new FaceletAttribute(attribute));
        }
        return Collections.unmodifiableMap(attributes);
    }
}

