/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.apache.wsil.util.WSDLDocumentIdentifier;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WSDLDocument {
    protected static final String className = "WSDLDocument";
    private Definition wsdlDocumentDef = null;
    public static final String NS_URI_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_URI_WSDL_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String NS_URI_WSDL_HTTP = "http://schemas.xmlsoap.org/wsdl/http/";
    public static final String NS_URI_WSDL_MIME = "http://schemas.xmlsoap.org/wsdl/mime/";
    public static final String WSDL_FACTORY = "com.ibm.wsdl.factory.WSDLFactoryImpl";
    protected static WSDLFactory wsdlFactory = null;
    protected static WSDLException wsdlException = null;
    private static String WSDL4J_DEFINITION_FACTORY_PROP;

    static {
        try {
            wsdlFactory = WSDLFactory.newInstance((String)WSDL_FACTORY);
        }
        catch (WSDLException e) {
            wsdlException = e;
        }
        WSDL4J_DEFINITION_FACTORY_PROP = "javax.wsdl.factory.DefinitionFactory";
        String existing = System.getProperty(WSDL4J_DEFINITION_FACTORY_PROP);
        if (existing == null) {
            System.setProperty(WSDL4J_DEFINITION_FACTORY_PROP, "com.ibm.wsdl.factory.IBMWSTKDefinitionFactoryImpl");
        }
    }

    public WSDLDocument(String fileName) throws WSDLException {
        this.read(fileName);
    }

    public WSDLDocument(URL documentURL) throws WSDLException {
        this(documentURL.toExternalForm());
    }

    public WSDLDocument(Reader reader) throws WSDLException {
        this.wsdlDocumentDef = WSDLDocument.getWSDLReader().readWSDL(null, new InputSource(reader));
    }

    public static WSDLReader getWSDLReader() throws WSDLException {
        return WSDLDocument.getWSDLReader(false);
    }

    public static WSDLReader getWSDLReader(boolean imports) throws WSDLException {
        if (wsdlException != null) {
            throw wsdlException;
        }
        WSDLReader ret = null;
        ret = wsdlFactory.newWSDLReader();
        ret.setFeature("javax.wsdl.verbose", false);
        ret.setFeature("javax.wsdl.importDocuments", imports);
        return ret;
    }

    public static WSDLWriter getWSDLWriter() throws WSDLException {
        if (wsdlException != null) {
            throw wsdlException;
        }
        WSDLWriter ret = null;
        ret = wsdlFactory.newWSDLWriter();
        return ret;
    }

    public WSDLDocument(Document document) throws WSDLException {
        this.wsdlDocumentDef = WSDLDocument.getWSDLReader().readWSDL(null, document);
    }

    public WSDLDocument(Definition definition) throws WSDLException {
        this.wsdlDocumentDef = definition;
    }

    public void read(String fileName) throws WSDLException {
        this.read(fileName, true);
    }

    public void read(String fileName, boolean imports) throws WSDLException {
        this.wsdlDocumentDef = WSDLDocument.getWSDLReader(imports).readWSDL(null, fileName);
    }

    public void write(String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            this.write(fw);
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IOException occurred attempting to write document to file: " + fileName);
        }
    }

    public void write(Writer writer) {
        try {
            WSDLDocument.getWSDLWriter().writeWSDL(this.wsdlDocumentDef, writer);
        }
        catch (WSDLException e) {
            System.out.println("Exception occurred writing the document.");
            e.printStackTrace();
        }
    }

    public String serializeToXML() {
        StringWriter sw = new StringWriter();
        this.write(sw);
        try {
            sw.close();
        }
        catch (IOException e) {
            System.out.println("IOException occurred closing the writer");
        }
        return sw.toString();
    }

    public Definition getDefinitions() {
        return this.wsdlDocumentDef;
    }

    public Message[] getMessages() {
        return this.wsdlDocumentDef.getMessages().values().toArray(new Message[0]);
    }

    public PortType[] getPortTypes() {
        return this.wsdlDocumentDef.getPortTypes().values().toArray(new PortType[0]);
    }

    public Binding[] getBindings() {
        return this.wsdlDocumentDef.getBindings().values().toArray(new Binding[0]);
    }

    public Import[] getImports() {
        Iterator importListIterator = this.wsdlDocumentDef.getImports().values().iterator();
        Vector importVector = new Vector();
        while (importListIterator.hasNext()) {
            importVector.addAll((List)importListIterator.next());
        }
        return importVector.toArray(new Import[0]);
    }

    public Service[] getServices() {
        return this.wsdlDocumentDef.getServices().values().toArray(new Service[0]);
    }

    public boolean isServiceInterface() {
        return WSDLDocumentIdentifier.isInterfaceDocument(this);
    }

    public boolean isServiceInterfaceWithBindingsOnly() {
        return WSDLDocumentIdentifier.isBindingInterfaceDocument(this);
    }

    public boolean isServiceImplementation() {
        return WSDLDocumentIdentifier.isImplementationDocument(this);
    }

    public boolean isCompleteServiceDefinition() {
        return WSDLDocumentIdentifier.isCompleteDocument(this);
    }

    public WSDLDocument findServiceInterface() throws WSDLException {
        WSDLDocument wsdlDoc = null;
        if (this.isServiceImplementation()) {
            Import[] wsdlImportList = this.getImports();
            int i = 0;
            while (i < wsdlImportList.length) {
                String documentURI = wsdlImportList[i].getLocationURI();
                wsdlDoc = new WSDLDocument(documentURI);
                if (wsdlDoc.isServiceInterface()) {
                    return wsdlDoc;
                }
                wsdlDoc = null;
                ++i;
            }
        }
        return wsdlDoc;
    }

    public String toString() {
        return this.wsdlDocumentDef == null ? "WSDL definition element is null." : this.wsdlDocumentDef.toString();
    }

    public static void main(String[] args) {
        String filename = null;
        if (args.length == 0) {
            System.out.println("Usage: WSDLDocument <filename>");
        } else {
            try {
                filename = args[0];
                System.out.println("Reading WSDL document [" + filename + "]...");
                WSDLDocument wsdlDocument = new WSDLDocument(filename);
                System.out.println("Document contents: ");
                System.out.println(wsdlDocument.toString());
            }
            catch (Exception e) {
                System.out.println("EXCEPTION: Could not process WSDL document [" + filename + "].");
                e.printStackTrace();
            }
        }
        System.exit(0);
    }
}

