/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETSubItem;

public class JETItem {
    private final JETMark start;
    private final JETMark stop;
    private static final Pattern TEXT_REPLACEMENT_PATTERN = Pattern.compile("([\\u0000-\\u001f\\\\])");
    private static final String[] ESCAPES = new String[]{"\\\\u0000", "\\\\u0001", "\\\\u0002", "\\\\u0003", "\\\\u0004", "\\\\u0005", "\\\\u0006", "\\\\u0007", "\\\\b", "\\\\t", "\\\\n", "\\\\u000b", "\\\\f", "\\\\r", "\\\\u000e", "\\\\u000f", "\\\\u0010", "\\\\u0011", "\\\\u0012", "\\\\u0013", "\\\\u0014", "\\\\u0015", "\\\\u0016", "\\\\u0017", "\\\\u0018", "\\\\u0019", "\\\\u001a", "\\\\u001b", "\\\\u001c", "\\\\u001d", "\\\\u001e", "\\\\u001f"};

    JETItem(JETMark start, JETMark stop) {
        this.start = start;
        this.stop = stop;
        Assert.isNotNull((Object)start, (String)"An item must have a start");
        Assert.isNotNull((Object)start, (String)"An item must have a stop");
        this.assertDoesNotSpanFiles();
    }

    protected void assertDoesNotSpanFiles() {
        Assert.isTrue((this.start.getFileId() == this.stop.getFileId() ? 1 : 0) != 0, (String)"An item must not span differnt files");
    }

    public final int getFileID() {
        return this.start.getFileId();
    }

    public final JETMark getStart() {
        return this.start;
    }

    public final JETMark getStop() {
        return this.stop;
    }

    public final int getStartOffset() {
        return this.start.getCursor();
    }

    public final int getStopOffset() {
        return this.stop.getCursor();
    }

    public final int getLength() {
        return this.getStopOffset() - this.getStartOffset();
    }

    public String getText() {
        return new String(this.start.reader.getChars(this.start, this.stop));
    }

    public boolean isAncestor(JETItem jetItem) {
        JETItem parent = jetItem;
        while (parent != null) {
            if (parent == this) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public JETItem getParent() {
        return null;
    }

    public List<JETSubItem> getChildren() {
        return Collections.emptyList();
    }

    public JETSubItem getChild(int fileID, int templateOffset) {
        for (JETSubItem child : this.getChildren()) {
            if (child.getFileID() != fileID || child.getStartOffset() > templateOffset || templateOffset >= child.getStopOffset()) continue;
            return child;
        }
        return null;
    }

    public JETSubItem getLeaf(int fileID, int templateOffset) {
        JETSubItem child = this.getChild(fileID, templateOffset);
        return child == null ? this.asSubItem() : child.getLeaf(fileID, templateOffset);
    }

    protected JETSubItem asSubItem() {
        return null;
    }

    public JETItem getRoot() {
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String file = this.start.getFile();
        if (file != null && file.length() != 0) {
            result.append(file).append(":").append(this.getFileID());
        } else {
            int fileID = this.getFileID();
            if (fileID != 0) {
                result.append(fileID);
            }
        }
        return result.append('[').append(this.getStartOffset()).append(',').append(this.getStopOffset()).append("] ").append(JETItem.toString(this.getText())).toString();
    }

    public static String toString(String text) {
        if (text == null) {
            return "null";
        }
        Matcher matcher = TEXT_REPLACEMENT_PATTERN.matcher(text);
        if (matcher.find()) {
            StringBuffer result = new StringBuffer(text.length() + 20);
            do {
                String group;
                matcher.appendReplacement(result, "\\".equals(group = matcher.group()) ? "\\\\" : ESCAPES[group.charAt(0)]);
            } while (matcher.find());
            matcher.appendTail(result);
            return String.valueOf('\u00ab') + result.toString() + '\u00bb';
        }
        return String.valueOf('\u00ab') + text + '\u00bb';
    }
}

