/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.nodes;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.nodes.AbstractRouter;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Point;

public class StraightRouter
extends AbstractRouter {
    @Override
    protected Point getAnchoredReferencePoint(List<Point> points, int index) {
        if (index < 0 || index >= points.size()) {
            throw new IndexOutOfBoundsException();
        }
        Point newRef = null;
        Point pred = this.getPred(points, index);
        Point succ = this.getSucc(points, index);
        newRef = pred == null && succ == null ? new Point() : (succ == null && pred != null ? pred : (pred == null && succ != null ? succ : new Line(pred, succ).get(0.5)));
        return newRef;
    }

    private Point getNeighbor(List<Point> points, int anchorIndex, int step) {
        ObservableList<IAnchor> anchors = this.getConnection().getAnchorsUnmodifiable();
        IAnchor anchor = (IAnchor)anchors.get(anchorIndex);
        if (!(anchor instanceof DynamicAnchor)) {
            throw new IllegalStateException("Specified anchor '" + anchor + "' is no DynamicAnchor.");
        }
        Node anchorage = anchor.getAnchorage();
        int i = anchorIndex + step;
        while (i < anchors.size() && i >= 0) {
            Point position;
            IAnchor predAnchor = (IAnchor)anchors.get(i);
            if (predAnchor == null) {
                throw new IllegalStateException("connection inconsistent (null anchor)");
            }
            Node predAnchorage = predAnchor.getAnchorage();
            if (predAnchorage == null || predAnchorage == this.getConnection()) {
                position = points.get(i);
                Point2D local = anchorage.sceneToLocal(this.getConnection().localToScene(position.x, position.y));
                if (!anchorage.contains(local)) {
                    return position;
                }
            } else {
                position = this.getAnchorageGeometry(i).getBounds().getCenter();
                if (position == null || Double.isNaN(position.x) || Double.isNaN(position.y)) {
                    throw new IllegalStateException("cannot determine anchorage center");
                }
                return position;
            }
            i += step;
        }
        return null;
    }

    private Point getPred(List<Point> points, int anchorIndex) {
        return this.getNeighbor(points, anchorIndex, -1);
    }

    private Point getSucc(List<Point> points, int anchorIndex) {
        return this.getNeighbor(points, anchorIndex, 1);
    }
}

