/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class BreakpointRenamePackageParticipant
extends BreakpointRenameParticipant {
    @Override
    protected boolean accepts(IJavaElement element) {
        return element instanceof IPackageFragment;
    }

    @Override
    protected void gatherChanges(IMarker[] markers, List<Change> changes, String destPackageName) throws CoreException, OperationCanceledException {
        IPackageFragment originalPackage = (IPackageFragment)this.getOriginalElement();
        String originalPackageName = originalPackage.getElementName();
        IPackageFragmentRoot root = (IPackageFragmentRoot)originalPackage.getParent();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaBreakpoint javaBreakpoint;
            IType breakpointType;
            IMarker marker = iMarkerArray[n2];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaBreakpoint && (breakpointType = BreakpointUtils.getType(javaBreakpoint = (IJavaBreakpoint)breakpoint)) != null) {
                IPackageFragment destBreakpointPackage;
                ICompilationUnit cu;
                IJavaElement element;
                String breakpointPackageName = breakpointType.getPackageFragment().getElementName();
                Object destBreakpointPackageName = destPackageName;
                if (breakpointPackageName.length() > originalPackageName.length()) {
                    destBreakpointPackageName = (String)destBreakpointPackageName + breakpointPackageName.substring(originalPackageName.length());
                }
                if ((element = BreakpointChange.findElement((IJavaElement)(cu = (destBreakpointPackage = root.getPackageFragment((String)destBreakpointPackageName)).getCompilationUnit(breakpointType.getCompilationUnit().getElementName())), (IJavaElement)breakpointType)) != null && element instanceof IType) {
                    IType destType = (IType)element;
                    changes.add(this.createTypeChange(javaBreakpoint, destType, breakpointType));
                }
            }
            ++n2;
        }
    }
}

