/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.spi.cdo.InternalCDOSession;

public class LoadPermissionsRequest
extends CDOClientRequest<Map<CDORevision, CDOPermission>> {
    private Map<CDOBranchPoint, Set<InternalCDORevision>> revisionsBySecurityContext;
    private List<CDOBranchPoint> securityContexts;

    public LoadPermissionsRequest(CDOClientProtocol protocol, Map<CDOBranchPoint, Set<InternalCDORevision>> revisionsBySecurityContext) {
        super(protocol, (short)55);
        this.revisionsBySecurityContext = revisionsBySecurityContext;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        int mapSize = this.revisionsBySecurityContext.size();
        out.writeXInt(mapSize);
        this.securityContexts = new ArrayList<CDOBranchPoint>(mapSize);
        for (Map.Entry<CDOBranchPoint, Set<InternalCDORevision>> entry : this.revisionsBySecurityContext.entrySet()) {
            CDOBranchPoint securityContext = entry.getKey();
            out.writeCDOBranchPoint(securityContext);
            this.securityContexts.add(securityContext);
            Set<InternalCDORevision> revisions = entry.getValue();
            out.writeXInt(revisions.size());
            for (InternalCDORevision revision : revisions) {
                CDOID id = revision.getID();
                out.writeCDOID(id);
                byte bits = revision.getPermission().getBits();
                out.writeByte((int)bits);
            }
        }
        int referenceChunk = this.getSession().options().getCollectionLoadingPolicy().getInitialChunkSize();
        out.writeXInt(referenceChunk);
    }

    @Override
    protected Map<CDORevision, CDOPermission> confirming(CDODataInput in) throws IOException {
        HashMap<CDORevision, CDOPermission> oldPermissions = new HashMap<CDORevision, CDOPermission>();
        InternalCDOSession session = this.getSession();
        try {
            session.syncExec(() -> {
                for (CDOBranchPoint securityContext : this.securityContexts) {
                    Set<InternalCDORevision> set = this.revisionsBySecurityContext.get(securityContext);
                    for (InternalCDORevision revision : set) {
                        CDOPermission newPermission;
                        CDOPermission oldPermission;
                        byte bits = in.readByte();
                        if (bits == -1 || (oldPermission = revision.getPermission()) == (newPermission = CDOPermission.get((int)bits))) continue;
                        boolean bypassPermissionChecks = revision.bypassPermissionChecks(true);
                        try {
                            if (oldPermission == CDOPermission.NONE) {
                                revision.readValues(in);
                            }
                            revision.setPermission(newPermission);
                        }
                        finally {
                            revision.bypassPermissionChecks(bypassPermissionChecks);
                        }
                        oldPermissions.put((CDORevision)revision, oldPermission);
                    }
                }
            });
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return oldPermissions;
    }
}

