/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.image;

import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.Gallery;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class GallerySelectable
extends Gallery {
    public GallerySelectable(Composite parent, int style) {
        super(parent, style);
    }

    public void selectItem(GalleryItem item, boolean notifyListeners) {
        this.setSelection(new GalleryItem[]{item}, notifyListeners);
    }

    @Override
    public void setSelection(GalleryItem[] items) {
        this.setSelection(items, false);
    }

    public void setSelection(GalleryItem[] items, boolean notifyListeners) {
        this.checkWidget();
        this._deselectAll(false);
        int i = 0;
        while (i < items.length) {
            this.setSelected(items[i], true, notifyListeners);
            this.showItem(items[i]);
            this.lastSingleClick = items[i];
            ++i;
        }
        this.redraw();
    }

    @Override
    public void showItem(GalleryItem item) {
        if (item != null) {
            Rectangle rect = this.getGroupRenderer().getSize(item);
            if (rect == null) {
                return;
            }
            if (this.isVertical()) {
                int y = rect.y;
                int height = rect.height;
                if (y < this.translate) {
                    this.translate = y;
                } else if (this.translate + this.getClientArea().height < y + height) {
                    this.translate = y + height - this.getClientArea().height;
                }
            } else {
                int y = rect.x;
                int height = rect.width;
                if (y < this.translate) {
                    this.translate = y;
                } else if (this.translate + this.getClientArea().width < y + height) {
                    this.translate = y + height - this.getClientArea().width;
                }
            }
            this.updateScrollBarsProperties();
            this.redraw();
        }
    }
}

