/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamSpec;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.provider.LMEditPlugin;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class NewStreamAction
extends LMAction.NewElement<Module> {
    private static final int INVALID_VERSION = -1;
    private final AdapterFactory adapterFactory;
    private ISystemDescriptor systemDescriptor;
    private EList<Drop> possibleBases;
    private Drop lastBase;
    private Stream lastStream;
    private Drop base;
    private CommonStreamParameters<Module> streamParameters;

    public NewStreamAction(IWorkbenchPage page, StructuredViewer viewer, AdapterFactory adapterFactory, Module module) {
        super(page, viewer, "New Stream" + INTERACTIVE, "Add a new stream to module '" + module.getName() + "'", ExtendedImageRegistry.INSTANCE.getImageDescriptor(LMEditPlugin.INSTANCE.getImage("full/obj16/Stream")), "Add a new stream to module '" + module.getName() + "'.", "icons/wizban/NewStream.png", module);
        this.adapterFactory = adapterFactory;
    }

    @Override
    protected void preRun() throws Exception {
        Module module = (Module)this.getContext();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)module.getSystem());
        this.possibleBases = new BasicEList();
        this.lastBase = null;
        this.lastStream = null;
        for (Stream stream : module.getStreams()) {
            for (Baseline baseline : stream.getContents()) {
                Drop drop;
                if (!(baseline instanceof Drop) || !(drop = (Drop)baseline).isRelease()) continue;
                this.possibleBases.add((Object)drop);
                this.lastBase = drop;
            }
            this.lastStream = stream;
        }
        if (this.lastStream != null && this.lastBase == null) {
            this.openError("No existing stream contains a release that allows for a new stream.");
            this.cancel();
            return;
        }
        this.streamParameters = this.lastStream == null ? new CommonStreamParameters<Module>(this, 1, 0) : new CommonStreamParameters<Module>(this, this.lastStream.getMajorVersion(), this.lastStream.getMinorVersion() + 1);
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Base:");
        label.setEnabled(this.lastStream != null);
        ComboViewer viewer = new ComboViewer(parent, 2052);
        viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        viewer.getControl().setEnabled(this.lastStream != null);
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(this.possibleBases);
        if (this.lastBase != null) {
            this.base = this.lastBase;
            viewer.setSelection((ISelection)new StructuredSelection((Object)this.base));
        }
        viewer.addSelectionChangedListener(e -> {
            this.base = (Drop)e.getStructuredSelection().getFirstElement();
            this.validateDialog();
        });
        this.streamParameters.fillDialogArea(parent);
    }

    @Override
    protected String doValidate(LMAction.LMDialog dialog) {
        if (this.base == null && this.lastStream != null) {
            return "A base drop must be selected.";
        }
        String result = this.streamParameters.validate();
        if (result != null) {
            return result;
        }
        return super.doValidate(dialog);
    }

    @Override
    protected CDOObject newElement(Module module, IProgressMonitor monitor) throws Exception {
        return this.systemDescriptor.createStream(module, this.base, this.streamParameters, monitor);
    }

    public static final class CommonStreamParameters<CONTEXT extends CDOObject>
    extends StreamSpec {
        private LMAction<CONTEXT> lmAction;

        public CommonStreamParameters(LMAction<CONTEXT> lmAction, int majorVersion, int minorVersion) {
            super(majorVersion, minorVersion, null);
            this.lmAction = lmAction;
        }

        public void fillDialogArea(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
            label.setText("Major version:");
            Text text = new Text(parent, 2052);
            text.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
            text.setText(Integer.toString(this.majorVersion));
            text.addModifyListener(e -> {
                try {
                    this.majorVersion = Integer.parseInt(text.getText());
                    if (this.majorVersion < 0) {
                        this.majorVersion = -1;
                    }
                }
                catch (NumberFormatException ex) {
                    this.majorVersion = -1;
                }
                this.lmAction.validateDialog();
            });
            label = new Label(parent, 0);
            label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
            label.setText("Minor version:");
            text = new Text(parent, 2052);
            text.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
            text.setText(Integer.toString(this.minorVersion));
            text.addModifyListener(e -> {
                try {
                    this.minorVersion = Integer.parseInt(text.getText());
                    if (this.minorVersion < 0) {
                        this.minorVersion = -1;
                    }
                }
                catch (NumberFormatException ex) {
                    this.minorVersion = -1;
                }
                this.lmAction.validateDialog();
            });
            label = new Label(parent, 0);
            label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
            label.setText("Code name:");
            text = new Text(parent, 2052);
            text.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
            text.addModifyListener(e -> {
                this.codeName = text.getText();
                this.lmAction.validateDialog();
            });
        }

        public String validate() {
            if (this.majorVersion == -1) {
                return "A valid major version must be entered.";
            }
            if (this.minorVersion == -1) {
                return "A valid minor version must be entered.";
            }
            return null;
        }
    }
}

