/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.reviews.DeliveryReview;
import org.eclipse.emf.cdo.lm.reviews.ReviewsFactory;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.impl.ReviewStatemachine;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.cdo.lm.ui.InteractiveDeliveryMerger;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.widgets.BaselineComposite;
import org.eclipse.emf.cdo.lm.util.LMMerger2;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPage;

public class NewDeliveryReviewAction
extends LMAction.NewElement<Stream> {
    private boolean changeWasNull;
    private EList<Baseline> possibleChanges;
    private Change change;

    public NewDeliveryReviewAction(IWorkbenchPage page, StructuredViewer viewer, Stream stream, Change change) {
        super(page, viewer, (String)(change == null ? "New Delivery Review" : "New Delivery Review for " + stream.getTypeAndName()) + INTERACTIVE, "Add a new delivery review to stream '" + stream.getName() + "'", ExtendedImageRegistry.INSTANCE.getImageDescriptor(ReviewsEditPlugin.INSTANCE.getImage("full/obj16/DeliveryReview")), "Add a new delivery review to stream '" + stream.getName() + "'.", "icons/wizban/NewDelivery.png", (CDOObject)stream);
        this.change = change;
        this.changeWasNull = change == null;
    }

    protected void preRun() throws Exception {
        this.possibleChanges = new BasicEList();
        if (this.changeWasNull) {
            Stream stream = (Stream)this.getContext();
            stream.forEachBaseline(baseline -> {
                Change change;
                if (baseline instanceof Change && (change = (Change)baseline).getDeliveryPoint(stream) == null) {
                    this.possibleChanges.add((Object)change);
                }
            });
            this.possibleChanges.sort(Baseline.COMPARATOR);
        } else {
            this.possibleChanges.add((Object)this.change);
        }
        if (this.change == null && !this.possibleChanges.isEmpty()) {
            this.change = (Change)this.possibleChanges.get(0);
        }
        super.preRun();
    }

    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Change:");
        BaselineComposite changeComposite = new BaselineComposite(parent, 0, this.possibleChanges, (Object)this.getContext());
        changeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        if (this.change != null) {
            changeComposite.setBaseline((Baseline)this.change);
        }
        changeComposite.addModifyListener((control, baseline) -> {
            this.change = (Change)baseline;
            this.validateDialog();
        });
        if (!this.changeWasNull) {
            label.setEnabled(false);
            changeComposite.setEnabled(false);
        }
    }

    protected String doValidate(LMAction.LMDialog dialog) {
        if (this.change == null) {
            return "A change must be selected.";
        }
        return super.doValidate(dialog);
    }

    protected CDOObject newElement(Stream stream, IProgressMonitor monitor) throws Exception {
        ISystemDescriptor systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)stream);
        String author = systemDescriptor.getSystemRepository().getCredentials().getUserID();
        DeliveryReview review = (DeliveryReview)systemDescriptor.modify((ModelElement)stream, s -> {
            Change c = (Change)s.cdoView().getObject((EObject)this.change);
            DeliveryReview r = ReviewsFactory.eINSTANCE.createDeliveryReview();
            r.setAuthor(author);
            r.setSourceChange(c);
            s.insertContent((Baseline)r);
            Annotation annotation = ReviewsPackage.getAnnotation((ModelElement)c, (boolean)true);
            annotation.getReferences().add((Object)r);
            return r;
        }, monitor);
        NewDeliveryReviewAction.mergeFromSource(systemDescriptor, review, (FloatingBaseline)stream);
        return review;
    }

    public static ReviewStatemachine.MergeFromSourceResult mergeFromSource(ISystemDescriptor systemDescriptor, DeliveryReview review, FloatingBaseline targetBaseline) {
        ReviewStatemachine.MergeFromSourceResult result = new ReviewStatemachine.MergeFromSourceResult();
        Change sourceChange = review.getSourceChange();
        String moduleName = review.getModule().getName();
        systemDescriptor.withModuleSession(moduleName, session -> {
            CDOBranchRef sourceBranchRef = sourceChange.getBranch();
            CDOBranchRef targetBranchRef = review.getBranch();
            CDOBranchManager branchManager = session.getBranchManager();
            CDOBranch sourceBranch = sourceBranchRef.resolve(branchManager);
            CDOBranch targetBranch = targetBranchRef.resolve(branchManager);
            CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            long sourceCommit = commitInfoManager.getLastCommitOfBranch(sourceBranch, true);
            CDOBranchPoint sourceBranchPoint = sourceBranch.getPoint(sourceCommit);
            LMMerger2.LMMergeInfos infos = new LMMerger2.LMMergeInfos();
            infos.setSession(session);
            infos.setSourceBaseline((Baseline)sourceChange);
            infos.setSourceBranchPoint(sourceBranchPoint);
            infos.setTargetBaseline(targetBaseline);
            infos.setTargetBranch(targetBranch);
            InteractiveDeliveryMerger merger = new InteractiveDeliveryMerger();
            mergeFromSourceResult.targetCommit = merger.mergeDelivery(infos);
            mergeFromSourceResult.sourceCommit = sourceCommit;
        });
        return result;
    }
}

