/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.api.command;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.interaction.DTreeItemUserInteraction;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.tools.internal.Messages;

public class DTreeItemExpansionChangeCommand
extends RecordingCommand {
    private GlobalContext globalContext;
    private DTreeItem dTreeItem;
    private boolean expand;
    private IProgressMonitor monitor;

    public DTreeItemExpansionChangeCommand(GlobalContext globalContext, TransactionalEditingDomain domain, DTreeItem dTreeItem, boolean expand) {
        super(domain, MessageFormat.format(expand ? Messages.DTreeItemExpansionChangeCommand_expandItem : Messages.DTreeItemExpansionChangeCommand_collapseItem, dTreeItem.getName()));
        this.globalContext = globalContext;
        this.dTreeItem = dTreeItem;
        this.expand = expand;
        this.monitor = new NullProgressMonitor();
    }

    public DTreeItemExpansionChangeCommand(GlobalContext globalContext, TransactionalEditingDomain domain, DTreeItem dTreeItem, IProgressMonitor monitor, boolean expand) {
        super(domain, MessageFormat.format(expand ? Messages.DTreeItemExpansionChangeCommand_expandItem : Messages.DTreeItemExpansionChangeCommand_collapseItem, dTreeItem.getName()));
        this.globalContext = globalContext;
        this.dTreeItem = dTreeItem;
        this.expand = expand;
        this.monitor = monitor;
    }

    protected void doExecute() {
        if (this.expand) {
            new DTreeItemUserInteraction(this.dTreeItem, this.globalContext).expand(this.monitor);
        } else {
            new DTreeItemUserInteraction(this.dTreeItem, this.globalContext).collapse(this.monitor);
        }
    }
}

