/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.tasks;

import aQute.bnd.build.model.EE;
import aQute.bnd.osgi.resource.ResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapper;
import org.eclipse.pde.bnd.ui.tasks.CapReqLoader;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class AnalyseBundleResolutionJob
extends Job {
    private final Set<? extends CapReqLoader> loaders;
    private Map<String, List<RequirementWrapper>> requirements;
    private Map<String, List<Capability>> capabilities;
    private final EE ee;

    public AnalyseBundleResolutionJob(String name, Set<? extends CapReqLoader> loaders) {
        this(name, loaders, null);
    }

    public AnalyseBundleResolutionJob(String name, Set<? extends CapReqLoader> loaders, EE ee) {
        super(name);
        this.loaders = loaders;
        this.ee = ee;
    }

    private static <K, V> void mergeMaps(Map<K, List<V>> from, Map<K, List<V>> into) {
        for (Map.Entry<K, List<V>> entry : from.entrySet()) {
            K key = entry.getKey();
            List<V> list = into.get(key);
            if (list == null) {
                list = new ArrayList<V>();
                into.put(key, list);
            }
            list.addAll((Collection)entry.getValue());
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            HashMap<String, List<Capability>> allCaps = new HashMap<String, List<Capability>>();
            HashMap<String, List<RequirementWrapper>> allReqs = new HashMap<String, List<RequirementWrapper>>();
            for (CapReqLoader capReqLoader : this.loaders) {
                try {
                    Throwable throwable = null;
                    Object var7_13 = null;
                    try {
                        try {
                            Map<String, List<Capability>> caps = capReqLoader.loadCapabilities();
                            AnalyseBundleResolutionJob.mergeMaps(caps, allCaps);
                            Map<String, List<RequirementWrapper>> reqs = capReqLoader.loadRequirements();
                            AnalyseBundleResolutionJob.mergeMaps(reqs, allReqs);
                        }
                        finally {
                            if (capReqLoader != null) {
                                capReqLoader.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    ILog.get().error("Error in Bnd resolution analysis.", (Throwable)e);
                }
            }
            for (String string : allReqs.keySet()) {
                List rws = allReqs.getOrDefault(string, Collections.emptyList());
                List candidates = allCaps.getOrDefault(string, Collections.emptyList());
                List javaCandidates = this.ee == null ? Collections.emptyList() : this.ee.getResource().getCapabilities(string);
                block12: for (RequirementWrapper rw : rws) {
                    String filterDirective = (String)rw.requirement.getDirectives().get("filter");
                    if (filterDirective == null) continue;
                    Predicate predicate = ResourceUtils.filterMatcher((Requirement)rw.requirement);
                    for (Capability cand : candidates) {
                        if (!predicate.test(cand)) continue;
                        rw.resolved = true;
                        continue block12;
                    }
                    for (Capability cand : javaCandidates) {
                        if (!predicate.test(cand)) continue;
                        rw.java = true;
                        continue block12;
                    }
                }
            }
            this.requirements = allReqs;
            this.capabilities = allCaps;
            return Status.OK_STATUS;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<RequirementWrapper>> getRequirements() {
        return Collections.unmodifiableMap(this.requirements);
    }

    public Map<String, List<Capability>> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }
}

