/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusStyleClipboard;
import org.eclipse.sirius.viewpoint.DStylizable;

public final class CopyStyleCommand
extends Command {
    List<?> selectionsRaw;

    public CopyStyleCommand(List<?> selectionsRaw) {
        super(Messages.CopyFormatDataCommand_label);
        this.selectionsRaw = selectionsRaw;
    }

    public boolean canUndo() {
        return false;
    }

    Optional<IGraphicalEditPart> getLastSelectedPart() {
        return this.selectionsRaw.stream().filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).reduce((first, second) -> second);
    }

    private EditPart getTargetEditPart(EditPart selection) {
        if (selection instanceof LabelEditPart) {
            LabelEditPart editPart = (LabelEditPart)selection;
            return editPart.getParent();
        }
        return selection;
    }

    public void execute() {
        this.getLastSelectedPart().ifPresent(selection -> {
            EditPart editPart = this.getTargetEditPart((EditPart)selection);
            if (editPart instanceof IGraphicalEditPart) {
                IGraphicalEditPart sourceGraphicalEditPart = (IGraphicalEditPart)editPart;
                EObject diagramElementRaw = sourceGraphicalEditPart.resolveSemanticElement();
                Object gmfViewRaw = sourceGraphicalEditPart.getModel();
                if (diagramElementRaw instanceof DStylizable) {
                    DStylizable diagramElement = (DStylizable)diagramElementRaw;
                    if (gmfViewRaw instanceof View) {
                        View gmfView = (View)gmfViewRaw;
                        SiriusStyleClipboard.getInstance().store(gmfView, diagramElement.getStyle());
                    }
                }
            }
        });
    }
}

