/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.codemining;

import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ColoredRectangleLineContentCodeMining
extends LineContentCodeMining {
    private final Color color;

    public ColoredRectangleLineContentCodeMining(Position position, ICodeMiningProvider provider, Color color) {
        super(position, provider);
        this.color = color;
    }

    public Point draw(GC gc, StyledText textWidget, Color color, int x, int y) {
        int fontHeight = gc.getFontMetrics().getHeight();
        int rectangleHeight = (int)((double)fontHeight * 0.75);
        int offset = (fontHeight - rectangleHeight) / 2;
        gc.setAntialias(1);
        gc.setForeground(this.color);
        gc.setBackground(this.color);
        gc.fillRectangle(x + offset, y + offset, rectangleHeight, rectangleHeight);
        gc.setForeground(Display.getDefault().getSystemColor(2));
        gc.drawRectangle(x + offset, y + offset, rectangleHeight, rectangleHeight);
        Point codeMiningSize = new Point(rectangleHeight + 5, rectangleHeight);
        return codeMiningSize;
    }

    public String getLabel() {
        return " ";
    }
}

