/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.codemining;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorInfo;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.language.codemining.ColoredRectangleLineContentCodeMining;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codemining.AbstractXtextCodeMiningProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;

public class DotCodeMiningProvider
extends AbstractXtextCodeMiningProvider {
    protected void createCodeMinings(IDocument document, XtextResource resource, CancelIndicator indicator, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            return;
        }
        EObject dotAst = (EObject)contents.get(0);
        this.createDotGraphCodeMinings(document, dotAst, acceptor);
        this.createDotColorAttributesCodeMining(document, dotAst, acceptor);
    }

    private void createDotGraphCodeMinings(IDocument document, EObject dotAst, IAcceptor<? super ICodeMining> acceptor) throws BadLocationException {
        List dotGraphs = EcoreUtil2.eAllOfType((EObject)dotAst, DotGraph.class);
        for (DotGraph dotGraph : dotGraphs) {
            int nodesCount = DotAstHelper.getNumberOfNodes((DotGraph)dotGraph);
            String nodesCountHeaderText = String.valueOf(nodesCount) + " node" + (nodesCount == 1 ? "" : "s");
            int edgesCount = DotAstHelper.getNumberOfEdges((DotGraph)dotGraph);
            String edgesCountHeaderText = String.valueOf(edgesCount) + " edge" + (edgesCount == 1 ? "" : "s");
            ICompositeNode node = NodeModelUtils.getNode((EObject)dotGraph);
            int beforeLineNumber = document.getLineOfOffset(node.getOffset());
            acceptor.accept((Object)this.createNewLineHeaderCodeMining(beforeLineNumber, document, nodesCountHeaderText));
            acceptor.accept((Object)this.createNewLineHeaderCodeMining(beforeLineNumber, document, edgesCountHeaderText));
        }
    }

    private void createDotColorAttributesCodeMining(IDocument document, EObject dotAst, IAcceptor<? super ICodeMining> acceptor) {
        List attributes = EcoreUtil2.eAllOfType((EObject)dotAst, Attribute.class);
        for (Attribute attribute : attributes) {
            String attributeName;
            DotAttributes.Context attributeContext;
            block59: {
                block57: {
                    block55: {
                        attributeContext = DotAttributes.getContext((EObject)attribute);
                        attributeName = attribute.getName().toValue();
                        if (attributeContext != DotAttributes.Context.EDGE) break block55;
                        switch (attributeName) {
                            case "color": {
                                this.createColorListCodeMinings(attribute, acceptor);
                                break;
                            }
                            case "fillcolor": {
                                this.createColorCodeMining(attribute, acceptor);
                                break;
                            }
                            case "fontcolor": 
                            case "labelfontcolor": {
                                this.createColorCodeMining(attribute, acceptor);
                            }
                        }
                        continue;
                    }
                    if (attributeContext != DotAttributes.Context.GRAPH) break block57;
                    switch (attributeName) {
                        case "bgcolor": {
                            this.createColorListCodeMinings(attribute, acceptor);
                            break;
                        }
                        case "fontcolor": {
                            this.createColorCodeMining(attribute, acceptor);
                        }
                    }
                    continue;
                }
                if (attributeContext != DotAttributes.Context.NODE) break block59;
                switch (attributeName) {
                    case "color": {
                        this.createColorCodeMining(attribute, acceptor);
                        break;
                    }
                    case "fillcolor": {
                        this.createColorListCodeMinings(attribute, acceptor);
                        break;
                    }
                    case "fontcolor": {
                        this.createColorCodeMining(attribute, acceptor);
                    }
                }
                continue;
            }
            if (attributeContext != DotAttributes.Context.CLUSTER) continue;
            switch (attributeName) {
                case "bgcolor": {
                    this.createColorListCodeMinings(attribute, acceptor);
                    break;
                }
                case "color": {
                    this.createColorCodeMining(attribute, acceptor);
                    break;
                }
                case "fillcolor": {
                    this.createColorListCodeMinings(attribute, acceptor);
                    break;
                }
                case "fontcolor": {
                    this.createColorCodeMining(attribute, acceptor);
                }
            }
        }
    }

    private void createColorListCodeMinings(Attribute attribute, IAcceptor<? super ICodeMining> acceptor) {
        int annotationOffset = this.getAnnotationOffset(attribute);
        List<Color> annotationColors = this.getColors(attribute);
        for (Color annotationColor : annotationColors) {
            acceptor.accept((Object)this.createNewColoredRectangleLineContentCodeMining(annotationOffset, annotationColor));
        }
    }

    private void createColorCodeMining(Attribute attribute, IAcceptor<? super ICodeMining> acceptor) {
        int annotationOffset = this.getAnnotationOffset(attribute);
        Color annotationColor = this.getColor(attribute);
        if (annotationColor != null) {
            acceptor.accept((Object)this.createNewColoredRectangleLineContentCodeMining(annotationOffset, annotationColor));
        }
    }

    private ICodeMining createNewColoredRectangleLineContentCodeMining(int beforeCharacter, Color color) {
        return new ColoredRectangleLineContentCodeMining(new Position(beforeCharacter, 1), (ICodeMiningProvider)this, color);
    }

    private int getAnnotationOffset(Attribute attribute) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        return node.getEndOffset();
    }

    private Color getColor(Attribute attribute) {
        DotColorUtil colorUtil = new DotColorUtil();
        if (attribute.getValue() == null) {
            return null;
        }
        DotColorInfo colorInfo = colorUtil.getColorInfo(attribute);
        String hexColorCode = colorInfo.getColorCode();
        Color swtColor = null;
        try {
            swtColor = colorUtil.hex2Rgb(hexColorCode);
        }
        catch (Exception e) {
            return null;
        }
        return swtColor;
    }

    private List<Color> getColors(Attribute attribute) {
        DotColorUtil colorUtil = new DotColorUtil();
        List<DotColorInfo> colorInfos = colorUtil.getColorInfos(attribute);
        ArrayList<Color> swtColors = new ArrayList<Color>();
        for (DotColorInfo colorInfo : colorInfos) {
            String hexColorCode = colorInfo.getColorCode();
            Color swtColor = null;
            try {
                swtColor = colorUtil.hex2Rgb(hexColorCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (swtColor == null) continue;
            swtColors.add(swtColor);
        }
        return swtColors;
    }
}

