/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.properties.ui.api.AbstractEEFTabbedPropertySheetPageContributorWrapper;
import org.eclipse.eef.properties.ui.api.EEFTabContents;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabSelectionListener;
import org.eclipse.eef.properties.ui.api.IEEFTabbedPropertySheetPageContributor;
import org.eclipse.eef.properties.ui.internal.EEFTabbedPropertyViewPlugin;
import org.eclipse.eef.properties.ui.internal.page.EEFMessagePrefixProvider;
import org.eclipse.eef.properties.ui.internal.page.EEFPartListenerAdapter;
import org.eclipse.eef.properties.ui.internal.page.EEFTabbedPropertyComposite;
import org.eclipse.eef.properties.ui.internal.page.EEFTabbedPropertyViewer;
import org.eclipse.eef.properties.ui.internal.registry.EEFTabbedPropertyRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class EEFTabbedPropertySheetPage
extends Page
implements IPropertySheetPage,
IEEFFormContainer {
    private EEFWidgetFactory widgetFactory;
    private EEFTabbedPropertyComposite tabbedPropertyComposite;
    private EEFTabbedPropertyViewer tabbedPropertyViewer;
    private IEEFTabbedPropertySheetPageContributor contributor;
    private EEFTabContents currentTab;
    private Map<IEEFTabDescriptor, EEFTabContents> descriptorToTab = new HashMap<IEEFTabDescriptor, EEFTabContents>();
    private Map<EEFTabContents, Composite> tabToComposite = new HashMap<EEFTabContents, Composite>();
    private List<String> selectionQueue = new ArrayList<String>();
    private boolean selectionQueueLocked;
    private List<IEEFTabSelectionListener> tabSelectionListeners = new ArrayList<IEEFTabSelectionListener>();
    private IWorkbenchWindow cachedWorkbenchWindow;
    private IPartListener partActivationListener;
    private boolean activePropertySheet;
    private IWorkbenchPart currentPart;
    private ISelection currentSelection;
    private Form form;
    private AtomicBoolean isRenderingInProgress = new AtomicBoolean(false);
    private ControlAdapter scrolledCompositeListener;
    private EEFTabbedPropertyViewer.IEEFTabDescriptorChangedListener viewerSelectionListener;

    public EEFTabbedPropertySheetPage(IEEFTabbedPropertySheetPageContributor contributor) {
        this.contributor = contributor;
    }

    public void createControl(Composite parent) {
        this.widgetFactory = new EEFWidgetFactory();
        this.form = this.widgetFactory.createForm(parent);
        this.form.setText("");
        this.widgetFactory.decorateFormHeading(this.form);
        this.form.getMessageManager().setMessagePrefixProvider((IMessagePrefixProvider)new EEFMessagePrefixProvider());
        this.form.getMessageManager().setDecorationPosition(16512);
        this.form.getMessageManager().setAutoUpdate(false);
        this.form.getBody().setLayout((Layout)new FormLayout());
        this.tabbedPropertyComposite = new EEFTabbedPropertyComposite(this.form.getBody(), this.widgetFactory);
        this.widgetFactory.paintBordersFor((Composite)this.tabbedPropertyComposite);
        this.tabbedPropertyComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.tabbedPropertyComposite.setLayoutData(formData);
        this.form.setLayoutData((Object)formData);
        this.widgetFactory.paintBordersFor((Composite)this.form);
        this.tabbedPropertyViewer = new EEFTabbedPropertyViewer(this.tabbedPropertyComposite.getTabbedPropertyList());
        this.viewerSelectionListener = new EEFTabbedPropertyViewer.IEEFTabDescriptorChangedListener(){

            @Override
            public void selectionChanged(IEEFTabDescriptor descriptor) {
                EEFTabbedPropertySheetPage.this.processSelectionChanged(descriptor);
            }
        };
        this.tabbedPropertyViewer.addSelectionListener(this.viewerSelectionListener);
        this.scrolledCompositeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                EEFTabbedPropertySheetPage.this.resizeScrolledComposite();
            }
        };
        this.tabbedPropertyComposite.getScrolledComposite().addControlListener((ControlListener)this.scrolledCompositeListener);
        this.partActivationListener = new EEFPartListenerAdapter(){

            @Override
            public void partOpened(IWorkbenchPart part) {
                EEFTabbedPropertySheetPage.this.handlePartActivated(part);
            }
        };
        this.cachedWorkbenchWindow = this.getSite().getWorkbenchWindow();
        this.cachedWorkbenchWindow.getPartService().addPartListener(this.partActivationListener);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        EEFTabbedPropertyViewPlugin.getPlugin().debug("EEFTabbedPropertySheetPage#selectionChanged(...)");
        this.setInput(part, selection);
    }

    private void setInput(IWorkbenchPart part, ISelection selection) {
        EEFTabbedPropertyViewPlugin.getPlugin().debug("EEFTabbedPropertySheetPage#setInput()");
        if (selection == null || selection.equals(this.currentSelection)) {
            return;
        }
        this.doSetInput(part, selection);
    }

    public void refreshPage() {
        Display display = this.getSite().getShell().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EEFTabbedPropertySheetPage.this.doSetInput(EEFTabbedPropertySheetPage.this.currentPart, EEFTabbedPropertySheetPage.this.currentSelection);
                }
            });
        }
    }

    public boolean isRenderingInProgress() {
        return this.isRenderingInProgress.get();
    }

    private synchronized void doSetInput(IWorkbenchPart part, ISelection selection) {
        if (this.tabbedPropertyComposite.isDisposed()) {
            return;
        }
        this.isRenderingInProgress.set(true);
        this.tabbedPropertyComposite.setRedraw(false);
        try {
            this.currentPart = part;
            this.currentSelection = selection;
            this.contributor.updateFormTitle(this.form, this.currentSelection);
            List<IEEFTabDescriptor> descriptors = EEFTabbedPropertyRegistry.getDefault(this.contributor).getTabDescriptors(part, selection);
            this.updateTabs(descriptors);
            this.tabbedPropertyViewer.setInput(descriptors);
            int lastTabSelectionIndex = this.getLastTabSelection(descriptors);
            IEEFTabDescriptor selectedTab = this.tabbedPropertyViewer.getTabDescriptionAtIndex(lastTabSelectionIndex);
            this.selectionQueueLocked = true;
            try {
                if (selectedTab == null) {
                    this.tabbedPropertyViewer.setSelectedTabDescriptor(null);
                } else {
                    this.tabbedPropertyViewer.setSelectedTabDescriptor(selectedTab);
                }
            }
            finally {
                this.selectionQueueLocked = false;
            }
        }
        finally {
            this.tabbedPropertyComposite.setRedraw(true);
            this.isRenderingInProgress.set(false);
        }
    }

    protected void updateTabs(List<IEEFTabDescriptor> descriptors) {
        HashMap<IEEFTabDescriptor, EEFTabContents> newTabs = new HashMap<IEEFTabDescriptor, EEFTabContents>(descriptors.size() * 2);
        boolean disposingCurrentTab = this.currentTab != null;
        for (IEEFTabDescriptor descriptor : descriptors) {
            EEFTabContents tab = this.descriptorToTab.remove(descriptor);
            if (tab != null && tab.controlsHaveBeenCreated()) {
                if (tab == this.currentTab) {
                    disposingCurrentTab = false;
                }
            } else {
                tab = descriptor.createTab();
            }
            newTabs.put(descriptor, tab);
        }
        if (disposingCurrentTab) {
            this.currentTab.aboutToBeHidden();
            this.currentTab = null;
        }
        this.disposeTabs(this.descriptorToTab.values());
        this.descriptorToTab = newTabs;
    }

    private int getLastTabSelection(List<IEEFTabDescriptor> descriptors) {
        if (descriptors.size() != 0) {
            for (String text : this.selectionQueue) {
                int i = 0;
                for (IEEFTabDescriptor descriptor : descriptors) {
                    if (text.equals(descriptor.getLabel())) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return 0;
    }

    protected void disposeTabs(Collection<EEFTabContents> tabs) {
        for (EEFTabContents tab : tabs) {
            Composite composite = this.tabToComposite.remove(tab);
            tab.dispose();
            if (composite == null) continue;
            composite.dispose();
        }
    }

    private void handlePartActivated(IWorkbenchPart part) {
        EEFTabbedPropertyViewPlugin.getPlugin().debug("EEFTabbedPropertySheetPage#partActivated(...)");
        boolean thisActivated = part instanceof PropertySheet && ((PropertySheet)part).getCurrentPage() == this;
        IContributedContentsView view = null;
        if (!(thisActivated || this.matchesContributor(part) || this.contributor.getContributorIds().contains(part.getSite().getId()))) {
            Object object = part.getAdapter(IContributedContentsView.class);
            view = (IContributedContentsView)object;
        }
        if (view == null || view.getContributingPart() != null && !view.getContributingPart().equals(this.contributor)) {
            if (this.activePropertySheet) {
                if (this.currentTab != null) {
                    this.currentTab.aboutToBeHidden();
                }
                this.activePropertySheet = false;
            }
            return;
        }
        if (!this.activePropertySheet && this.currentTab != null) {
            this.currentTab.aboutToBeShown();
            this.currentTab.refresh();
        }
        this.activePropertySheet = true;
    }

    private boolean matchesContributor(IWorkbenchPart part) {
        if (this.contributor instanceof AbstractEEFTabbedPropertySheetPageContributorWrapper) {
            AbstractEEFTabbedPropertySheetPageContributorWrapper wrapper = (AbstractEEFTabbedPropertySheetPageContributorWrapper)this.contributor;
            return part.equals(wrapper.getRealContributor());
        }
        return part.equals(this.contributor);
    }

    private synchronized void processSelectionChanged(IEEFTabDescriptor descriptor) {
        this.isRenderingInProgress.set(true);
        try {
            EEFTabContents tab = null;
            if (descriptor == null) {
                EEFTabbedPropertyViewPlugin.getPlugin().debug("EEFTabbedPropertySheetPage -- Hide tab");
                this.hideTab(this.currentTab);
            } else {
                tab = this.descriptorToTab.get(descriptor);
                if (tab == null) {
                    for (Map.Entry<IEEFTabDescriptor, EEFTabContents> entry : this.descriptorToTab.entrySet()) {
                        if (entry.getKey() != descriptor) continue;
                        tab = entry.getValue();
                        break;
                    }
                }
                if (tab != null) {
                    Composite tabComposite;
                    if (tab != this.currentTab) {
                        this.hideTab(this.currentTab);
                    }
                    if ((tabComposite = this.tabToComposite.get(tab)) == null) {
                        tabComposite = this.createTabComposite();
                        tab.createControls(tabComposite, this);
                        this.tabToComposite.put(tab, tabComposite);
                    }
                    tab.setInput(this.currentPart, this.currentSelection);
                    this.storeCurrentTabSelection(descriptor.getLabel());
                    if (tab != this.currentTab) {
                        this.showTab(tab);
                    }
                    tab.refresh();
                }
            }
            this.tabbedPropertyComposite.getTabComposite().layout(true);
            this.currentTab = tab;
            this.resizeScrolledComposite();
            if (descriptor != null) {
                this.handleTabSelection(descriptor);
            }
        }
        finally {
            this.isRenderingInProgress.set(false);
        }
    }

    private void showTab(EEFTabContents tab) {
        Composite tabComposite;
        if (tab != null && (tabComposite = this.tabToComposite.get(tab)) != null) {
            tabComposite.moveAbove(null);
            tab.aboutToBeShown();
            tabComposite.setVisible(true);
        }
    }

    private void hideTab(EEFTabContents tab) {
        Composite tabComposite;
        if (tab != null && (tabComposite = this.tabToComposite.get(tab)) != null) {
            tab.aboutToBeHidden();
            tabComposite.setVisible(false);
        }
    }

    private Composite createTabComposite() {
        Composite result = this.widgetFactory.createComposite(this.tabbedPropertyComposite.getTabComposite(), 524288);
        result.setVisible(false);
        result.setLayout((Layout)new FillLayout());
        result.setBackground(this.widgetFactory.getColors().getBackground());
        result.setForeground(this.widgetFactory.getColors().getForeground());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        result.setLayoutData((Object)data);
        return result;
    }

    private void storeCurrentTabSelection(String label) {
        if (!this.selectionQueueLocked) {
            this.selectionQueue.remove(label);
            this.selectionQueue.add(0, label);
        }
    }

    private void handleTabSelection(IEEFTabDescriptor descriptor) {
        if (this.selectionQueueLocked) {
            return;
        }
        for (IEEFTabSelectionListener listener : this.tabSelectionListeners) {
            listener.tabSelected(descriptor);
        }
    }

    public void addTabSelectionListener(IEEFTabSelectionListener listener) {
        this.tabSelectionListeners.add(listener);
    }

    public void removeTabSelectionListener(IEEFTabSelectionListener listener) {
        this.tabSelectionListeners.remove(listener);
    }

    public void resizeScrolledComposite() {
        ScrollBar horizontalScrollBar;
        Composite sizeReference;
        Point currentTabSize = new Point(0, 0);
        if (this.currentTab != null && (sizeReference = this.tabToComposite.get(this.currentTab)) != null) {
            currentTabSize = sizeReference.computeSize(-1, -1);
        }
        this.tabbedPropertyComposite.getScrolledComposite().setMinSize(currentTabSize);
        ScrollBar verticalScrollBar = this.tabbedPropertyComposite.getScrolledComposite().getVerticalBar();
        if (verticalScrollBar != null) {
            Rectangle clientArea = this.tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.height - 5;
            verticalScrollBar.setPageIncrement(increment);
        }
        if ((horizontalScrollBar = this.tabbedPropertyComposite.getScrolledComposite().getHorizontalBar()) != null) {
            Rectangle clientArea = this.tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.width - 5;
            horizontalScrollBar.setPageIncrement(increment);
        }
    }

    public void setSelectedTab(String id) {
        List<IEEFTabDescriptor> elements = this.tabbedPropertyViewer.getElements();
        for (IEEFTabDescriptor descriptor : elements) {
            if (descriptor.getId() == null || !descriptor.getId().equals(id)) continue;
            this.tabbedPropertyViewer.setSelectedTabDescriptor(descriptor);
        }
    }

    public void dispose() {
        this.disposeContributor();
        this.widgetFactory.dispose();
        this.cachedWorkbenchWindow.getPartService().removePartListener(this.partActivationListener);
    }

    private void disposeContributor() {
        if (this.currentTab != null) {
            this.currentTab.aboutToBeHidden();
        }
        Collection<EEFTabContents> tabs = this.descriptorToTab.values();
        for (EEFTabContents tab : tabs) {
            Composite composite = this.tabToComposite.remove(tab);
            tab.dispose();
            if (composite == null) continue;
            composite.dispose();
        }
        this.descriptorToTab = new HashMap<IEEFTabDescriptor, EEFTabContents>();
    }

    public List<IEEFTabDescriptor> getActiveTabs() {
        return this.tabbedPropertyViewer.getElements();
    }

    public Control getControl() {
        return this.form;
    }

    public EEFTabContents getCurrentTab() {
        return this.currentTab;
    }

    public IEEFTabDescriptor getSelectedTab() {
        int selectedTab = this.tabbedPropertyViewer.getSelectionIndex();
        if (selectedTab != -1) {
            return this.tabbedPropertyViewer.getTabDescriptionAtIndex(selectedTab);
        }
        return null;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public EEFWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void refresh() {
        this.currentTab.refresh();
    }

    public IEEFTabbedPropertySheetPageContributor getContributor() {
        return this.contributor;
    }

    public Form getForm() {
        return this.form;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }
}

