/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.provider.LMEditPlugin;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.widgets.TimeStampComposite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class NewDropAction
extends LMAction.NewElement<Stream> {
    private static final long INVALID_DATE = -1L;
    private final DropType dropType;
    private ISystemDescriptor systemDescriptor;
    private long startTimeStamp;
    private long timeStamp;
    private String timeStampError;
    private Text versionText;
    private Job versionExtractionJob;
    private AtomicLong versionExtractionTimeStamp = new AtomicLong(-1L);
    private String labelString;
    private Text labelText;

    public NewDropAction(IWorkbenchPage page, StructuredViewer viewer, Stream stream, DropType dropType) {
        super(page, viewer, "New " + dropType.getName() + INTERACTIVE, "Add a new " + dropType.getName().toLowerCase() + " to stream '" + stream.getName() + "'", ExtendedImageRegistry.INSTANCE.getImageDescriptor(LMEditPlugin.INSTANCE.getImage(dropType.isRelease() ? "full/obj16/Release" : "full/obj16/Drop")), "Add a new " + dropType.getName().toLowerCase() + " to stream '" + stream.getName() + "'.", dropType.isRelease() ? "icons/wizban/NewRelease.png" : "icons/wizban/NewDrop.png", stream);
        this.dropType = dropType;
    }

    @Override
    protected void preRun() throws Exception {
        Drop lastRelease;
        Stream stream = (Stream)this.getContext();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)stream.getSystem());
        this.startTimeStamp = stream.getStartTimeStamp();
        if (this.dropType.isRelease() && (lastRelease = stream.getLastRelease()) != null) {
            this.startTimeStamp = lastRelease.getBranchPoint().getTimeStamp() + 1L;
        }
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Stream stream = (Stream)this.getContext();
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Time stamp:");
        TimeStampComposite timeStampComposite = new TimeStampComposite(parent, 0, this.startTimeStamp, 0L, stream);
        timeStampComposite.setLayoutData(GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        timeStampComposite.addModifyListener((control, timeStamp, error) -> {
            this.timeStamp = timeStamp;
            this.timeStampError = error;
            this.validateDialog();
            this.scheduleVersionExtraction((FloatingBaseline)stream);
        });
        timeStampComposite.setTimeStamp(System.currentTimeMillis());
        label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Version:");
        this.versionText = new Text(parent, 2056);
        this.versionText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        label.setText("Label:");
        this.labelText = new Text(parent, 2052);
        this.labelText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        this.labelText.addModifyListener(e -> {
            this.labelString = this.labelText.getText();
            this.validateDialog();
        });
        this.labelText.setFocus();
        this.labelText.selectAll();
    }

    @Override
    protected String doValidate(LMAction.LMDialog dialog) {
        if (this.timeStamp == -1L) {
            return this.timeStampError == null ? "A time stamp must be entered" : this.timeStampError;
        }
        if (this.labelString == null || this.labelString.isEmpty()) {
            return "A label must be entered.";
        }
        return super.doValidate(dialog);
    }

    @Override
    protected CDOObject newElement(Stream stream, IProgressMonitor monitor) throws Exception {
        return this.systemDescriptor.createDrop(stream, this.dropType, this.timeStamp, this.labelString, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleVersionExtraction(final FloatingBaseline baseline) {
        AtomicLong atomicLong = this.versionExtractionTimeStamp;
        synchronized (atomicLong) {
            this.versionExtractionTimeStamp.set(this.timeStamp);
            if (this.timeStamp == -1L) {
                if (this.versionExtractionJob != null) {
                    this.versionExtractionJob.cancel();
                    this.versionExtractionJob = null;
                }
                this.setVersionString("", false);
            } else if (this.versionExtractionJob == null) {
                this.versionExtractionJob = new Job("Extract Version"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        while (!monitor.isCanceled()) {
                            long timeStampToUse;
                            AtomicLong atomicLong = NewDropAction.this.versionExtractionTimeStamp;
                            synchronized (atomicLong) {
                                timeStampToUse = NewDropAction.this.versionExtractionTimeStamp.getAndSet(-1L);
                            }
                            if (timeStampToUse == -1L) break;
                            this.extractVersion(timeStampToUse);
                        }
                        return Status.OK_STATUS;
                    }

                    private void extractVersion(long timeStamp) {
                        ModuleDefinition moduleDefinition = NewDropAction.this.systemDescriptor.extractModuleDefinition(baseline, timeStamp);
                        Version moduleVersion = moduleDefinition.getVersion();
                        int major = (Integer)moduleVersion.getSegment(0);
                        int minor = (Integer)moduleVersion.getSegment(1);
                        int micro = (Integer)moduleVersion.getSegment(2);
                        NewDropAction.this.setVersionString(major + "." + minor + "." + micro, true);
                    }
                };
                this.versionExtractionJob.schedule();
            }
        }
    }

    private void setVersionString(String versionString, boolean fromJob) {
        UIUtil.asyncExec((Display)this.getDisplay(), () -> {
            if (!this.versionText.isDisposed()) {
                if (fromJob) {
                    AtomicLong atomicLong = this.versionExtractionTimeStamp;
                    synchronized (atomicLong) {
                        if (this.versionExtractionJob == null) {
                            return;
                        }
                    }
                }
                this.versionText.setText(versionString);
                this.labelText.setText(versionString);
                this.labelText.selectAll();
            }
        });
    }
}

