/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.ui;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationModel;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class NotificationsPlugin
extends AbstractUIPlugin {
    private static final String FILE_NOTIFICATION_STATE = "notifications.xml";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.commons.notifications.ui";
    public static final String PREF_NOTICATIONS_ENABLED = "notifications.enabled";
    private static NotificationsPlugin instance;
    private NotificationModel model;
    private NotificationService service;

    public static NotificationsPlugin getDefault() {
        return instance;
    }

    public NotificationModel createModelWorkingCopy() {
        this.migrateFile_0_8();
        XMLMemento memento = null;
        File file = this.getModelFile().toFile();
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    try {
                        memento = XMLMemento.createReadRoot((Reader)reader);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | WorkbenchException e) {
                this.getLog().log((IStatus)new Status(4, ID_PLUGIN, "Unexpected error restoring notification state", e));
            }
        }
        return new NotificationModel((IMemento)memento);
    }

    private void migrateFile_0_8() {
        IPath file_0_8 = this.getModelFile_0_8();
        if (file_0_8.toFile().exists() && !this.getModelFile().toFile().exists()) {
            file_0_8.toFile().renameTo(this.getModelFile().toFile());
        }
    }

    public NotificationModel getModel() {
        if (this.model == null) {
            this.model = this.createModelWorkingCopy();
        }
        return this.model;
    }

    public NotificationService getService() {
        if (this.service == null) {
            this.service = new NotificationService();
        }
        return this.service;
    }

    public void saveModel() {
        if (this.model != null && this.model.isDirty()) {
            this.save(this.model);
        }
    }

    public void saveWorkingCopy(NotificationModel workingCopy) {
        XMLMemento memento = this.save(workingCopy);
        if (this.model != null) {
            this.model.initialize((IMemento)memento);
        }
    }

    public void start(BundleContext context) throws Exception {
        instance = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        instance = null;
    }

    private XMLMemento save(NotificationModel model) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"notifications");
        model.save((IMemento)memento);
        try (FileWriter writer = new FileWriter(this.getModelFile().toFile());){
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            this.getLog().log((IStatus)new Status(4, ID_PLUGIN, "Unexpected error saving notification state", (Throwable)e));
        }
        return memento;
    }

    protected IPath getModelFile() {
        IPath stateLocation = Platform.getStateLocation((Bundle)this.getBundle());
        IPath cacheFile = stateLocation.append(FILE_NOTIFICATION_STATE);
        return cacheFile;
    }

    protected IPath getModelFile_0_8() {
        IPath stateLocation = Platform.getStateLocation((Bundle)this.getBundle());
        stateLocation = stateLocation.removeLastSegments(1).append("org.eclipse.mylyn.commons.notifications");
        return stateLocation.append(FILE_NOTIFICATION_STATE);
    }
}

