/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionLabelProvider;
import org.eclipse.tm4e.ui.internal.widgets.ThemeLabelProvider;
import org.eclipse.tm4e.ui.internal.wizards.AbstractWizardPage;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;

final class CreateThemeAssociationWizardPage
extends AbstractWizardPage {
    private static final String PAGE_NAME = CreateThemeAssociationWizardPage.class.getName();
    private ComboViewer themeViewer = (ComboViewer)NullSafetyHelper.lateNonNull();
    private ComboViewer grammarsCombo = (ComboViewer)NullSafetyHelper.lateNonNull();
    private final @Nullable IGrammarDefinition initialDefinition;
    private final @Nullable IThemeAssociation initialAssociation;
    private Button whenDarkButton = (Button)NullSafetyHelper.lateNonNull();

    protected CreateThemeAssociationWizardPage(@Nullable IGrammarDefinition initialDefinition, @Nullable IThemeAssociation initialAssociation) {
        super(PAGE_NAME);
        super.setTitle(TMUIMessages.CreateThemeAssociationWizardPage_title);
        super.setDescription(TMUIMessages.CreateThemeAssociationWizardPage_description);
        this.initialDefinition = initialDefinition;
        this.initialAssociation = initialAssociation;
    }

    @Override
    protected void createBody(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setFont(parent.getFont());
        parent.setLayoutData((Object)new GridData(768));
        parent.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(parent, 0);
        label.setText(TMUIMessages.CreateThemeAssociationWizardPage_theme_text);
        this.themeViewer = new ComboViewer(parent);
        this.themeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.themeViewer.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        this.themeViewer.setInput((Object)TMUIPlugin.getThemeManager().getThemes());
        this.themeViewer.getControl().setLayoutData((Object)new GridData(768));
        this.themeViewer.getControl().addListener(13, (Listener)this);
        label = new Label(parent, 0);
        label.setText(TMUIMessages.CreateThemeAssociationWizardPage_grammar_text);
        this.grammarsCombo = new ComboViewer(parent);
        this.grammarsCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.grammarsCombo.setLabelProvider((IBaseLabelProvider)new GrammarDefinitionLabelProvider());
        this.grammarsCombo.setInput((Object)TMEclipseRegistryPlugin.getGrammarRegistryManager().getDefinitions());
        this.grammarsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.grammarsCombo.getControl().addListener(13, (Listener)this);
        if (this.initialDefinition != null) {
            this.grammarsCombo.setSelection((ISelection)new StructuredSelection((Object)this.initialDefinition));
        }
        this.whenDarkButton = new Button(parent, 32);
        this.whenDarkButton.setText(TMUIMessages.CreateThemeAssociationWizardPage_whenDark_text);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        this.whenDarkButton.setLayoutData((Object)data);
        IThemeAssociation initialAssociation = this.initialAssociation;
        if (initialAssociation != null) {
            ITheme selectedTheme = TMUIPlugin.getThemeManager().getThemeById(initialAssociation.getThemeId());
            if (selectedTheme != null) {
                this.themeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedTheme));
            }
            this.whenDarkButton.setSelection(initialAssociation.isWhenDark());
        }
    }

    @Override
    protected void initializeDefaultValues() {
        this.setPageComplete(false);
    }

    @Override
    protected @Nullable IStatus validatePage(Event event) {
        if (this.themeViewer.getSelection().isEmpty()) {
            return new Status(4, "org.eclipse.tm4e.ui", TMUIMessages.CreateThemeAssociationWizardPage_theme_error_required);
        }
        if (this.grammarsCombo.getSelection().isEmpty()) {
            return new Status(4, "org.eclipse.tm4e.ui", TMUIMessages.CreateThemeAssociationWizardPage_grammar_error_required);
        }
        return null;
    }

    IThemeAssociation getThemeAssociation() {
        String themeId = ((ITheme)NullSafetyHelper.castNonNull((Object)this.themeViewer.getStructuredSelection().getFirstElement())).getId();
        IGrammarDefinition grammar = (IGrammarDefinition)NullSafetyHelper.castNonNull((Object)this.grammarsCombo.getStructuredSelection().getFirstElement());
        String scopeName = grammar.getScope().getName();
        boolean whenDark = this.whenDarkButton.getSelection();
        return new ThemeAssociation(themeId, scopeName, whenDark);
    }
}

