/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.handlers.CommonSyncExceptionHandler;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.SyncMainWizardPage;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.SyncWizardDataCache;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.handlers.ISyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeWizardExtension;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewSyncProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    public static final String WIZARD_ID = "org.eclipse.ui.wizards.new.project";
    private SyncMainWizardPage mainPage;
    private WizardNewProjectReferencePage referencePage;
    private WizardMode wizardMode = null;
    private IProject newProject;
    private IConfigurationElement configElement;
    private static String WINDOW_PROBLEMS_TITLE = Messages.NewProject_errorOpeningWindow;
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";

    public NewSyncProjectWizard() {
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewSyncProjectWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewSyncProjectWizard");
        }
        this.setDialogSettings(section);
        SyncWizardDataCache.clearProperties();
    }

    public NewSyncProjectWizard(WizardMode mode) {
        this();
        this.wizardMode = mode;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void addPages() {
        super.addPages();
        if (this.wizardMode == null) {
            this.wizardMode = WizardMode.NEW;
        }
        if (this.wizardMode == WizardMode.NEW) {
            this.mainPage = SyncMainWizardPage.newProjectPage("basicNewProjectPage");
            this.mainPage.setTitle(Messages.NewProject_title);
            this.mainPage.setDescription(Messages.NewProject_description);
        } else if (this.wizardMode == WizardMode.CONVERT) {
            this.mainPage = SyncMainWizardPage.convertProjectPage("basicConvertProjectPage");
            this.mainPage.setTitle(Messages.ConvertProject_title);
            this.mainPage.setDescription(Messages.ConvertProject_description);
        }
        this.addPage((IWizardPage)this.mainPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("basicReferenceProjectPage");
            this.referencePage.setTitle(Messages.NewProject_referenceTitle);
            this.referencePage.setDescription(Messages.NewProject_referenceDescription);
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    private boolean createNewProject() {
        IProject[] refProjects;
        if (this.newProject != null) {
            return true;
        }
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        if (this.referencePage != null && (refProjects = this.referencePage.getReferencedProjects()).length > 0) {
            description.setReferencedProjects(refProjects);
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CreateProjectOperation op = new CreateProjectOperation(description, Messages.NewProject_windowTitle);
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)NewSyncProjectWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter(StatusUtil.newStatus((int)2, (String)NLS.bind((String)Messages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()), (Throwable)cause)) : new StatusAdapter(StatusUtil.newStatus((int)cause.getStatus().getSeverity(), (String)Messages.NewProject_errorMessage, (Throwable)cause));
                status.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)Messages.NewProject_errorMessage);
                StatusManager.getManager().handle(status, 4);
            } else {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "org.eclipse.ui.ide", 0, NLS.bind((String)Messages.NewProject_internalError, (Object)t.getMessage()), t));
                status.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)Messages.NewProject_errorMessage);
                StatusManager.getManager().handle(status, 5);
            }
            return false;
        }
        this.newProject = newProjectHandle;
        return true;
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.initializeDefaultPageImageDescriptor();
        this.setNeedsProgressMonitor(true);
        if (this.wizardMode == null) {
            this.wizardMode = WizardMode.NEW;
        }
        if (this.wizardMode == WizardMode.NEW) {
            this.setWindowTitle(Messages.NewProject_windowTitle);
        } else if (this.wizardMode == WizardMode.CONVERT) {
            this.setWindowTitle(Messages.ConvertProject_windowTitle);
        }
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/newprj_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    public boolean performFinish() {
        if (this.wizardMode == WizardMode.NEW) {
            if (!this.createNewProject()) {
                return false;
            }
            IWorkingSet[] workingSets = this.mainPage.getSelectedWorkingSets();
            this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.newProject, workingSets);
            this.updatePerspective();
            BasicNewResourceWizard.selectAndReveal((IResource)this.newProject, (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
        }
        IProject project = this.wizardMode == WizardMode.NEW ? this.newProject : this.mainPage.getProjectHandle();
        try {
            ISynchronizeParticipant part = this.mainPage.getSynchronizeParticipant();
            SyncManager.makeSyncProject((IProject)project, (String)part.getSyncConfigName(), (String)part.getServiceId(), (IRemoteConnection)part.getConnection(), (String)part.getLocation(), (AbstractSyncFileFilter)this.mainPage.getCustomFileFilter());
        }
        catch (CoreException e) {
            return false;
        }
        ISynchronizeWizardExtension ext = this.mainPage.getExtension();
        if (ext != null) {
            ext.performFinish();
        }
        SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.ACTIVE);
        try {
            SyncManager.sync(null, (IProject)project, (Set)SyncFlag.BOTH, (ISyncExceptionHandler)new CommonSyncExceptionHandler(false, true));
        }
        catch (CoreException e) {
            RDTSyncUIPlugin.log(Messages.NewSyncProjectWizard_Unexpected_core_exception, e);
        }
        return true;
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    protected void updatePerspective() {
        NewSyncProjectWizard.updatePerspective(this.configElement);
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        int workbenchPerspectiveSetting;
        IWorkbenchWindow window;
        if (configElement == null) {
            return;
        }
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            IDEWorkbenchPlugin.log((String)NLS.bind((String)Messages.NewSyncProjectWizard_Unable_to_find_perspective, (Object)finalPerspId));
            return;
        }
        ArrayList<String> preferredPerspIds = new ArrayList<String>();
        NewSyncProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, finalPerspId);
        String preferred = configElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (preferred != null) {
            StringTokenizer tok = new StringTokenizer(preferred, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                NewSyncProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, tok.nextToken());
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!NewSyncProjectWizard.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if ((workbenchPerspectiveSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE")) == 2) {
            NewSyncProjectWizard.openInNewWindow(finalPersp);
            return;
        }
        NewSyncProjectWizard.replaceCurrentPerspective(finalPersp);
    }

    private static void addPerspectiveAndDescendants(List<String> perspectiveIds, String id) {
        IPerspectiveDescriptor[] perspectives;
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectives = registry.getPerspectives();
        int n = perspectives.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            PerspectiveDescriptor descriptor = (PerspectiveDescriptor)perspective;
            if (descriptor.getOriginalId().equals(id)) {
                perspectiveIds.add(descriptor.getId());
            }
            ++n2;
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)Messages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)Messages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)Messages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    public static enum WizardMode {
        NEW,
        CONVERT;

    }
}

