/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.SubstringPatternFilter;
import org.eclipse.mylyn.internal.commons.notifications.ui.Messages;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationAction;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationCategory;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationElement;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationEvent;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationHandler;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationModel;
import org.eclipse.mylyn.internal.commons.notifications.ui.NotificationsPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class NotificationsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Object[] EMPTY = new Object[0];
    private TreeViewer eventsViewer;
    private CheckboxTableViewer notifiersViewer;
    private Button enableNotificationsButton;
    private NotificationModel model;
    private Text descriptionText;

    public IPreferenceStore getPreferenceStore() {
        return NotificationsPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        this.model = NotificationsPlugin.getDefault().createModelWorkingCopy();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.enableNotificationsButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.enableNotificationsButton);
        this.enableNotificationsButton.setText(Messages.NotificationsPreferencesPage_Enable_Notifications_Text);
        this.enableNotificationsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationsPreferencesPage.this.updateEnablement();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(" ");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        label = new Label(composite, 0);
        label.setText(Messages.NotificationsPreferencesPage_Events_Label);
        label = new Label(composite, 0);
        label.setText(Messages.NotificationsPreferencesPage_Notifiers_Label);
        FilteredTree tree = new FilteredTree(composite, 2048, (PatternFilter)new SubstringPatternFilter(), true, true);
        this.eventsViewer = tree.getViewer();
        GridDataFactory.fillDefaults().span(1, 2).grab(false, true).applyTo((Control)tree);
        this.eventsViewer.setComparer((IElementComparer)new NotificationEventComparer());
        this.eventsViewer.setContentProvider((IContentProvider)new EventContentProvider());
        this.eventsViewer.setLabelProvider((IBaseLabelProvider)new EventLabelProvider());
        this.eventsViewer.setInput((Object)this.model.getCategories().toArray());
        this.eventsViewer.expandAll();
        this.eventsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object input = this.getDetailsInput((IStructuredSelection)event.getSelection());
                NotificationsPreferencesPage.this.notifiersViewer.setInput(input);
                Object item = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (item instanceof NotificationEvent) {
                    NotificationsPreferencesPage.this.descriptionText.setText(((NotificationEvent)item).getDescription());
                    NotificationsPreferencesPage.this.notifiersViewer.getControl().setEnabled(true);
                } else {
                    NotificationsPreferencesPage.this.descriptionText.setText(" ");
                    NotificationsPreferencesPage.this.notifiersViewer.getControl().setEnabled(false);
                }
            }

            private Object getDetailsInput(IStructuredSelection selection) {
                Object item = selection.getFirstElement();
                if (item instanceof NotificationEvent) {
                    return NotificationsPreferencesPage.this.model.getOrCreateNotificationHandler((NotificationEvent)item);
                }
                return null;
            }
        });
        this.notifiersViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.notifiersViewer.getControl());
        this.notifiersViewer.setContentProvider((IContentProvider)new NotifiersContentProvider());
        this.notifiersViewer.setLabelProvider((IBaseLabelProvider)new EventLabelProvider());
        this.notifiersViewer.addCheckStateListener(event -> {
            NotificationAction action = (NotificationAction)event.getElement();
            action.setSelected(event.getChecked());
            this.model.setDirty(true);
            this.eventsViewer.refresh();
        });
        this.notifiersViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((NotificationAction)element).isSelected();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.notifiersViewer.addSelectionChangedListener(event -> {
            Object item = ((IStructuredSelection)event.getSelection()).getFirstElement();
            boolean cfr_ignored_0 = item instanceof NotificationAction;
        });
        Group group = new Group(composite, 0);
        GridDataFactory.fillDefaults().hint(150, -1).grab(true, true).applyTo((Control)group);
        group.setText(Messages.NotificationsPreferencesPage_Descriptions_Label);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        this.descriptionText = new Text((Composite)group, 64);
        this.descriptionText.setBackground(group.getBackground());
        this.reset();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void applyData(Object data) {
        if (data instanceof String) {
            String selectedEventId = (String)data;
            if (this.model != null) {
                Collection<NotificationCategory> items = this.model.getCategories();
                NotificationEvent selectedEvent = null;
                block0: for (NotificationCategory notificationCategory : items) {
                    List<NotificationEvent> event = notificationCategory.getEvents();
                    for (NotificationEvent notificationEvent : event) {
                        if (!notificationEvent.getId().equals(selectedEventId)) continue;
                        selectedEvent = notificationEvent;
                        continue block0;
                    }
                }
                if (selectedEvent != null) {
                    this.eventsViewer.setSelection((ISelection)new StructuredSelection(selectedEvent), true);
                }
            }
        }
    }

    private void updateEnablement() {
        boolean enabled = this.enableNotificationsButton.getSelection();
        this.eventsViewer.getControl().setEnabled(enabled);
        this.notifiersViewer.getControl().setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        if (!enabled) {
            this.eventsViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void reset() {
        this.enableNotificationsButton.setSelection(this.getPreferenceStore().getBoolean("notifications.enabled"));
        this.updateEnablement();
    }

    public boolean performOk() {
        if (this.model != null) {
            this.getPreferenceStore().setValue("notifications.enabled", this.enableNotificationsButton.getSelection());
            if (this.model.isDirty()) {
                NotificationsPlugin.getDefault().saveWorkingCopy(this.model);
                this.model.setDirty(false);
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.enableNotificationsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("notifications.enabled"));
        for (NotificationCategory category : this.model.getCategories()) {
            for (NotificationEvent event : category.getEvents()) {
                NotificationHandler handler = this.model.getOrCreateNotificationHandler(event);
                for (NotificationAction action : handler.getActions()) {
                    action.setSelected(event.defaultHandledBySink(action.getSinkDescriptor().getId()));
                }
            }
        }
        this.model.setDirty(true);
        this.eventsViewer.refresh();
        this.notifiersViewer.refresh();
        this.updateEnablement();
    }

    private final class EventContentProvider
    implements ITreeContentProvider {
        private EventContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof NotificationCategory) {
                return ((NotificationCategory)element).getEvents().size() > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof NotificationEvent) {
                return ((NotificationEvent)element).getCategory();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return EMPTY;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof NotificationCategory) {
                return ((NotificationCategory)parentElement).getEvents().toArray();
            }
            return EMPTY;
        }
    }

    public final class EventLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof NotificationElement) {
                NotificationElement item = (NotificationElement)element;
                return item.getLabel();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            NotificationElement item;
            ImageDescriptor imageDescriptor;
            if (element instanceof NotificationEvent) {
                NotificationEvent item2 = (NotificationEvent)element;
                if (NotificationsPreferencesPage.this.model.isSelected(item2)) {
                    return CommonImages.getImage((ImageDescriptor)CommonImages.CHECKED);
                }
                return null;
            }
            if (element instanceof NotificationElement && (imageDescriptor = (item = (NotificationElement)element).getImageDescriptor()) != null) {
                return CommonImages.getImage((ImageDescriptor)imageDescriptor);
            }
            return super.getImage(element);
        }
    }

    public class NotificationEventComparer
    implements IElementComparer {
        public boolean equals(Object a, Object b) {
            if (a instanceof NotificationEvent && b instanceof NotificationEvent) {
                String idA = ((NotificationEvent)a).getId();
                String idB = ((NotificationEvent)b).getId();
                return idA.equals(idB);
            }
            return a.equals(b);
        }

        public int hashCode(Object element) {
            return element.hashCode();
        }
    }

    private final class NotifiersContentProvider
    implements IStructuredContentProvider {
        private NotificationHandler handler;

        private NotifiersContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.handler = newInput instanceof NotificationHandler ? (NotificationHandler)newInput : null;
        }

        public Object[] getElements(Object inputElement) {
            if (this.handler != null) {
                return this.handler.getActions().toArray();
            }
            return EMPTY;
        }
    }
}

