/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XSDCompositor implements Enumerator
{
    ALL_LITERAL(0, "all", "all"),
    CHOICE_LITERAL(1, "choice", "choice"),
    SEQUENCE_LITERAL(2, "sequence", "sequence");

    public static final int ALL = 0;
    public static final int CHOICE = 1;
    public static final int SEQUENCE = 2;
    private static final XSDCompositor[] VALUES_ARRAY;
    public static final List<XSDCompositor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDCompositor[]{ALL_LITERAL, CHOICE_LITERAL, SEQUENCE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDCompositor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDCompositor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDCompositor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDCompositor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDCompositor get(int value) {
        switch (value) {
            case 0: {
                return ALL_LITERAL;
            }
            case 1: {
                return CHOICE_LITERAL;
            }
            case 2: {
                return SEQUENCE_LITERAL;
            }
        }
        return null;
    }

    private XSDCompositor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

