/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.objects;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.IPropertyDataTypeOverride;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.KnownStringPropertiesOverride;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.NlsPropertyOverride;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.PreserveOnPropertyChangeOverride;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.WidgetPropertyOverride;
import org.eclipse.scout.sdk.core.s.model.js.objects.IScoutJsObject;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsPropertyFactory;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.IFunction;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class JavaScriptScoutObject
implements IScoutJsObject {
    private static final Pattern REGEX_CONSTANT = Pattern.compile("[A-Z_0-9]+");
    private final ScoutJsModel m_scoutJsModel;
    private final IES6Class m_class;
    private final FinalValue<List<IFunction>> m_init;
    private final FinalValue<List<IFunction>> m_constructor;
    private final FinalValue<Map<String, ScoutJsProperty>> m_properties;

    protected JavaScriptScoutObject(ScoutJsModel scoutJsModel, IES6Class clazz) {
        this.m_scoutJsModel = scoutJsModel;
        this.m_class = clazz;
        this.m_constructor = new FinalValue();
        this.m_init = new FinalValue();
        this.m_properties = new FinalValue();
    }

    public static Optional<IScoutJsObject> create(ScoutJsModel owner, IES6Class clazz, IDataType widgetDataType) {
        return Optional.ofNullable(widgetDataType).flatMap(widgetType -> Optional.ofNullable(clazz).map(c -> new JavaScriptScoutObject(owner, (IES6Class)c)));
    }

    @Override
    public Map<String, ScoutJsProperty> properties() {
        return (Map)this.m_properties.computeIfAbsentAndGet(this::parseProperties);
    }

    protected Map<String, ScoutJsProperty> parseProperties() {
        Stream<IField> fields = this.declaringClass().fields().withoutModifier(Modifier.STATIC).stream().filter(f -> !REGEX_CONSTANT.matcher(f.name()).matches());
        return ScoutJsPropertyFactory.createProperties(fields, this.createOverrides(), this);
    }

    protected List<IPropertyDataTypeOverride> createOverrides() {
        IES6Class widgetType = this.scoutJsModel().widgetClass();
        IDataType stringType = (IDataType)Ensure.notNull((Object)this.declaringClass().spi().createDataType("string").api());
        return Arrays.asList(new PreserveOnPropertyChangeOverride(this, stringType), new WidgetPropertyOverride(this, (IDataType)widgetType), new NlsPropertyOverride(this, stringType), new KnownStringPropertiesOverride(this, stringType));
    }

    @Override
    public List<IFunction> _inits() {
        return (List)this.m_init.computeIfAbsentAndGet(() -> this.declaringClass().functions().withName("_init").stream().toList());
    }

    public List<IFunction> constructors() {
        return (List)this.m_constructor.computeIfAbsentAndGet(() -> this.declaringClass().functions().withName("constructor").stream().toList());
    }

    @Override
    public ScoutJsModel scoutJsModel() {
        return this.m_scoutJsModel;
    }

    @Override
    public IES6Class declaringClass() {
        return this.m_class;
    }

    @Override
    public String name() {
        return this.declaringClass().name();
    }

    public String toString() {
        return this.declaringClass().toString();
    }
}

