/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.embedder;

import java.io.File;
import java.util.Optional;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;

public interface IMavenExecutionContext {
    public MavenExecutionRequest getExecutionRequest() throws CoreException;

    public <V> V execute(ICallable<V> var1, IProgressMonitor var2) throws CoreException;

    public <V> V execute(MavenProject var1, ICallable<V> var2, IProgressMonitor var3) throws CoreException;

    public void execute(MavenProject var1, MojoExecution var2, IProgressMonitor var3) throws CoreException;

    public MavenExecutionResult execute(MavenExecutionRequest var1);

    public MavenSession getSession();

    public ArtifactRepository getLocalRepository();

    public RepositorySystemSession getRepositorySession();

    public ProjectBuildingRequest newProjectBuildingRequest();

    public IComponentLookup getComponentLookup();

    public static Optional<IMavenExecutionContext> getThreadContext() {
        return Optional.ofNullable(MavenExecutionContext.getThreadContext());
    }

    public static IMavenExecutionContext of(File baseDir) throws CoreException {
        PlexusContainerManager containerManager = MavenPlugin.getMaven().lookup(PlexusContainerManager.class);
        try {
            return new MavenExecutionContext(containerManager.getComponentLookup(baseDir), baseDir, null);
        }
        catch (Exception ex) {
            throw new CoreException(Status.error((String)("Acquire container for basedir " + baseDir.getAbsolutePath() + " failed!"), (Throwable)ex));
        }
    }
}

