/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.internal.selection.AbstractSelectionProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class MultiViewerSelectionProvider
extends AbstractSelectionProvider {
    private final List<Viewer> viewers = new ArrayList<Viewer>();
    private final Listener focusHook = event -> {
        if (event.type == 15 && event.widget instanceof Control) {
            this.focusChanged((Control)event.widget);
        }
    };
    private final ISelectionChangedListener selectionHook = this::selectionChanged;
    private final ISelectionChangedListener postSelectionHook = this::postSelectionChanged;
    private Viewer currentViewer;

    public MultiViewerSelectionProvider(Viewer ... providers) {
        Assert.isLegal((providers != null && providers.length > 0 ? 1 : 0) != 0);
        Viewer[] viewerArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            Viewer viewer = viewerArray[n2];
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.viewers.add(viewer);
            viewer.getControl().addListener(15, this.focusHook);
            viewer.addSelectionChangedListener(this.selectionHook);
            if (viewer instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)viewer).addPostSelectionChangedListener(this.postSelectionHook);
            }
            if (this.currentViewer == null) {
                this.currentViewer = viewer;
            }
            ++n2;
        }
    }

    private void focusChanged(Control control) {
        for (Viewer viewer : this.viewers) {
            if (control != viewer.getControl()) continue;
            if (viewer != this.currentViewer) {
                this.currentViewer = viewer;
                this.fireSelectionChanged(this.getSelectionListeners());
                this.fireSelectionChanged(this.getPostSelectionListeners());
            }
            return;
        }
    }

    private void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.currentViewer) {
            this.fireSelectionChanged(this.getSelectionListeners());
        }
    }

    private void postSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.currentViewer) {
            this.fireSelectionChanged(this.getPostSelectionListeners());
        }
    }

    public ISelection getSelection() {
        if (this.currentViewer != null) {
            return this.currentViewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.currentViewer != null) {
            this.currentViewer.setSelection(selection);
        }
    }

    public static class Builder {
        List<Viewer> viewers = new ArrayList<Viewer>();

        public Builder add(Viewer viewer) {
            this.viewers.add(viewer);
            return this;
        }

        public MultiViewerSelectionProvider build() {
            return new MultiViewerSelectionProvider(this.viewers.toArray(new Viewer[0]));
        }
    }
}

