/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.command.common.AbstractStartServer;
import org.eclipse.jst.ws.internal.consumption.common.WebServiceStartServerRegistry;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class StartProjectCommand
extends AbstractDataModelOperation {
    private Boolean creationScenario_ = Boolean.TRUE;
    private boolean isWebProjectStartupRequested_;
    private IProject serviceProject_;
    private IProject sampleProject_;
    private String serviceServerTypeID_;
    private String sampleServerTypeID_;
    private IServer serviceExistingServer_;
    private IServer sampleExistingServer_;

    public StartProjectCommand() {
    }

    public StartProjectCommand(boolean creationScenario) {
        this.creationScenario_ = new Boolean(creationScenario);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IServer server;
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        ProgressUtils.report((IProgressMonitor)monitor, (String)ConsumptionMessages.PROGRESS_INFO_START_WEB_PROJECT);
        IProject project = this.creationScenario_ != false ? this.serviceProject_ : this.sampleProject_;
        String serverTypeID = this.creationScenario_ != false ? this.serviceServerTypeID_ : this.sampleServerTypeID_;
        IServer iServer = server = this.creationScenario_ != false ? this.serviceExistingServer_ : this.sampleExistingServer_;
        if (serverTypeID == null && server != null) {
            serverTypeID = server.getServerType().getId();
        }
        if (project == null) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_PROJECT_NOT_FOUND);
            env.getStatusHandler().reportError(status);
            return status;
        }
        IServer instance = ServerUtils.getServerForModule((IModule)ServerUtils.getModule((IProject)project), (String)serverTypeID, (IServer)server, (boolean)true, (IProgressMonitor)monitor);
        if (instance == null) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_INSTANCE_NOT_FOUND);
            env.getStatusHandler().reportError(status);
            return status;
        }
        try {
            AbstractStartServer startServerCommand = null;
            WebServiceStartServerRegistry reg = WebServiceStartServerRegistry.getInstance();
            startServerCommand = (AbstractStartServer)reg.getServerStartByTypeId(instance.getServerType().getId());
            startServerCommand.StartServer(project, instance, monitor, this.isWebProjectStartupRequested_);
            return status;
        }
        catch (CoreException ce) {
            IStatus embeddedStatus;
            status = embeddedStatus = ce.getStatus();
            env.getStatusHandler().reportError(status);
            return status;
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SERVER, (Throwable)e);
            env.getStatusHandler().reportError(status);
            return status;
        }
    }

    public void setCreationScenario(Boolean creationScenario) {
        this.creationScenario_ = creationScenario;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }

    public void setSampleProject(IProject sampleProject) {
        this.sampleProject_ = sampleProject;
    }

    public void setServiceServerTypeID(String serviceServerTypeID) {
        this.serviceServerTypeID_ = serviceServerTypeID;
    }

    public void setSampleServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID_ = sampleServerTypeID;
    }

    public void setServiceExistingServer(IServer serviceExistingServer) {
        this.serviceExistingServer_ = serviceExistingServer;
        if (this.serviceExistingServer_ != null) {
            this.setServiceServerTypeID(this.serviceExistingServer_.getServerType().getId());
        }
    }

    public void setSampleExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer_ = sampleExistingServer;
        if (this.sampleExistingServer_ != null) {
            this.setSampleServerTypeID(this.sampleExistingServer_.getServerType().getId());
        }
    }

    public void setIsWebProjectStartupRequested(boolean webProjectStartupRequested) {
        this.isWebProjectStartupRequested_ = webProjectStartupRequested;
    }
}

