/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.ui.internal.UIPlugin;
import org.eclipse.wst.common.ui.internal.viewers.SelectSingleFileView;

public class SelectSingleFileDialog
extends TitleAreaDialog {
    protected SelectSingleFileView selectSingleFileView;
    protected Button okButton;
    protected Image image;
    private ImageDescriptor imageDescriptor;

    public SelectSingleFileDialog(Shell parentShell, IStructuredSelection selection, boolean isFileMandatory) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (selection == null) {
            selection = new StructuredSelection();
        }
        this.selectSingleFileView = new SelectSingleFileView(selection, isFileMandatory){

            @Override
            public void createFilterControl(Composite composite) {
                SelectSingleFileDialog.this.createFilterControl(composite);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 350;
        gd.heightHint = 350;
        composite.setLayoutData((Object)gd);
        SelectSingleFileView.Listener listener = new SelectSingleFileView.Listener(){

            @Override
            public void setControlComplete(boolean isComplete) {
                SelectSingleFileDialog.this.okButton.setEnabled(isComplete);
            }
        };
        this.selectSingleFileView.setListener(listener);
        this.selectSingleFileView.createControl(composite);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void create() {
        super.create();
        this.selectSingleFileView.setVisibleHelper(true);
        this.image = this.getSaveAsImage();
        this.setTitleImage(this.image);
    }

    private Image getSaveAsImage() {
        Image localimage = null;
        try {
            if (this.imageDescriptor == null) {
                this.imageDescriptor = UIPlugin.getDefault().getImageDescriptor("icons/saveas_wiz.png");
            }
            localimage = (Image)this.imageDescriptor.createResource((Device)this.getContents().getDisplay());
        }
        catch (DeviceResourceException deviceResourceException) {
            localimage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return localimage;
    }

    public void createFilterCombo(Composite composite) {
    }

    public IFile getFile() {
        return this.selectSingleFileView.getFile();
    }

    public void addFilterExtensions(String[] filterExtensions) {
        this.selectSingleFileView.addFilterExtensions(filterExtensions);
    }

    public void addFilterExtensions(String[] filterExtensions, IFile[] excludedFiles) {
        this.selectSingleFileView.addFilterExtensions(filterExtensions, excludedFiles);
    }

    public void createFilterControl(Composite composite) {
    }

    public boolean close() {
        if (this.image != null && this.imageDescriptor != null) {
            this.imageDescriptor.destroyResource((Object)this.image);
            this.image = null;
        }
        return super.close();
    }
}

