/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HorizontalAlignment implements Enumerator
{
    AUTOMATIC_LITERAL(0, "Automatic", "Automatic"),
    LEFT_LITERAL(1, "Left", "Left"),
    CENTER_LITERAL(2, "Center", "Center"),
    RIGHT_LITERAL(3, "Right", "Right"),
    LEFT_AND_RIGHT_LITERAL(4, "LeftAndRight", "Left and Right");

    public static final String copyright = "Copyright (c) 2005, 2010 Actuate Corporation";
    public static final int AUTOMATIC = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEFT_AND_RIGHT = 4;
    private static final HorizontalAlignment[] VALUES_ARRAY;
    public static final List<HorizontalAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HorizontalAlignment[]{AUTOMATIC_LITERAL, LEFT_LITERAL, CENTER_LITERAL, RIGHT_LITERAL, LEFT_AND_RIGHT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HorizontalAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HorizontalAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HorizontalAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HorizontalAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HorizontalAlignment get(int value) {
        switch (value) {
            case 0: {
                return AUTOMATIC_LITERAL;
            }
            case 1: {
                return LEFT_LITERAL;
            }
            case 2: {
                return CENTER_LITERAL;
            }
            case 3: {
                return RIGHT_LITERAL;
            }
            case 4: {
                return LEFT_AND_RIGHT_LITERAL;
            }
        }
        return null;
    }

    private HorizontalAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

