/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.DateUtil;
import org.eclipse.datatools.connectivity.oda.flatfile.util.FlatFileDataReader;

public class ResultSet
implements IResultSet {
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final int CURSOR_INITIAL_VALUE = -1;
    private String[][] sourceData = null;
    private ResultSetMetaData resultSetMetaData = null;
    private int maxRows = 0;
    private int cursor = -1;
    private FlatFileDataReader flatFileDataReader;
    private boolean wasNull = false;
    private int fetchAccumulator = 0;
    private boolean overFlow = false;
    private boolean trailNullCols = false;
    private static ULocale JRE_DEFAULT_LOCALE = ULocale.getDefault();
    private static Pattern pattern1 = Pattern.compile("\\QT\\E");
    private static Pattern pattern2 = Pattern.compile("\\QZ\\E");

    ResultSet(FlatFileDataReader ffr, ResultSetMetaData rsmd) {
        assert (ffr != null);
        this.flatFileDataReader = ffr;
        this.resultSetMetaData = rsmd;
        this.maxRows = this.flatFileDataReader.getMaxRowsToRead(this.maxRows);
        this.trailNullCols = this.flatFileDataReader.getTrailNullColumns();
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public void close() throws OdaException {
        this.cursor = 0;
        this.sourceData = null;
        this.resultSetMetaData = null;
        this.flatFileDataReader.clearBufferedReader();
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public boolean next() throws OdaException {
        if (this.overFlow) {
            return false;
        }
        if (this.cursor == -1) {
            this.sourceData = this.flatFileDataReader.getSourceData();
        }
        if (this.maxRows > 0 && this.fetchAccumulator >= this.maxRows) {
            this.flatFileDataReader.clearBufferedReader();
            this.cursor = -1;
            this.overFlow = true;
            return false;
        }
        if (this.cursor == this.sourceData.length - 1) {
            this.sourceData = this.flatFileDataReader.getSourceData();
            this.cursor = -1;
            if (this.sourceData.length == 0) {
                this.flatFileDataReader.clearBufferedReader();
                this.overFlow = true;
                return false;
            }
        }
        ++this.fetchAccumulator;
        ++this.cursor;
        return true;
    }

    public int getRow() throws OdaException {
        this.validateCursorState();
        return this.fetchAccumulator;
    }

    public String getString(int index) throws OdaException {
        this.validateCursorState();
        String result = this.sourceData[this.cursor][index - 1];
        if (this.trailNullCols && result == null || result.length() == 0) {
            result = null;
        }
        this.wasNull = result == null;
        return result;
    }

    public String getString(String columnName) throws OdaException {
        this.validateCursorState();
        int columnIndex = this.findColumn(columnName);
        return this.getString(columnIndex);
    }

    public int getInt(int index) throws OdaException {
        return this.stringToInt(this.getString(index));
    }

    public int getInt(String columnName) throws OdaException {
        return this.stringToInt(this.getString(columnName));
    }

    public double getDouble(int index) throws OdaException {
        return this.stringToDouble(this.getString(index));
    }

    public double getDouble(String columnName) throws OdaException {
        return this.stringToDouble(this.getString(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return this.stringToBigDecimal(this.getString(index));
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.stringToBigDecimal(this.getString(columnName));
    }

    public Date getDate(int index) throws OdaException {
        return this.stringToDate(this.getString(index));
    }

    public Date getDate(String columnName) throws OdaException {
        return this.stringToDate(this.getString(columnName));
    }

    public Time getTime(int index) throws OdaException {
        return this.stringToTime(this.getString(index));
    }

    public Time getTime(String columnName) throws OdaException {
        return this.stringToTime(this.getString(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return this.stringToTimestamp(this.getString(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.stringToTimestamp(this.getString(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int index) throws OdaException {
        return this.stringToBoolean(this.getString(index));
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.stringToBoolean(this.getString(columnName));
    }

    public Object getObject(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws OdaException {
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        return this.resultSetMetaData.findColumn(columnName);
    }

    private void validateCursorState() throws OdaException {
        if (this.cursor < 0) {
            throw new OdaException(Messages.getString("resultSet_CURSOR_HAS_NOT_BEEN_INITIALIZED"));
        }
    }

    private int stringToInt(String stringValue) throws OdaException {
        if (stringValue != null) {
            try {
                return Integer.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return number.intValue();
                    }
                }
                catch (ParseException parseException) {
                    throw new OdaException("Can not convert \"" + stringValue + "\"" + " to Integer");
                }
            }
        }
        this.wasNull = true;
        return 0;
    }

    private double stringToDouble(String stringValue) throws OdaException {
        if (stringValue != null) {
            try {
                return Double.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return number.doubleValue();
                    }
                }
                catch (ParseException parseException) {
                    throw new OdaException("Can not convert \"" + stringValue + "\"" + " to a double value");
                }
            }
        }
        this.wasNull = true;
        return 0.0;
    }

    private BigDecimal stringToBigDecimal(String stringValue) throws OdaException {
        if (stringValue != null) {
            try {
                return new BigDecimal(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return new BigDecimal(number.toString());
                    }
                }
                catch (ParseException parseException) {
                    throw new OdaException("Can not convert \"" + stringValue + "\"" + " to a BigDecimal value");
                }
            }
        }
        this.wasNull = true;
        return null;
    }

    private Date stringToDate(String stringValue) throws OdaException {
        if (stringValue != null) {
            try {
                return DateUtil.toSqlDate(stringValue);
            }
            catch (OdaException odaException) {
                throw new OdaException("Can not convert \"" + stringValue + "\"" + " to a date value");
            }
        }
        this.wasNull = true;
        return null;
    }

    private Time stringToTime(String stringValue) throws OdaException {
        if (stringValue != null) {
            try {
                return DateUtil.toSqlTime((Object)stringValue);
            }
            catch (OdaException odaException) {
                throw new OdaException("Can not convert \"" + stringValue + "\"" + " to a Time value");
            }
        }
        this.wasNull = true;
        return null;
    }

    private Timestamp stringToTimestamp(String stringValue) throws OdaException {
        if (stringValue != null) {
            try {
                String value = pattern1.matcher(stringValue).replaceAll(" ");
                value = pattern2.split(value)[0];
                return Timestamp.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    long timeMills = Long.valueOf(stringValue);
                    return new Timestamp(timeMills);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        java.util.Date date = DateUtil.toDate((Object)stringValue);
                        Timestamp timeStamp = new Timestamp(date.getTime());
                        return timeStamp;
                    }
                    catch (OdaException odaException) {
                        throw new OdaException("Can not convert string \"" + stringValue + "\"" + " to a Timestamp value");
                    }
                }
            }
        }
        this.wasNull = true;
        return null;
    }

    private Boolean stringToBoolean(String stringValue) throws OdaException {
        if (stringValue != null) {
            if (stringValue.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (stringValue.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            try {
                if (Integer.parseInt(stringValue) == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse(stringValue);
                    if (number != null) {
                        return number.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
                catch (ParseException parseException) {
                    throw new OdaException("Can not convert \"" + stringValue + "\"" + " to boolean value");
                }
            }
        }
        return Boolean.FALSE;
    }
}

