/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.flat;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.flat.FlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.FlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.FlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class VirtualComponentFlattenUtility {
    private List<IFlatResource> members;
    private ShouldIncludeUtilityCallback handler;

    public VirtualComponentFlattenUtility(List<IFlatResource> members, ShouldIncludeUtilityCallback handler) {
        this.members = members;
        this.handler = handler;
    }

    public void addMembers(IVirtualComponent current, IVirtualContainer cont, IPath path) throws CoreException {
        VirtualComponentFlattenUtility.ensureParentExists(this.members, path, null);
        FlatResource[] mr = this.addMembersInternal(current, cont, path);
        int size = mr.length;
        int j = 0;
        while (j < size) {
            this.members.add(mr[j]);
            ++j;
        }
    }

    public void addContainer(IContainer container, IPath path) throws CoreException {
        IResource[] children = container.members();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IContainer) {
                this.addContainerInternal((IContainer)children[i], path);
            } else if (children[i] instanceof IFile) {
                this.addFile(null, (IFile)children[i], path);
            }
            ++i;
        }
    }

    protected void addContainerInternal(IContainer container, IPath path) throws CoreException {
        FlatFolder mf = (FlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(this.members, path.append(container.getName()).makeRelative());
        if (mf == null) {
            mf = new FlatFolder(container, container.getName(), path);
            IFlatFolder parent = (FlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(this.members, path);
            if (path.isEmpty()) {
                this.members.add(mf);
            } else {
                if (parent == null) {
                    parent = VirtualComponentFlattenUtility.ensureParentExists(this.members, path, container);
                }
                VirtualComponentFlattenUtility.addMembersToModuleFolder(parent, new IFlatResource[]{mf});
            }
        }
        this.addContainer(container, path.append(container.getName()));
    }

    protected FlatResource[] addMembersInternal(IVirtualComponent current, IVirtualContainer cont, IPath path) throws CoreException {
        IVirtualResource[] res = cont.members();
        int size2 = res.length;
        ArrayList list = new ArrayList(size2);
        int j = 0;
        while (j < size2) {
            if (res[j] instanceof IVirtualContainer) {
                IVirtualContainer cc = (IVirtualContainer)res[j];
                IFlatFolder mf = this.addVirtualContainerInternal(cc, path);
                IFlatResource[] mr = this.addMembersInternal(current, cc, path.append(cc.getName()));
                VirtualComponentFlattenUtility.addMembersToModuleFolder(mf, mr);
            } else {
                this.addFile(current, path, res[j]);
            }
            ++j;
        }
        FlatResource[] mr = new FlatResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    public void addFile(IVirtualComponent current, IPath path, IAdaptable file) {
        IVirtualFile vf = file instanceof IFile ? null : (IVirtualFile)file.getAdapter(IVirtualFile.class);
        IFile f = file instanceof IFile ? (IFile)file : (IFile)file.getAdapter(IFile.class);
        FlatFile mf = null;
        String vfName = null;
        if (vf != null && vf.getName() != null) {
            vfName = vf.getName();
        }
        if (f != null) {
            mf = new FlatFile(f, vfName == null ? f.getName() : vfName, path.makeRelative());
        } else {
            File f2 = (File)file.getAdapter(File.class);
            if (f2 != null) {
                mf = new FlatFile(f2, vfName == null ? f2.getName() : vfName, path.makeRelative());
            }
        }
        if (mf != null && (this.handler == null || this.handler.shouldAddComponentFile(current, mf))) {
            if (mf.getModuleRelativePath().segmentCount() == 0) {
                this.members.remove(mf);
                this.members.add(mf);
            } else {
                IFlatFolder moduleParent = VirtualComponentFlattenUtility.ensureParentExists(this.members, mf.getModuleRelativePath(), null);
                ArrayList<IFlatResource> tempParentMembers = new ArrayList<IFlatResource>(Arrays.asList(moduleParent.members()));
                tempParentMembers.remove(mf);
                tempParentMembers.add(mf);
                moduleParent.setMembers(tempParentMembers.toArray(new IFlatResource[tempParentMembers.size()]));
            }
        }
    }

    public void addFile(IVirtualComponent current, IFile f, IPath path) {
        this.addFile(current, path, (IAdaptable)f);
    }

    protected IFlatFolder addVirtualContainerInternal(IVirtualContainer cc, IPath path) {
        FlatFolder mf = (FlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(this.members, path.append(cc.getName()).makeRelative());
        if (mf == null) {
            mf = new FlatFolder((IContainer)cc.getUnderlyingResource(), cc.getName(), path);
            IFlatFolder parent = (FlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(this.members, path);
            if (path.isEmpty()) {
                this.members.add(mf);
            } else {
                if (parent == null) {
                    parent = VirtualComponentFlattenUtility.ensureParentExists(this.members, path, (IContainer)cc.getUnderlyingResource());
                }
                VirtualComponentFlattenUtility.addMembersToModuleFolder(parent, new IFlatResource[]{mf});
            }
        }
        return mf;
    }

    public static FlatFile createModuleFile(IFile file, IPath path) {
        return new FlatFile(file, file.getName(), path);
    }

    public static FlatResource getExistingModuleResource(List aList, IPath path) {
        if (aList == null || aList.isEmpty() || path == null) {
            return null;
        }
        String[] pathSegments = path.segments();
        FlatResource exportableResource2 = null;
        if (pathSegments.length == 0) {
            return null;
        }
        for (FlatResource exportableResource2 : aList) {
            String[] moduleSegments = exportableResource2.getModuleRelativePath().segments();
            if (pathSegments[pathSegments.length - 1].equals(exportableResource2.getName()) && moduleSegments.length + 1 == pathSegments.length && VirtualComponentFlattenUtility.startsWith(moduleSegments, pathSegments)) {
                return exportableResource2;
            }
            if (!(exportableResource2 instanceof FlatFolder) || !VirtualComponentFlattenUtility.startsWith(moduleSegments, pathSegments) || pathSegments.length <= moduleSegments.length || !exportableResource2.getName().equals(pathSegments[moduleSegments.length > 0 ? moduleSegments.length : 0]) || ((FlatFolder)exportableResource2).members() == null) continue;
            return VirtualComponentFlattenUtility.getExistingModuleResource(Arrays.asList(((FlatFolder)exportableResource2).members()), path);
        }
        return null;
    }

    private static boolean startsWith(String[] beginningSegments, String[] testSegments) {
        int i = 0;
        while (i < beginningSegments.length) {
            if (!beginningSegments[i].equals(testSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IFlatFolder ensureParentExists(List<IFlatResource> members, IPath path, IContainer cc) {
        IFlatFolder parent = (IFlatFolder)((Object)VirtualComponentFlattenUtility.getExistingModuleResource(members, path));
        if (parent == null && path.segmentCount() > 0) {
            String folderName = path.lastSegment();
            Path folderPath = Path.EMPTY;
            if (path.segmentCount() > 1) {
                folderPath = path.removeLastSegments(1);
            }
            parent = new FlatFolder(cc, folderName, (IPath)folderPath);
            if (path.segmentCount() > 1) {
                VirtualComponentFlattenUtility.addMembersToModuleFolder(VirtualComponentFlattenUtility.ensureParentExists(members, path.removeLastSegments(1), cc), new IFlatResource[]{parent});
            } else {
                members.add(parent);
            }
        }
        return parent;
    }

    public static void addMembersToModuleFolder(IFlatFolder mf, IFlatResource[] mr) {
        if (mf == null || mr == null || mr.length == 0) {
            return;
        }
        IFlatResource[] mf_members = mf.members();
        int mf_size = 0;
        if (mf_members != null) {
            mf_size = mf_members.length;
        }
        IFlatResource[] res = new FlatResource[mf_size + mr.length];
        if (mf_members != null && mf_size > 0) {
            System.arraycopy(mf_members, 0, res, 0, mf_size);
        }
        System.arraycopy(mr, 0, res, mf_size, mr.length);
        mf.setMembers(res);
    }

    public static interface ShouldIncludeUtilityCallback {
        public boolean shouldAddComponentFile(IVirtualComponent var1, IFlatFile var2);
    }
}

