/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.jdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.IInteractionElement;

public class TypeHistoryManager
extends AbstractContextListener {
    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: {
                this.clearTypeHistory();
                for (IInteractionElement node : event.getContext().getInteresting()) {
                    this.updateTypeHistory(node, true);
                }
                break;
            }
            case DEACTIVATED: {
                this.clearTypeHistory();
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext()) break;
                this.clearTypeHistory();
                break;
            }
            case INTEREST_CHANGED: {
                for (IInteractionElement node : event.getElements()) {
                    this.updateTypeHistory(node, true);
                }
                break;
            }
            case ELEMENTS_DELETED: {
                for (IInteractionElement element : event.getElements()) {
                    this.updateTypeHistory(element, false);
                }
                break;
            }
        }
    }

    private void updateTypeHistory(IInteractionElement node, boolean add) {
        IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
        if (element instanceof IType) {
            IType type = (IType)element;
            try {
                if (type.exists() && !type.isAnonymous() && !this.isAspectjType(type)) {
                    JavaSearchTypeNameMatch typeNameMatch = new JavaSearchTypeNameMatch(type, type.getFlags());
                    if (add && !OpenTypeHistory.getInstance().contains((TypeNameMatch)typeNameMatch)) {
                        OpenTypeHistory.getInstance().accessed((TypeNameMatch)typeNameMatch);
                    } else {
                        OpenTypeHistory.getInstance().remove((TypeNameMatch)typeNameMatch);
                    }
                }
            }
            catch (JavaModelException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Failed to update history for a type", (Throwable)e));
            }
        }
    }

    private boolean isAspectjType(IType type) {
        return type.getHandleIdentifier().indexOf(125) != -1;
    }

    public void clearTypeHistory() {
        TypeNameMatch[] typeInfos;
        TypeNameMatch[] typeNameMatchArray = typeInfos = OpenTypeHistory.getInstance().getTypeInfos();
        int n = typeInfos.length;
        int n2 = 0;
        while (n2 < n) {
            TypeNameMatch typeInfo = typeNameMatchArray[n2];
            OpenTypeHistory.getInstance().remove(typeInfo);
            ++n2;
        }
    }
}

