/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ShowInSystemExplorerActionHandler
extends RepositoryActionHandler {
    private static final String VARIABLE_RESOURCE = "${selected_resource_loc}";
    private static final String VARIABLE_RESOURCE_URI = "${selected_resource_uri}";
    private static final String VARIABLE_FOLDER = "${selected_resource_parent_loc}";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element = this.getSelection().getFirstElement();
        if (!(element instanceof RepositoryTreeNode)) {
            return null;
        }
        File canonicalPath = (File)Adapters.adapt((Object)element, File.class);
        if (canonicalPath == null) {
            return null;
        }
        Job job = Job.create((String)UIText.ShowInSystemExplorerActionHandler_JobTitle, monitor -> {
            try {
                String launchCmd = this.getShowInSystemExplorerCommand(canonicalPath);
                if (launchCmd.isEmpty()) {
                    return Status.CANCEL_STATUS;
                }
                File dir = canonicalPath.getParentFile();
                if (Util.isLinux() || Util.isMac()) {
                    Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", launchCmd}, null, dir);
                } else {
                    Runtime.getRuntime().exec(launchCmd, null, dir);
                }
            }
            catch (IOException e) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        });
        job.schedule();
        return null;
    }

    private String getShowInSystemExplorerCommand(File path) throws IOException {
        String command = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SYSTEM_EXPLORER");
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE, (String)this.quotePath(path.getCanonicalPath()));
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE_URI, (String)path.getCanonicalFile().toURI().toString());
        File parent = path.getParentFile();
        if (parent != null) {
            command = Util.replaceAll((String)command, (String)VARIABLE_FOLDER, (String)this.quotePath(parent.getCanonicalPath()));
        }
        return command;
    }

    private String quotePath(String path) {
        if (Util.isLinux() || Util.isMac()) {
            path = path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }

    @Override
    public boolean isEnabled() {
        return this.getSelection().size() == 1;
    }
}

