/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.BasicColorProvider;
import org.eclipse.draw2d.ColorProvider;
import org.eclipse.gef.GEFColorProvider;
import org.eclipse.gef.internal.Logger;
import org.eclipse.gef.internal.LoggerContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class InternalGEFPlugin
extends AbstractUIPlugin {
    private static BundleContext context;
    private static AbstractUIPlugin singleton;
    private static Boolean isSvgSupported;

    public InternalGEFPlugin() {
        singleton = this;
    }

    public void start(BundleContext bc) throws Exception {
        super.start(bc);
        context = bc;
        if (ColorProvider.SystemColorFactory.getColorProvider() instanceof BasicColorProvider && PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isClosing()) {
            ColorProvider.SystemColorFactory.setColorProvider((ColorProvider)new GEFColorProvider());
        }
        Logger.setContext((org.eclipse.draw2d.internal.LoggerContext)new LoggerContext());
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
    }

    public static BundleContext getContext() {
        return context;
    }

    public static AbstractUIPlugin getDefault() {
        return singleton;
    }

    public void stop(BundleContext context) throws Exception {
        this.savePluginPreferences();
        super.stop(context);
    }

    public static int getOrDefaultDeviceZoom() {
        if (Platform.getOS().equals("macosx") || Platform.getOS().equals("linux") && "x11".equalsIgnoreCase(System.getenv("XDG_SESSION_TYPE"))) {
            return 100;
        }
        String deviceZoom = System.getProperty("org.eclipse.swt.internal.deviceZoom", "100");
        try {
            return Integer.parseInt(deviceZoom);
        }
        catch (NumberFormatException e) {
            return 100;
        }
    }

    public static ImageData scaledImageData(ImageDescriptor descriptor, int zoom) {
        ImageData data = descriptor.getImageData(zoom);
        if (data != null) {
            return data;
        }
        Image image = descriptor.createImage();
        try {
            ImageData imageData = image.getImageData(zoom);
            return imageData;
        }
        finally {
            image.dispose();
        }
    }

    public static boolean isSvgSupported() {
        if (isSvgSupported != null) {
            return isSvgSupported;
        }
        String svg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<svg width=\"1\" height=\"1\" version=\"1.1\" viewBox=\"0 0 0 0\" xmlns=\"http://www.w3.org/2000/svg\"></svg>\n";
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(svg.getBytes(StandardCharsets.UTF_8));){
                new ImageLoader().load((InputStream)is);
                isSvgSupported = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ignore) {
            isSvgSupported = false;
        }
        catch (SWTException e) {
            isSvgSupported = false;
        }
        return isSvgSupported;
    }

    public static Cursor createCursor(ImageDescriptor source, int hotspotX, int hotspotY) {
        try {
            Constructor ctor = Cursor.class.getConstructor(Device.class, ImageDataProvider.class, Integer.TYPE, Integer.TYPE);
            Object[] objectArray = new Object[4];
            objectArray[0] = null;
            objectArray[1] = arg_0 -> ((ImageDescriptor)source).getImageData(arg_0);
            objectArray[2] = hotspotX;
            objectArray[3] = hotspotY;
            return (Cursor)ctor.newInstance(objectArray);
        }
        catch (NoSuchMethodException e) {
            return new Cursor(null, source.getImageData(100), hotspotX, hotspotY);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Cursor", e);
        }
    }
}

