/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.debug.core.model.IScriptSpawnpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptSpawnpoint
extends ScriptLineBreakpoint
implements IScriptSpawnpoint {
    private static final String[] UPDATABLE_ATTRS = new String[]{"lineNumber", "org.eclipse.debug.core.enabled"};

    @Override
    protected String getMarkerId() {
        return "org.eclipse.dltk.debug.scriptSpawnpointMarker";
    }

    public ScriptSpawnpoint() {
    }

    public ScriptSpawnpoint(String debugModelId, IResource resource, IPath path, int lineNumber, int charStart, int charEnd, boolean register) throws DebugException {
        IWorkspaceRunnable wr = monitor -> {
            this.setMarker(resource.createMarker(this.getMarkerId()));
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            this.addScriptBreakpointAttributes(attributes, debugModelId, true);
            this.addLineBreakpointAttributes(attributes, path, lineNumber, charStart, charEnd);
            this.ensureMarker().setAttributes(attributes);
            this.register(register);
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    @Override
    public String[] getUpdatableAttributes() {
        return UPDATABLE_ATTRS;
    }
}

