/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Packages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.bnd.PdeProjectAnalyzer;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.TextUtil;

public class GatherUnusedDependenciesOperation
implements IRunnableWithProgress {
    private final IPluginModelBase fModel;
    private List<Object> fList;

    public GatherUnusedDependenciesOperation(IPluginModelBase model) {
        this.fModel = model;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Set<Object> computedPackages;
        if (!ClasspathUtilCore.hasBundleStructure((IPluginModelBase)this.fModel)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PdeProjectAnalyzer analyzer = new PdeProjectAnalyzer(this.fModel.getUnderlyingResource().getProject(), true);){
                analyzer.setImportPackage("*");
                analyzer.calcManifest();
                Packages imports = analyzer.getImports();
                computedPackages = imports == null ? Set.of() : imports.keySet().stream().map(Descriptors.PackageRef::getFQN).collect(Collectors.toSet());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        ImportPackageObject[] packages = null;
        IBundle bundle = ((IBundlePluginModelBase)this.fModel).getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Import-Package");
        if (header instanceof ImportPackageHeader) {
            packages = ((ImportPackageHeader)header).getPackages();
        } else if (header != null && header.getValue() != null) {
            header = new ImportPackageHeader("Import-Package", header.getValue(), bundle, TextUtil.getDefaultLineDelimiter());
            packages = ((ImportPackageHeader)header).getPackages();
        }
        Collection<String> exportedPackages = GatherUnusedDependenciesOperation.getExportedPackages(this.fModel);
        IPluginImport[] imports = this.fModel.getPluginBase().getImports();
        int totalWork = imports.length * 3 + (packages != null ? packages.length : 0) + 11;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        HashMap<String, IPluginImport> usedPlugins = new HashMap<String, IPluginImport>();
        this.fList = new ArrayList<Object>();
        IPluginImport[] iPluginImportArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport pluginImport = iPluginImportArray[n2];
            if (subMonitor.isCanceled()) {
                return;
            }
            if (this.isUnused(pluginImport, computedPackages, (IProgressMonitor)subMonitor.split(3))) {
                this.fList.add(pluginImport);
            } else {
                usedPlugins.put(pluginImport.getId(), pluginImport);
            }
            this.updateMonitor((IProgressMonitor)subMonitor, this.fList.size());
            ++n2;
        }
        ArrayList<ImportPackageObject> usedPackages = new ArrayList<ImportPackageObject>();
        if (packages != null && !subMonitor.isCanceled()) {
            ImportPackageObject[] importPackageObjectArray = packages;
            int n3 = packages.length;
            n = 0;
            while (n < n3) {
                ImportPackageObject importPackage = importPackageObjectArray[n];
                if (subMonitor.isCanceled()) {
                    return;
                }
                if (this.isUnused(importPackage, exportedPackages, computedPackages, (IProgressMonitor)subMonitor.split(1))) {
                    this.fList.add(importPackage);
                    this.updateMonitor((IProgressMonitor)subMonitor, this.fList.size());
                } else {
                    usedPackages.add(importPackage);
                }
                ++n;
            }
        }
        if (subMonitor.isCanceled()) {
            return;
        }
        this.minimizeDependencies(usedPlugins, usedPackages, (IProgressMonitor)subMonitor);
        this.removeBuddies();
        this.removeReexported();
        this.removeSourceReferences((IProgressMonitor)subMonitor.split(10));
    }

    private void removeSourceReferences(IProgressMonitor monitor) {
        if (this.fList.isEmpty()) {
            return;
        }
        IProject project = this.fModel.getUnderlyingResource().getProject();
        if (PluginProject.isJavaProject((IProject)project)) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (String)"Search Source References for unused requirements", (int)this.fList.size());
            Iterator<Object> iterator = this.fList.iterator();
            while (iterator.hasNext()) {
                ImportPackageObject pkg;
                Object item = iterator.next();
                if (!(item instanceof ImportPackageObject) || !this.isPackageReferenced(pkg = (ImportPackageObject)item, javaProject, (IProgressMonitor)convert.split(1))) continue;
                iterator.remove();
            }
        }
    }

    private boolean isPackageReferenced(ImportPackageObject pkg, IJavaProject javaProject, final IProgressMonitor monitor) {
        block4: {
            try {
                Requestor requestor;
                block5: {
                    SearchEngine engine = new SearchEngine();
                    IJavaSearchScope searchScope = PluginJavaSearchUtil.createSeachScope((IJavaProject)javaProject);
                    requestor = new Requestor();
                    String packageName = pkg.getName();
                    SearchPattern pattern = SearchPattern.createPattern((String)packageName, (int)2, (int)2, (int)0);
                    if (pattern == null) break block4;
                    ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor){

                        public boolean isCanceled() {
                            return monitor.isCanceled() || requestor.used;
                        }

                        public void setCanceled(boolean b) {
                        }
                    };
                    try {
                        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, (IProgressMonitor)wrapper);
                    }
                    catch (OperationCanceledException e) {
                        if (!monitor.isCanceled()) break block5;
                        throw e;
                    }
                }
                return requestor.used;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return true;
    }

    private static Collection<String> getExportedPackages(IPluginModelBase model) {
        BundleDescription bundleDescription;
        IBundlePluginModelBase plugin;
        IBundleModel bundleModel;
        if (model instanceof IBundlePluginModelBase && (bundleModel = (plugin = (IBundlePluginModelBase)model).getBundleModel()) != null) {
            IBundle bundle = bundleModel.getBundle();
            IManifestHeader header = bundle.getManifestHeader("Export-Package");
            if (header instanceof ExportPackageHeader) {
                ExportPackageHeader pkg = (ExportPackageHeader)header;
                return pkg.getPackageNames();
            }
            if (header != null && header.getValue() != null) {
                ExportPackageHeader pkg = new ExportPackageHeader("Export-Package", header.getValue(), bundle, TextUtil.getDefaultLineDelimiter());
                return pkg.getPackageNames();
            }
        }
        if ((bundleDescription = model.getBundleDescription()) != null) {
            return Arrays.stream(bundleDescription.getExportPackages()).map(BaseDescription::getName).toList();
        }
        return List.of();
    }

    protected void removeBuddies() {
        IManifestHeader header;
        IBundlePluginModelBase plugin;
        IBundleModel bundleModel;
        IPluginModelBase iPluginModelBase = this.fModel;
        if (iPluginModelBase instanceof IBundlePluginModelBase && (bundleModel = (plugin = (IBundlePluginModelBase)iPluginModelBase).getBundleModel()) != null && (header = bundleModel.getBundle().getManifestHeader("Eclipse-RegisterBuddy")) != null) {
            String values = header.getValue();
            String[] registerBud = values.split("\\s*,\\s*");
            ArrayList<Object> found = new ArrayList<Object>();
            String[] stringArray = registerBud;
            int n = registerBud.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                for (Object obj : this.fList) {
                    String id;
                    if (!(obj instanceof PluginImport) || !string.equals(id = ((PluginImport)obj).getId())) continue;
                    found.add(obj);
                }
                ++n2;
            }
            this.fList.removeAll(found);
        }
    }

    private void removeReexported() {
        ArrayList<PluginImport> found = new ArrayList<PluginImport>();
        for (Object obj : this.fList) {
            PluginImport plugin;
            if (!(obj instanceof PluginImport) || !(plugin = (PluginImport)obj).isReexported()) continue;
            found.add(plugin);
        }
        this.fList.removeAll(found);
    }

    private void updateMonitor(IProgressMonitor monitor, int size) {
        monitor.setTaskName(PDEUIMessages.UnusedDependencies_analyze + size + " " + PDEUIMessages.UnusedDependencies_unused + " " + (size == 1 ? PDEUIMessages.DependencyExtent_singular : PDEUIMessages.DependencyExtent_plural) + " " + PDEUIMessages.DependencyExtent_found);
    }

    private boolean isUnused(IPluginImport plugin, Set<String> computedPackages, IProgressMonitor monitor) {
        IPluginModelBase[] models;
        IPluginModelBase[] iPluginModelBaseArray = models = PluginJavaSearchUtil.getPluginImports((IPluginImport)plugin);
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            Collection<String> exportedPackages = GatherUnusedDependenciesOperation.getExportedPackages(model);
            for (String exportedPackage : exportedPackages) {
                if (!computedPackages.contains(exportedPackage)) continue;
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isUnused(ImportPackageObject pkg, Collection<String> exportedPackages, Set<String> computedPackages, IProgressMonitor monitor) {
        if (exportedPackages != null && exportedPackages.contains(pkg.getValue())) {
            return false;
        }
        String name = pkg.getName();
        return !computedPackages.contains(name);
    }

    public List<Object> getList() {
        return this.fList;
    }

    public static void removeDependencies(IPluginModelBase model, Object[] elements) {
        ImportPackageHeader pkgHeader = null;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IPluginImport) {
                try {
                    model.getPluginBase().remove((IPluginImport)element);
                }
                catch (CoreException coreException) {}
            } else if (element instanceof ImportPackageObject) {
                if (pkgHeader == null) {
                    pkgHeader = (ImportPackageHeader)((ImportPackageObject)element).getHeader();
                }
                pkgHeader.removePackage((PackageObject)((ImportPackageObject)element));
            }
            ++n2;
        }
    }

    private void minimizeDependencies(Map<String, IPluginImport> usedPlugins, List<ImportPackageObject> usedPackages, IProgressMonitor monitor) {
        ListIterator<ImportPackageObject> li = usedPackages.listIterator();
        while (li.hasNext()) {
            ImportPackageObject ipo = li.next();
            String bundle = ipo.getAttribute("bundle-symbolic-name");
            if (!usedPlugins.containsKey(bundle)) continue;
            this.fList.add(ipo);
        }
        Iterator<String> it = usedPlugins.keySet().iterator();
        ArrayDeque<String> plugins = new ArrayDeque<String>();
        while (it.hasNext()) {
            plugins.push(it.next().toString());
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        while (!plugins.isEmpty()) {
            String pluginId = (String)plugins.pop();
            IPluginModelBase base = PluginRegistry.findModel((String)pluginId);
            if (base == null) continue;
            IPluginImport[] imports = base.getPluginBase().getImports();
            SubMonitor iterationMonitor = subMonitor.setWorkRemaining(Math.max(plugins.size() + 1, 5)).split(1).setWorkRemaining(imports.length);
            IPluginImport[] iPluginImportArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    block8: {
                        IPluginImport imp = iPluginImportArray[n2];
                        if (!imp.isReexported()) break block8;
                        String reExportedId = imp.getId();
                        if (reExportedId != null && reExportedId.equals(pluginId)) break block9;
                        IPluginImport pluginImport = usedPlugins.remove(imp.getId());
                        if (pluginImport != null) {
                            this.fList.add(pluginImport);
                            this.updateMonitor((IProgressMonitor)iterationMonitor, this.fList.size());
                        }
                        plugins.push(reExportedId);
                    }
                    iterationMonitor.worked(1);
                }
                ++n2;
            }
        }
    }

    private static class Requestor
    extends SearchRequestor {
        volatile boolean used;

        private Requestor() {
        }

        public void acceptSearchMatch(SearchMatch match) {
            this.used = true;
        }
    }
}

