/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgitest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IClasspathContributor.class})
public class OSGiTestClasspathContributor
implements IClasspathContributor,
IStateDeltaListener,
IResourceChangeListener {
    private static final int CHANGE_FLAGS = 7;
    private static final IClasspathAttribute TEST_ATTRIBUTE = JavaCore.newClasspathAttribute((String)"test", (String)"true");
    private static final Collection<String> OSGI_TEST_BUNDLES = List.of("org.osgi.test.common", "org.osgi.test.assertj.framework", "org.osgi.test.assertj.log", "org.osgi.test.assertj.promise");
    private static final Collection<String> OSGI_TEST_JUNIT5_BUNDLES = List.of("org.osgi.test.junit5", "org.osgi.test.junit5.cm");
    private static final Collection<String> OSGI_TEST_JUNIT4_BUNDLES = List.of("org.osgi.test.junit4");
    private static final JunitBundles JUNIT5 = new JunitBundles("JUnit 5", () -> OSGiTestClasspathContributor.bundles(true));
    private static final JunitBundles JUNIT4 = new JunitBundles("JUnit 4", () -> OSGiTestClasspathContributor.bundles(false));
    private static final JunitBundles NO_JUNIT = new JunitBundles("No JUnit", () -> Stream.empty());
    private final ConcurrentMap<String, Collection<IClasspathEntry>> entryMap = new ConcurrentHashMap<String, Collection<IClasspathEntry>>();
    private final Map<IProject, JunitProjectBundles> projectBundlesMap = new WeakHashMap<IProject, JunitProjectBundles>();

    @Activate
    void registerListener() {
        PDECore.getDefault().getModelManager().addStateDeltaListener(this);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    void setWorkspace(IWorkspace workspace) {
        workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    void unsetWorkspace(IWorkspace workspace) {
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Deactivate
    void undregisterListener() {
        PDECore.getDefault().getModelManager().removeStateDeltaListener(this);
    }

    public static Stream<String> bundles(boolean junit5) {
        return Stream.concat(OSGI_TEST_BUNDLES.stream(), junit5 ? OSGI_TEST_JUNIT5_BUNDLES.stream() : OSGI_TEST_JUNIT4_BUNDLES.stream());
    }

    @Override
    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IPluginModelBase projectModel = PluginRegistry.findModel((Resource)project);
        if (projectModel == null) {
            return List.of();
        }
        return this.getJunitBundles(projectModel.getUnderlyingResource()).bundles().map(bundleId -> this.entryMap.computeIfAbsent((String)bundleId, id -> ClasspathUtilCore.classpathEntriesForBundle(id, true, new IClasspathAttribute[]{TEST_ATTRIBUTE}).toList())).flatMap(Collection::stream).filter(Predicate.not(entry -> ClasspathUtilCore.isEntryForModel(entry, projectModel))).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JunitBundles getJunitBundles(IResource resource) {
        if (resource == null) {
            return NO_JUNIT;
        }
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            Map<IProject, JunitProjectBundles> map = this.projectBundlesMap;
            synchronized (map) {
                return this.projectBundlesMap.computeIfAbsent(project, JunitProjectBundles::new).getBundles();
            }
        }
        return this.getJunitBundles((IResource)resource.getProject());
    }

    @Override
    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }

    @Override
    public void stateResolved(StateDelta delta) {
        if (delta == null) {
            this.stateChanged(null);
        } else {
            BundleDelta[] bundleDeltaArray = delta.getChanges(7, false);
            int n = bundleDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDelta bundleDelta = bundleDeltaArray[n2];
                this.entryMap.remove(bundleDelta.getBundle().getSymbolicName());
                ++n2;
            }
        }
    }

    @Override
    public void stateChanged(State newState) {
        this.entryMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        final HashSet projects = new HashSet();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IFile file;
                    IResource resource = delta.getResource();
                    if (resource instanceof IFile && (file = (IFile)resource).getName().equals(".classpath")) {
                        projects.add(file.getProject());
                    }
                    return true;
                }
            });
        }
        catch (CoreException delta) {
            // empty catch block
        }
        if (projects.isEmpty()) {
            return;
        }
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        for (IProject project : projects) {
            IPluginModelBase model;
            JunitProjectBundles projectBundles;
            Map<IProject, JunitProjectBundles> map = this.projectBundlesMap;
            synchronized (map) {
                projectBundles = this.projectBundlesMap.get(project);
            }
            if (projectBundles == null || !projectBundles.update() || !project.exists() || !project.isOpen() || (model = manager.findModel(project)) == null) continue;
            try {
                JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{JavaCore.create((IProject)project)}, (IClasspathContainer[])new IClasspathContainer[]{new RequiredPluginsClasspathContainer(model, project)}, null);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private static final class JunitBundles {
        private final Supplier<Stream<String>> bundleName;
        private final String name;

        JunitBundles(String name, Supplier<Stream<String>> bundleName) {
            this.name = name;
            this.bundleName = bundleName;
        }

        public String toString() {
            return this.name;
        }

        Stream<String> bundles() {
            return this.bundleName.get();
        }
    }

    private static final class JunitProjectBundles {
        private final IProject eclipseProject;
        private JunitBundles bundles;

        JunitProjectBundles(IProject project) {
            this.eclipseProject = project;
        }

        synchronized JunitBundles getBundles() {
            if (this.bundles == null) {
                if (this.eclipseProject.isAccessible()) {
                    IJavaProject javaProject = JavaCore.create((IProject)this.eclipseProject);
                    try {
                        IClasspathEntry[] classpath;
                        IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
                        int n = classpath.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClasspathEntry cp = iClasspathEntryArray[n2];
                            if (cp.getEntryKind() == 5) {
                                if (ICoreConstants.JUNIT5_CONTAINER_PATH.equals((Object)cp.getPath())) {
                                    this.bundles = JUNIT5;
                                    return this.bundles;
                                }
                                if (ICoreConstants.JUNIT4_CONTAINER_PATH.equals((Object)cp.getPath())) {
                                    this.bundles = JUNIT4;
                                    return this.bundles;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                this.bundles = NO_JUNIT;
                return this.bundles;
            }
            return this.bundles;
        }

        synchronized boolean update() {
            if (this.bundles == null) {
                return false;
            }
            JunitBundles old = this.bundles;
            this.bundles = null;
            return this.getBundles() != old;
        }
    }
}

