/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.git.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.mylyn.internal.git.core.GitConnector;
import org.eclipse.mylyn.internal.git.core.GitRepository;
import org.eclipse.mylyn.versions.core.Change;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.ScmUser;

class LazyChangeSet
extends ChangeSet {
    private final GitRepository scmRepository;
    private final RevCommit commit;
    private List<Change> delegate;

    public LazyChangeSet(RevCommit r, GitRepository repository) {
        super(LazyChangeSet.getScmUser(r.getCommitterIdent()), LazyChangeSet.getAdjustedCommitTime(r), r.name(), r.getFullMessage(), (ScmRepository)repository, new ArrayList());
        this.commit = r;
        this.scmRepository = repository;
    }

    private static Date getAdjustedCommitTime(RevCommit r) {
        return new Date((long)r.getCommitTime() * 1000L);
    }

    private static ScmUser getScmUser(PersonIdent person) {
        return new ScmUser(person.getEmailAddress(), person.getName(), person.getEmailAddress());
    }

    public List<Change> getChanges() {
        return this.getOrInitDelegate();
    }

    private synchronized List<Change> getOrInitDelegate() {
        if (this.delegate == null) {
            this.delegate = new ArrayList<Change>();
            this.fetchChanges();
        }
        return this.delegate;
    }

    private void fetchChanges() {
        try {
            Repository repository = this.scmRepository.getRepository();
            RevWalk walk = new RevWalk(repository);
            this.delegate.addAll(((GitConnector)this.scmRepository.getConnector()).diffCommit(this.scmRepository, repository, walk, this.commit));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

