/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.log;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassMonitorManager;

@Deprecated
public final class TraceCompassLogUtils {
    private static final Format FORMAT = new DecimalFormat("#.###");
    private static final String ARGS = "args";
    private static final String NAME = "name";
    private static final String CATEGORY = "cat";
    private static final String ID = "id";
    private static final String TID = "tid";
    private static final String PID = "pid";
    private static final String TIMESTAMP = "ts";
    private static final String PHASE = "ph";
    private static final String ARGS_ERROR_MESSAGE = "Data should be in the form of key, value, key1, value1, ... TraceCompassScopeLog was supplied ";
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);

    private TraceCompassLogUtils() {
    }

    public static int traceObjectCreation(Logger logger, Level level, Object item) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        int identityHashCode = System.identityHashCode(item);
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'N', time, threadId);
            TraceCompassLogUtils.appendName(sb, item.getClass().getSimpleName());
            TraceCompassLogUtils.appendId(sb, identityHashCode);
            return sb.append('}').toString();
        });
        return identityHashCode;
    }

    public static void traceObjectDestruction(Logger logger, Level level, Object item) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'D', time, threadId);
            TraceCompassLogUtils.appendName(sb, item.getClass().getSimpleName());
            TraceCompassLogUtils.appendId(sb, System.identityHashCode(item));
            return sb.append('}').toString();
        });
    }

    public static void traceObjectDestruction(Logger logger, Level level, Object item, int uniqueId) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'D', time, threadId);
            TraceCompassLogUtils.appendName(sb, item.getClass().getSimpleName());
            TraceCompassLogUtils.appendId(sb, uniqueId);
            return sb.append('}').toString();
        });
    }

    public static void traceAsyncStart(Logger logger, Level level, @Nullable String name, @Nullable String category, int id, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'b', time, threadId);
            TraceCompassLogUtils.appendName(sb, name);
            TraceCompassLogUtils.appendCategory(sb, category);
            TraceCompassLogUtils.appendId(sb, id);
            return TraceCompassLogUtils.appendArgs(sb, args).append('}').toString();
        });
    }

    public static void traceAsyncNested(Logger logger, Level level, @Nullable String name, @Nullable String category, int id, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'n', time, threadId);
            TraceCompassLogUtils.appendName(sb, name);
            TraceCompassLogUtils.appendCategory(sb, category);
            TraceCompassLogUtils.appendId(sb, id);
            return TraceCompassLogUtils.appendArgs(sb, args).append('}').toString();
        });
    }

    public static void traceAsyncEnd(Logger logger, Level level, @Nullable String name, @Nullable String category, int id, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'e', time, threadId);
            TraceCompassLogUtils.appendName(sb, name);
            TraceCompassLogUtils.appendCategory(sb, category);
            TraceCompassLogUtils.appendId(sb, id);
            return TraceCompassLogUtils.appendArgs(sb, args).append('}').toString();
        });
    }

    public static void traceInstant(Logger logger, Level level, String name, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'i', time, threadId);
            TraceCompassLogUtils.appendName(sb, name);
            return TraceCompassLogUtils.appendArgs(sb, args).append('}').toString();
        });
    }

    public static void traceCounter(Logger logger, Level level, @Nullable String name, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'C', time, threadId);
            TraceCompassLogUtils.appendName(sb, name);
            return TraceCompassLogUtils.appendArgs(sb, args).append('}').toString();
        });
    }

    public static void traceMarker(Logger logger, Level level, @Nullable String name, long duration, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        logger.log(level, () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            TraceCompassLogUtils.appendCommon(sb, 'R', time, threadId);
            TraceCompassLogUtils.appendName(sb, name);
            sb.append(',');
            TraceCompassLogUtils.writeObject(sb, "dur", duration);
            return TraceCompassLogUtils.appendArgs(sb, args).append('}').toString();
        });
    }

    private static StringBuilder appendCommon(StringBuilder appendTo, char phase, long time, long threadId) {
        TraceCompassLogUtils.writeObject(appendTo, TIMESTAMP, FORMAT.format((double)time / 1000.0)).append(',');
        TraceCompassLogUtils.writeObject(appendTo, PHASE, Character.valueOf(phase)).append(',');
        TraceCompassLogUtils.writeObject(appendTo, TID, threadId).append(',');
        return TraceCompassLogUtils.writeObject(appendTo, PID, threadId);
    }

    private static StringBuilder appendName(StringBuilder sb, @Nullable String name) {
        if (name != null) {
            sb.append(',');
            TraceCompassLogUtils.writeObject(sb, NAME, name);
        }
        return sb;
    }

    private static StringBuilder appendCategory(StringBuilder sb, @Nullable String category) {
        if (category != null) {
            sb.append(',');
            TraceCompassLogUtils.writeObject(sb, CATEGORY, category);
        }
        return sb;
    }

    private static StringBuilder appendId(StringBuilder sb, int id) {
        return sb.append(',').append('\"').append(ID).append("\":\"0x").append(Integer.toHexString(id)).append('\"');
    }

    private static StringBuilder appendArgs(StringBuilder sb, Map<String, Object> args) {
        if (!args.isEmpty()) {
            sb.append(',').append('\"').append(ARGS).append('\"').append(':');
            Object[] argsArray = new Object[2 * args.size()];
            Iterator<Map.Entry<String, Object>> entryIter = args.entrySet().iterator();
            int i = 0;
            while (i < args.size()) {
                Map.Entry<String, Object> entry = entryIter.next();
                argsArray[i] = entry.getKey();
                argsArray[i + 1] = entry.getValue();
                ++i;
            }
            TraceCompassLogUtils.getArgs(sb, argsArray);
        }
        return sb;
    }

    private static StringBuilder appendArgs(StringBuilder sb, Object ... args) {
        if (args.length > 0) {
            sb.append(',').append('\"').append(ARGS).append('\"').append(':');
            TraceCompassLogUtils.getArgs(sb, args);
        }
        return sb;
    }

    private static StringBuilder getArgs(StringBuilder appendTo, Object[] data) {
        if (data.length == 0) {
            return appendTo;
        }
        HashSet<String> tester = new HashSet<String>();
        appendTo.append('{');
        if (data.length == 1) {
            appendTo.append("\"msg\":\"").append(data[0]).append('\"');
        } else {
            if (data.length % 2 != 0) {
                throw new IllegalArgumentException("Data should be in the form of key, value, key1, value1, ... TraceCompassScopeLog was supplied an odd number of messages" + Arrays.asList(data).toString());
            }
            int i = 0;
            while (i < data.length - 1) {
                Object value = data[i + 1];
                String keyVal = String.valueOf(data[i]);
                if (tester.contains(keyVal)) {
                    throw new IllegalArgumentException("Data should be in the form of key, value, key1, value1, ... TraceCompassScopeLog was supplied an duplicate field names : " + keyVal);
                }
                tester.add(keyVal);
                if (i > 0) {
                    appendTo.append(',');
                }
                TraceCompassLogUtils.writeObject(appendTo, keyVal, value);
                i += 2;
            }
        }
        return appendTo.append('}');
    }

    private static StringBuilder writeObject(StringBuilder appendTo, Object key, @Nullable Object value) {
        appendTo.append('\"').append(key).append('\"').append(':');
        if (value instanceof Number) {
            appendTo.append(value);
        } else {
            appendTo.append('\"').append(String.valueOf(value)).append('\"');
        }
        return appendTo;
    }

    public static class FlowScopeLog
    implements AutoCloseable {
        private final long fThreadId;
        private final Logger fLogger;
        private final Level fLevel;
        private final int fId;
        private final String fCategory;
        private final Map<String, Object> fData = new HashMap<String, Object>();
        private final String fLabel;
        private final long fTime = System.nanoTime();

        private FlowScopeLog(Logger log, Level level, String label, String category, int id, boolean startFlow, Object ... args) {
            this.fId = id;
            this.fLogger = log;
            this.fLevel = level;
            this.fCategory = category;
            this.fLabel = label;
            this.fThreadId = Thread.currentThread().getId();
            this.fLogger.log(this.fLevel, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                TraceCompassLogUtils.appendCommon(sb, 'B', this.fTime, this.fThreadId);
                TraceCompassLogUtils.appendName(sb, label);
                TraceCompassLogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            });
            this.fLogger.log(this.fLevel, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                TraceCompassLogUtils.appendCommon(sb, startFlow ? (char)'s' : (char)'t', this.fTime, this.fThreadId);
                TraceCompassLogUtils.appendName(sb, label);
                TraceCompassLogUtils.appendCategory(sb, category);
                TraceCompassLogUtils.appendId(sb, this.fId);
                TraceCompassLogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            });
        }

        public void step(String label, Object ... args) {
            long time = System.nanoTime();
            this.fLogger.log(this.fLevel, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                TraceCompassLogUtils.appendCommon(sb, 't', time, this.fThreadId);
                TraceCompassLogUtils.appendName(sb, label);
                TraceCompassLogUtils.appendCategory(sb, this.fCategory);
                TraceCompassLogUtils.appendId(sb, this.fId);
                TraceCompassLogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            });
        }

        public void addData(String name, Object value) {
            this.fData.put(name, value);
        }

        public int getId() {
            return this.fId;
        }

        @Override
        public void close() {
            long time = System.nanoTime();
            this.fLogger.log(this.fLevel, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                TraceCompassLogUtils.appendCommon(sb, 'E', time, this.fThreadId);
                TraceCompassLogUtils.appendArgs(sb, this.fData);
                sb.append('}');
                return sb.toString();
            });
            TraceCompassMonitorManager.getInstance().update(this.fLabel, time - this.fTime);
        }
    }

    public static class FlowScopeLogBuilder {
        private final Logger fLogger;
        private final Level fLevel;
        private final String fLabel;
        private final Object[] fArgs;
        private int fId = Integer.MIN_VALUE;
        private @Nullable String fCategory = null;
        private @Nullable FlowScopeLog fParent = null;
        private boolean fHasParent = false;

        public FlowScopeLogBuilder(Logger logger, Level level, String label, Object ... args) {
            this.fLogger = logger;
            this.fLevel = level;
            this.fLabel = label;
            this.fArgs = args;
        }

        public FlowScopeLogBuilder setCategory(String category) {
            if (this.fParent != null) {
                throw new IllegalStateException("FlowScopeLogBuilder: Cannot set a category if a parent has already been set");
            }
            this.fCategory = category;
            return this;
        }

        public FlowScopeLogBuilder setCategoryAndId(String category, int id) {
            if (this.fParent != null) {
                throw new IllegalStateException("FlowScopeLogBuilder: Cannot set a category if a parent has already been set");
            }
            this.fCategory = category;
            this.fId = id;
            this.fHasParent = true;
            return this;
        }

        public FlowScopeLogBuilder setParentScope(FlowScopeLog parent) {
            if (this.fCategory != null) {
                throw new IllegalStateException("FlowScopeLogBuilder: Cannot set a parent scope if a category has already been set");
            }
            this.fParent = parent;
            return this;
        }

        public FlowScopeLog build() {
            FlowScopeLog parent = this.fParent;
            if (parent != null) {
                return new FlowScopeLog(this.fLogger, this.fLevel, this.fLabel, parent.fCategory, parent.fId, false, this.fArgs);
            }
            return new FlowScopeLog(this.fLogger, this.fLevel, this.fLabel, String.valueOf(this.fCategory), this.fId == Integer.MIN_VALUE ? ID_GENERATOR.incrementAndGet() : this.fId, !this.fHasParent, this.fArgs);
        }
    }

    public static class ScopeLog
    implements AutoCloseable {
        private final long fTime;
        private final long fThreadId;
        private final Logger fLogger;
        private final Level fLevel;
        private final String fLabel;
        private final Map<String, Object> fData = new HashMap<String, Object>();

        public ScopeLog(Logger log, Level level, String label, Object ... args) {
            this.fTime = System.nanoTime();
            this.fLogger = log;
            this.fLevel = level;
            this.fThreadId = Thread.currentThread().getId();
            this.fLabel = label;
            this.fLogger.log(this.fLevel, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                TraceCompassLogUtils.appendCommon(sb, 'B', this.fTime, this.fThreadId);
                TraceCompassLogUtils.appendName(sb, this.fLabel);
                TraceCompassLogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            });
        }

        public void addData(String name, Object value) {
            this.fData.put(name, value);
        }

        @Override
        public void close() {
            long time = System.nanoTime();
            this.fLogger.log(this.fLevel, () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                TraceCompassLogUtils.appendCommon(sb, 'E', time, this.fThreadId);
                return TraceCompassLogUtils.appendArgs(sb, this.fData).append('}').toString();
            });
            TraceCompassMonitorManager.getInstance().update(this.fLabel, time - this.fTime);
        }
    }
}

