/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class HasLanguageServerPropertyTester
extends PropertyTester {
    public boolean test(@Nullable Object receiver, String property, Object[] args, @Nullable Object expectedValue) {
        if (receiver instanceof IFile) {
            IFile file = (IFile)receiver;
            return LanguageServersRegistry.getInstance().canUseLanguageServer(file);
        }
        if (receiver instanceof IEditorInput) {
            IEditorInput editorInput = (IEditorInput)receiver;
            return LanguageServersRegistry.getInstance().canUseLanguageServer(editorInput);
        }
        if (receiver instanceof IDocument) {
            IDocument document = (IDocument)receiver;
            return LanguageServersRegistry.getInstance().canUseLanguageServer(document);
        }
        if (receiver instanceof ITextViewer) {
            ITextViewer viewer = (ITextViewer)receiver;
            return this.test(viewer);
        }
        if (receiver instanceof IEditorPart) {
            IEditorPart part = (IEditorPart)receiver;
            return this.test(UI.asTextViewer(part));
        }
        return false;
    }

    private boolean test(@Nullable ITextViewer viewer) {
        IDocument document;
        if (viewer != null && (document = viewer.getDocument()) != null) {
            return LanguageServersRegistry.getInstance().canUseLanguageServer(document);
        }
        return false;
    }
}

