/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui.auth;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.CertificateCredentials;
import org.eclipse.mylyn.commons.ui.dialogs.CredentialsDialog;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.AbstractCredentialsProviderUi;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.Messages;
import org.eclipse.swt.widgets.Shell;

public class CertificateCredentialsProviderUi
extends AbstractCredentialsProviderUi<CertificateCredentials> {
    private CertificateCredentials credentials;

    @Override
    public CertificateCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public IStatus open(Shell shell, AuthenticationRequest<AuthenticationType<CertificateCredentials>> request) {
        CredentialsDialog dialog = new CredentialsDialog(shell, CredentialsDialog.Mode.USER);
        CertificateCredentials oldCredentials = (CertificateCredentials)request.getLocation().getCredentials(request.getAuthenticationType());
        if (oldCredentials != null) {
            dialog.setKeyStoreFileName(oldCredentials.getKeyStoreFileName());
            dialog.setPassword(oldCredentials.getPassword());
        }
        if (request.getMessage() != null) {
            dialog.setMessage(request.getMessage());
        } else {
            dialog.setMessage(this.getDefaultMessage(request));
        }
        int resultCode = dialog.open();
        if (resultCode == 0) {
            this.credentials = new CertificateCredentials(dialog.getKeyStoreFileName(), dialog.getPassword(), null);
            request.getLocation().setCredentials(request.getAuthenticationType(), (AuthenticationCredentials)oldCredentials);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private String getDefaultMessage(AuthenticationRequest<AuthenticationType<CertificateCredentials>> request) {
        AuthenticationType authType = request.getAuthenticationType();
        if (AuthenticationType.CERTIFICATE == authType) {
            return Messages.CertificateCredentialsProviderUi_Enter_key_store_password;
        }
        return null;
    }
}

