/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;

public class DLineCandidate {
    private final LineContainer viewContainer;
    private final EObject semantic;
    private final LineMapping mapping;
    private DLine element;
    private int hashcode;
    private RefreshIdsHolder ids;

    public DLineCandidate(LineMapping mapping, EObject semanticElement, LineContainer viewContainer, RefreshIdsHolder ids) {
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.viewContainer = viewContainer;
        this.ids = ids;
        this.hashcode = this.computeHashCode();
    }

    public DLineCandidate(DLine tableElement, RefreshIdsHolder ids) {
        this(tableElement.getOriginMapping(), tableElement.getTarget(), (LineContainer)tableElement.eContainer(), ids);
        this.element = tableElement;
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DLine getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashcode;
    }

    private int computeHashCode() {
        int[] parts = new int[]{this.mapping == null ? 0 : this.getMappingID(), this.semantic == null ? 0 : this.getSemanticID(), this.viewContainer == null ? 0 : this.getViewContainerID()};
        return KeyCache.DEFAULT.getKey(parts[0] + "/" + parts[1] + "/" + parts[2]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DLineCandidate)) {
            return false;
        }
        DLineCandidate other = (DLineCandidate)obj;
        if (this.semantic == null ? other.semantic != null : !this.getSemanticID().equals(other.getSemanticID())) {
            return false;
        }
        if (this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping)) {
            return false;
        }
        return !(this.viewContainer == null ? other.viewContainer != null : !this.getViewContainerID().equals(other.getViewContainerID()));
    }

    private Integer getViewContainerID() {
        if (this.viewContainer == null) {
            return -1;
        }
        return this.ids.getOrCreateID((EObject)this.viewContainer);
    }

    private Integer getSemanticID() {
        if (this.semantic == null) {
            return -1;
        }
        return this.ids.getOrCreateID(this.semantic);
    }

    private Integer getMappingID() {
        return this.ids.getOrCreateID((EObject)this.mapping);
    }

    public LineMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }

    public LineContainer getViewContainer() {
        return this.viewContainer;
    }
}

