/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class SaveAllDirtyEditorsDialog
extends ListDialog {
    public SaveAllDirtyEditorsDialog(Shell parent) {
        super(parent);
        this.setTitle(CommonUIMessages.SaveAllDirtyEditorsDialog_title);
        this.setMessage(CommonUIMessages.SaveAllDirtyEditorsDialog_message);
        this.setAddCancelButton(true);
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        });
        this.setContentProvider(new IStructuredContentProvider(){
            List fContents;

            public Object[] getElements(Object inputElement) {
                if (this.fContents != null && this.fContents == inputElement) {
                    return this.fContents.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.fContents = newInput instanceof List ? (List)newInput : null;
            }

            public void dispose() {
            }
        });
        this.setInput(Arrays.asList(SaveAllDirtyEditorsDialog.getDirtyEditors()));
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }
}

