/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.ide.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;

public class ValidationUIIDEPlugin
extends EMFPlugin {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    public static final ValidationUIIDEPlugin INSTANCE = new ValidationUIIDEPlugin();
    private static Implementation plugin;

    public ValidationUIIDEPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }

    public static class Tracing {
        private static final Map<String, Boolean> cachedOptions = new HashMap<String, Boolean>();

        protected static boolean shouldTrace() {
            return plugin.isDebugging();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean shouldTrace(String option) {
            if (Tracing.shouldTrace()) {
                Boolean value = null;
                Map<String, Boolean> map = cachedOptions;
                synchronized (map) {
                    value = cachedOptions.get(option);
                    if (value == null) {
                        value = Boolean.valueOf(Platform.getDebugOption((String)option));
                        cachedOptions.put(option, value);
                    }
                }
                return value;
            }
            return false;
        }

        protected static String getArgumentString(Object argument) {
            return String.valueOf(argument);
        }

        protected static String getArgumentsString(Object[] arguments) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < arguments.length) {
                buffer.append(Tracing.getArgumentString(arguments[i]));
                if (i < arguments.length - 1) {
                    buffer.append(ValidationUIIDEPlugin.SEPARATOR_PARAMETER);
                }
                ++i;
            }
            return buffer.toString();
        }

        public static void trace(String message) {
            if (Tracing.shouldTrace()) {
                System.out.println(message);
            }
        }

        public static void trace(String option, String message) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(message);
            }
        }

        public static void changing(String option, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIIDEPlugin.PREFIX_CHANGING + valueDescription + " old=" + Tracing.getArgumentString(oldValue) + ", new=" + Tracing.getArgumentString(newValue));
            }
        }

        public static void changing(String option, Class<?> clazz, String methodName, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIIDEPlugin.PREFIX_CHANGING + valueDescription + " old=" + Tracing.getArgumentString(oldValue) + ", new=" + Tracing.getArgumentString(newValue) + " (" + clazz.getName() + ValidationUIIDEPlugin.SEPARATOR_METHOD + methodName + ValidationUIIDEPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void catching(String option, Class<?> clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIIDEPlugin.PREFIX_CATCHING + throwable.getMessage() + " (" + clazz.getName() + ValidationUIIDEPlugin.SEPARATOR_METHOD + methodName + ValidationUIIDEPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void throwing(String option, Class<?> clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIIDEPlugin.PREFIX_THROWING + throwable.getMessage() + " (" + clazz.getName() + ValidationUIIDEPlugin.SEPARATOR_METHOD + methodName + ValidationUIIDEPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void entering(String option, Class<?> clazz, String methodName, Object ... parameters) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIIDEPlugin.PREFIX_ENTERING + clazz.getName() + ValidationUIIDEPlugin.SEPARATOR_METHOD + methodName + ValidationUIIDEPlugin.PARENTHESIS_OPEN + Tracing.getArgumentsString(parameters) + ValidationUIIDEPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void exiting(String option, Class<?> clazz, String methodName) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIIDEPlugin.PREFIX_EXITING + clazz.getName() + ValidationUIIDEPlugin.SEPARATOR_METHOD + methodName);
            }
        }

        public static void exiting(String option, Class<?> clazz, String methodName, Object returnValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIIDEPlugin.PREFIX_EXITING + clazz.getName() + ValidationUIIDEPlugin.SEPARATOR_METHOD + methodName + ValidationUIIDEPlugin.SEPARATOR_RETURN + Tracing.getArgumentString(returnValue));
            }
        }
    }
}

