/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.xtext.formatting2.internal.TextReplacementList;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionRewriter;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextReplacement;

public class TextRegionRewriter
implements ITextRegionRewriter {
    private final ITextRegionAccess access;

    public TextRegionRewriter(ITextRegionAccess access) {
        this.access = access;
    }

    @Override
    public void renderToAppendable(Iterable<? extends ITextReplacement> replacements, Appendable result) throws IOException {
        this.renderToAppendable(this.access.regionForDocument(), replacements, result);
    }

    @Override
    public void renderToAppendable(ITextSegment input, Iterable<? extends ITextReplacement> rep, Appendable result) throws IOException {
        int offset = input.getOffset();
        String text = input.getText();
        TextReplacementList<? extends ITextReplacement> list = new TextReplacementList<ITextReplacement>(rep);
        Collections.sort(list);
        int lastOffset = 0;
        for (ITextReplacement iTextReplacement : list) {
            result.append(text.subSequence(lastOffset, iTextReplacement.getOffset() - offset));
            result.append(iTextReplacement.getReplacementText());
            lastOffset = iTextReplacement.getOffset() - offset + iTextReplacement.getLength();
        }
        if (lastOffset <= text.length()) {
            result.append(text.subSequence(lastOffset, text.length()));
        }
    }

    @Override
    public String renderToString(Iterable<? extends ITextReplacement> replacements) {
        StringBuilder result = new StringBuilder();
        try {
            this.renderToAppendable(replacements, result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    @Override
    public String renderToString(ITextSegment input, Iterable<? extends ITextReplacement> replacements) {
        StringBuilder result = new StringBuilder();
        try {
            this.renderToAppendable(input, replacements, result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    @Override
    public ITextReplacement createReplacement(int offset, int length, String text) {
        return new TextReplacement(this.access, offset, length, text);
    }
}

