/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.colorlist.WC;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedShape;
import org.eclipse.gef.dot.internal.language.shape.Shape;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.conversion.DotNodeStyleUtil;
import org.eclipse.gef.graph.Node;

public class DotDefaultNodeStyleUtil
implements DotNodeStyleUtil {
    protected final DotColorUtil colorUtil;
    protected final Node dot;

    public DotDefaultNodeStyleUtil(DotColorUtil colorUtil, Node dot) {
        this.colorUtil = colorUtil;
        this.dot = dot;
    }

    @Override
    public StringBuilder computeZestStyle() {
        StringBuilder zestStyle = new StringBuilder();
        Color dotColor = this.colorAttribute();
        String dotColorScheme = this.colorschemeAttribute();
        String javaFxColor = this.colorUtil.computeZestColor(dotColorScheme, dotColor);
        Double penwidth = this.penwidthAttribute();
        if (this.isNoneShape(this.shapeAttribute())) {
            zestStyle.append("-fx-stroke: none;");
        } else {
            if (javaFxColor != null) {
                zestStyle.append(this.strokeColorFxCssString());
                zestStyle.append(javaFxColor);
                zestStyle.append(";");
            }
            if (penwidth != null) {
                zestStyle.append(this.strokeWidthFxCssString());
                zestStyle.append(penwidth);
                zestStyle.append(";");
            }
        }
        Style style = this.styleAttribute();
        if (style != null) {
            for (StyleItem styleItem : style.getStyleItems()) {
                NodeStyle nodeStyle = NodeStyle.get((String)styleItem.getName());
                if (nodeStyle == null) continue;
                this.addNodeStyle(zestStyle, nodeStyle, penwidth == null);
            }
        }
        if (this.fillCondition()) {
            Color dotFillColor = null;
            ColorList fillColor = this.fillcolorAttribute();
            dotFillColor = fillColor != null && !fillColor.getColorValues().isEmpty() ? ((WC)fillColor.getColorValues().get(0)).getColor() : (dotColor != null ? dotColor : DotColors.getDefaultNodeFillColor());
            String javaFxFillColor = this.colorUtil.computeZestColor(dotColorScheme, dotFillColor);
            if (javaFxFillColor != null) {
                zestStyle.append(String.valueOf(this.fillFxCssString()) + javaFxFillColor + ";");
            }
        }
        return zestStyle;
    }

    @Override
    public boolean hasStyle(NodeStyle nodeStyle) {
        Style nodeStyleParsed = this.styleAttribute();
        if (nodeStyleParsed != null) {
            for (StyleItem styleItem : nodeStyleParsed.getStyleItems()) {
                if (!styleItem.getName().equals(nodeStyle.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNoneShape(Shape dotShape) {
        EObject shape;
        if (dotShape != null && (shape = dotShape.getShape()) instanceof PolygonBasedShape) {
            return ((PolygonBasedShape)shape).getShape() == PolygonBasedNodeShape.NONE;
        }
        return false;
    }

    protected void addNodeStyle(StringBuilder zestStyle, NodeStyle style, boolean penwidthUnset) {
        switch (style) {
            case BOLD: {
                if (!penwidthUnset) break;
                zestStyle.append("-fx-stroke-width:2;");
                break;
            }
            case DASHED: {
                zestStyle.append("-fx-stroke-dash-array: 7 7;");
                break;
            }
            case DIAGONALS: {
                break;
            }
            case DOTTED: {
                zestStyle.append("-fx-stroke-dash-array: 1 6;");
                break;
            }
            case RADIAL: {
                break;
            }
            case ROUNDED: {
                break;
            }
            case SOLID: {
                if (!penwidthUnset) break;
                zestStyle.append("-fx-stroke-width:1;");
                break;
            }
            case STRIPED: {
                break;
            }
        }
    }

    protected String fillFxCssString() {
        return "-fx-fill: ";
    }

    protected String strokeWidthFxCssString() {
        return "-fx-stroke-width:";
    }

    protected String strokeColorFxCssString() {
        return "-fx-stroke: ";
    }

    protected Shape shapeAttribute() {
        return DotAttributes.getShapeParsed((Node)this.dot);
    }

    protected String colorschemeAttribute() {
        return DotAttributes.getColorscheme((Node)this.dot);
    }

    protected Color colorAttribute() {
        return DotAttributes.getColorParsed((Node)this.dot);
    }

    protected Double penwidthAttribute() {
        return DotAttributes.getPenwidthParsed((Node)this.dot);
    }

    protected ColorList fillcolorAttribute() {
        return DotAttributes.getFillcolorParsed((Node)this.dot);
    }

    protected boolean fillCondition() {
        return this.hasStyle(NodeStyle.FILLED);
    }

    protected Style styleAttribute() {
        return DotAttributes.getStyleParsed((Node)this.dot);
    }
}

