/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class AttachmentSourcePage
extends WizardPage {
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected static final int COMBO_HISTORY_LENGTH = 5;
    protected static final int CLIPBOARD = 1;
    protected static final int FILE = 2;
    protected static final int WORKSPACE = 3;
    protected static final int SCREENSHOT = 4;
    static final char SEPARATOR = FileSystems.getDefault().getSeparator().charAt(0);
    private boolean showError = false;
    private Button useClipboardButton;
    private Combo fileNameField;
    private Button fileBrowseButton;
    private Button useFileButton;
    private Button useWorkspaceButton;
    private Label workspaceSelectLabel;
    private TreeViewer treeViewer;
    private String clipboardContents;
    private boolean initUseClipboard = false;
    private final String DIALOG_SETTINGS = "InputAttachmentSourcePage";
    private final String S_LAST_SELECTION = "lastSelection";
    private final String S_FILE_HISTORY = "fileHistory";
    private final String S_LAST_FILE = "lastFile";
    private final TaskAttachmentModel model;
    private String lastFilename;

    public AttachmentSourcePage(TaskAttachmentModel model) {
        super("InputAttachmentPage");
        this.model = model;
        this.setTitle(Messages.AttachmentSourcePage_Select_attachment_source);
        this.setDescription(Messages.AttachmentSourcePage_Clipboard_supports_text_and_image_attachments_only);
    }

    private void restoreDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            this.updateWidgetEnablements();
            return;
        }
        String selection = settings.get("lastSelection");
        if (selection != null) {
            this.setInputMethod(Integer.parseInt(selection));
        } else {
            this.updateWidgetEnablements();
        }
        String[] fileNames = settings.getArray("fileHistory");
        if (fileNames != null) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                this.fileNameField.add(fileName);
                ++n2;
            }
        }
        this.lastFilename = settings.get("lastFile");
    }

    protected IPath getPathFromText(Text textField) {
        return new Path(textField.getText()).makeAbsolute();
    }

    public String getAttachmentName() {
        if (this.getInputMethod() == 1) {
            return Messages.AttachmentSourcePage__Clipboard_;
        }
        if (this.getInputMethod() == 3) {
            return AttachmentSourcePage.getResources(this.treeViewer.getSelection())[0].getFullPath().toOSString();
        }
        return this.getAttachmentFilePath();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(272);
        gd.heightHint = 800;
        composite.setLayoutData((Object)gd);
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        this.createAttachmentFileGroup(composite);
        this.showError = false;
        this.clearErrorMessage();
        this.restoreDialogSettings();
        Dialog.applyDialogFont((Control)composite);
    }

    public IWizardPage getNextPage() {
        AbstractTaskAttachmentSource source = this.getSource();
        this.model.setSource(source);
        if (source != null) {
            this.model.setContentType(source.getContentType());
        }
        this.saveDialogSettings();
        return super.getNextPage();
    }

    private void saveDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put("lastSelection", this.getInputMethod());
        String[] fileNames = settings.getArray("fileHistory");
        String newFileName = this.fileNameField.getText().trim();
        if (this.getInputMethod() == 2 && newFileName.length() > 0) {
            ArrayList<String> history = new ArrayList<String>(10);
            history.add(newFileName);
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length && history.size() < 5) {
                    if (!newFileName.equals(fileNames[i])) {
                        history.add(fileNames[i]);
                    }
                    ++i;
                }
            }
            settings.put("fileHistory", history.toArray(new String[0]));
        }
        settings.put("lastFile", this.lastFilename);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void setEnableAttachmentFile(boolean enable) {
        this.fileNameField.setEnabled(enable);
        this.fileBrowseButton.setEnabled(enable);
    }

    private void setEnableWorkspaceAttachment(boolean enable) {
        this.workspaceSelectLabel.setEnabled(enable);
        this.treeViewer.getTree().setEnabled(enable);
    }

    private void createAttachmentFileGroup(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(32);
        this.useFileButton = new Button(composite, 16);
        this.useFileButton.setText(Messages.AttachmentSourcePage_File);
        this.fileNameField = new Combo(composite, 2048);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.fileNameField.setLayoutData((Object)gd);
        this.fileNameField.setText("");
        this.fileBrowseButton = new Button(composite, 8);
        this.fileBrowseButton.setText(Messages.AttachmentSourcePage_Browse_);
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = this.fileBrowseButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        this.fileBrowseButton.setLayoutData((Object)data);
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.useClipboardButton = new Button(composite, 16);
        this.useClipboardButton.setText(Messages.AttachmentSourcePage_Clipboard);
        this.useClipboardButton.setLayoutData((Object)gd);
        this.useClipboardButton.setSelection(this.initUseClipboard);
        this.useWorkspaceButton = new Button(composite, 16);
        this.useWorkspaceButton.setText(Messages.AttachmentSourcePage_Workspace);
        gd = new GridData(32);
        this.useWorkspaceButton.setLayoutData((Object)gd);
        this.addWorkspaceControls(parent);
        this.useClipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AttachmentSourcePage.this.useClipboardButton.getSelection()) {
                    return;
                }
                AttachmentSourcePage.this.clearErrorMessage();
                AttachmentSourcePage.this.showError = true;
                AttachmentSourcePage.this.storeClipboardContents();
                AttachmentSourcePage.this.updateWidgetEnablements();
            }
        });
        this.useFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AttachmentSourcePage.this.useFileButton.getSelection()) {
                    return;
                }
                AttachmentSourcePage.this.clearErrorMessage();
                AttachmentSourcePage.this.showError = AttachmentSourcePage.this.fileNameField.getText() != "";
                AttachmentSourcePage.this.updateWidgetEnablements();
            }
        });
        this.fileNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachmentSourcePage.this.setSourceName(AttachmentSourcePage.this.fileNameField.getText());
                AttachmentSourcePage.this.updateWidgetEnablements();
            }
        });
        this.fileNameField.addModifyListener(e -> {
            this.clearErrorMessage();
            this.showError = true;
            this.updateWidgetEnablements();
        });
        this.fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachmentSourcePage.this.clearErrorMessage();
                AttachmentSourcePage.this.showError = true;
                FileDialog fileChooser = new FileDialog(composite.getShell(), 4096);
                fileChooser.setText(Messages.AttachmentSourcePage_Select_File_Dialog_Title);
                if (AttachmentSourcePage.this.fileNameField.getText().trim().length() > 0) {
                    AttachmentSourcePage.this.lastFilename = AttachmentSourcePage.this.fileNameField.getText().trim();
                }
                fileChooser.setFileName(AttachmentSourcePage.this.lastFilename);
                String file = fileChooser.open();
                if (file == null) {
                    return;
                }
                AttachmentSourcePage.this.lastFilename = file;
                AttachmentSourcePage.this.fileNameField.setText(file);
                AttachmentSourcePage.this.updateWidgetEnablements();
            }
        });
        this.useWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AttachmentSourcePage.this.useWorkspaceButton.getSelection()) {
                    return;
                }
                AttachmentSourcePage.this.clearErrorMessage();
                AttachmentSourcePage.this.showError = !AttachmentSourcePage.this.treeViewer.getSelection().isEmpty();
                AttachmentSourcePage.this.updateWidgetEnablements();
            }
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            this.clearErrorMessage();
            this.updateWidgetEnablements();
        });
        this.treeViewer.addDoubleClickListener(event -> {
            TreeSelection treeSel;
            Object res;
            ISelection selection = event.getSelection();
            if (selection instanceof TreeSelection && (res = (treeSel = (TreeSelection)selection).getFirstElement()) != null) {
                if (res instanceof IProject || res instanceof IFolder) {
                    if (this.treeViewer.getExpandedState(res)) {
                        this.treeViewer.collapseToLevel(res, 1);
                    } else {
                        this.treeViewer.expandToLevel(res, 1);
                    }
                } else if (res instanceof IFile) {
                    this.getContainer().showPage(this.getNextPage());
                }
            }
        });
        this.useFileButton.setSelection(!this.initUseClipboard);
        this.setEnableWorkspaceAttachment(false);
    }

    private void addWorkspaceControls(Composite composite) {
        Composite newComp = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 16;
        newComp.setLayout((Layout)layout);
        newComp.setLayoutData((Object)new GridData(1808));
        this.workspaceSelectLabel = new Label(newComp, 16384);
        this.workspaceSelectLabel.setText(Messages.AttachmentSourcePage_Select_the_location_of_the_attachment);
        this.treeViewer = new TreeViewer(newComp, 2048);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.treeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    private void updateWidgetEnablements() {
        String error = null;
        boolean attachmentFound = false;
        int inputMethod = this.getInputMethod();
        if (inputMethod == 1) {
            if (TaskAttachmentWizard.ClipboardTaskAttachmentSource.isSupportedType(this.getControl().getDisplay())) {
                attachmentFound = true;
            } else {
                error = Messages.AttachmentSourcePage_Clipboard_contains_an_unsupported_data;
            }
        } else if (inputMethod == 4) {
            attachmentFound = true;
        } else if (inputMethod == 2) {
            String path = this.fileNameField.getText();
            if (path != null && path.length() > 0) {
                File file = new File(path);
                boolean bl = attachmentFound = file.exists() && file.isFile() && file.length() > 0L;
                if (!attachmentFound) {
                    error = Messages.AttachmentSourcePage_Cannot_locate_attachment_file;
                }
            } else {
                error = Messages.AttachmentSourcePage_No_file_name;
            }
        } else if (inputMethod == 3) {
            IResource[] resources = AttachmentSourcePage.getResources(this.treeViewer.getSelection());
            if (resources == null || resources.length <= 0) {
                error = Messages.AttachmentSourcePage_No_file_name;
            } else {
                IResource attachmentFile = resources[0];
                if (attachmentFile != null && attachmentFile.getType() == 1) {
                    File actualFile = attachmentFile.getRawLocation().toFile();
                    boolean bl = attachmentFound = actualFile.exists() && actualFile.isFile() && actualFile.length() > 0L;
                    if (!attachmentFound) {
                        error = Messages.AttachmentSourcePage_Cannot_locate_attachment_file;
                    }
                }
            }
        }
        this.setPageComplete(attachmentFound);
        if (this.showError) {
            this.setErrorMessage(error);
        }
        this.setEnableAttachmentFile(inputMethod == 2);
        this.setEnableWorkspaceAttachment(inputMethod == 3);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.fileNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.fileNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.fileNameField.select(selectionIndex);
        }
    }

    private void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    protected int getInputMethod() {
        if (this.useClipboardButton == null) {
            if (this.initUseClipboard) {
                return 1;
            }
            return 2;
        }
        if (this.useClipboardButton.getSelection()) {
            return 1;
        }
        if (this.useFileButton.getSelection()) {
            return 2;
        }
        return 3;
    }

    protected void setInputMethod(int input) {
        switch (input) {
            case 3: {
                this.useWorkspaceButton.setSelection(true);
                this.useClipboardButton.setSelection(false);
                this.useFileButton.setSelection(false);
                break;
            }
            case 1: {
                this.storeClipboardContents();
                this.useClipboardButton.setSelection(true);
                this.useFileButton.setSelection(false);
                this.useWorkspaceButton.setSelection(false);
                break;
            }
            default: {
                this.useFileButton.setSelection(true);
                this.useWorkspaceButton.setSelection(false);
                this.useClipboardButton.setSelection(false);
            }
        }
        this.updateWidgetEnablements();
    }

    private String getAttachmentFilePath() {
        if (this.fileNameField != null) {
            return this.fileNameField.getText();
        }
        return null;
    }

    public String getAbsoluteAttachmentPath() {
        switch (this.getInputMethod()) {
            case 1: {
                return Messages.AttachmentSourcePage__Clipboard_;
            }
            case 4: {
                return Messages.AttachmentSourcePage__Screenshot_;
            }
            case 3: {
                IResource[] resources = AttachmentSourcePage.getResources(this.treeViewer.getSelection());
                if (resources.length > 0 && resources[0].getRawLocation() != null) {
                    return resources[0].getRawLocation().toOSString();
                }
                return null;
            }
        }
        return this.getAttachmentFilePath();
    }

    public static IResource[] getResources(ISelection selection) {
        ArrayList<IResource> tmp = new ArrayList<IResource>();
        Class<IResource> type = IResource.class;
        if (selection instanceof IStructuredSelection) {
            Object[] s;
            Object[] objectArray = s = ((IStructuredSelection)selection).toArray();
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable a;
                Object adapter;
                Object o = objectArray[n2];
                IResource resource = null;
                if (type.isInstance(o)) {
                    resource = (IResource)o;
                } else if (o instanceof ResourceMapping) {
                    try {
                        ResourceTraversal[] travs = ((ResourceMapping)o).getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                        if (travs != null) {
                            ResourceTraversal[] resourceTraversalArray = travs;
                            int n3 = travs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource[] resources;
                                ResourceTraversal trav = resourceTraversalArray[n4];
                                IResource[] iResourceArray = resources = trav.getResources();
                                int n5 = resources.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IResource resource2 = iResourceArray[n6];
                                    if (type.isInstance(resource2) && resource2.isAccessible()) {
                                        tmp.add(resource2);
                                    }
                                    ++n6;
                                }
                                ++n4;
                            }
                        }
                    }
                    catch (CoreException travs) {}
                } else if (o instanceof IAdaptable && type.isInstance(adapter = (a = (IAdaptable)o).getAdapter(IResource.class))) {
                    resource = (IResource)adapter;
                }
                if (resource != null && resource.isAccessible()) {
                    tmp.add(resource);
                }
                ++n2;
            }
        }
        return tmp.toArray(new IResource[tmp.size()]);
    }

    private void storeClipboardContents() {
        Control c = this.getControl();
        if (c != null) {
            Clipboard clipboard = new Clipboard(c.getDisplay());
            Object o = clipboard.getContents((Transfer)TextTransfer.getInstance());
            clipboard.dispose();
            if (o instanceof String) {
                this.clipboardContents = ((String)o).trim();
            }
        }
    }

    public String getClipboardContents() {
        return this.clipboardContents;
    }

    public void setClipboardContents(String attachContents) {
        this.clipboardContents = attachContents;
    }

    public void setUseClipboard(boolean b) {
        if (this.useClipboardButton != null) {
            this.useClipboardButton.setSelection(b);
        }
        this.initUseClipboard = b;
    }

    protected IDialogSettings getDialogSettings() {
        TasksUiPlugin plugin = TasksUiPlugin.getDefault();
        IDialogSettings settings = plugin.getDialogSettings();
        IDialogSettings section = settings.getSection("InputAttachmentSourcePage");
        if (section == null) {
            section = settings.addNewSection("InputAttachmentSourcePage");
        }
        return section;
    }

    public AbstractTaskAttachmentSource getSource() {
        switch (this.getInputMethod()) {
            case 1: {
                return new TaskAttachmentWizard.ClipboardTaskAttachmentSource();
            }
            case 3: {
                IResource[] resources = AttachmentSourcePage.getResources(this.treeViewer.getSelection());
                if (resources.length > 0) {
                    return new FileTaskAttachmentSource(resources[0].getLocation().toFile());
                }
                return null;
            }
        }
        return new FileTaskAttachmentSource(new File(this.getAttachmentFilePath()));
    }
}

